/*
 * Copyright (c) 2017. GLiNTECH Pty Ltd.
 */

import React from "react";
import { removeWatchingUser } from "../../actions/BlogWatchersActions.js";
import SmallAvatar from "../common/SmallAvatar.js";

export default class BlogWatchersUserRow extends React.Component {
    render() {
        var user = this.props.user;
        var avatar = this._getAvatarUrl(user);
        return (
            <tr key={user.username}>
                <td className="avatar">
                    <SmallAvatar avatar={avatar} />
                </td>
                <td className="data">
                    {user.title} ({user.username})
                </td>
                <td className="button">
                    <button
                        onClick={this._delete.bind(this)}
                        className="aui-button aui-button-link"
                    >
                        <span className="aui-icon aui-icon-small aui-iconfont-remove">Remove</span>
                    </button>
                </td>
            </tr>
        );
    }

    _getAvatarUrl(user) {
        var url = user.thumbnailLink.href;
        if (url.charAt(0) === "/") {
            url = AJS.contextPath() + url;
        }

        return url;
    }

    _delete() {
        return removeWatchingUser(this.props.user);
    }
}
