/*
 * Copyright (c) 2017. GLiNTECH Pty Ltd.
 */

import React from "react";
import { removeWatchingGroup } from "../../actions/BlogWatchersActions.js";

export default class BlogWatchersGroupRow extends React.Component {
    render() {
        var group = this.props.group;
        return (
            <tr key={group.name}>
                <td className="data">{group.name}</td>
                <td className="button">
                    <button
                        onClick={this._delete.bind(this)}
                        className="aui-button aui-button-link"
                    >
                        <span className="aui-icon aui-icon-small aui-iconfont-remove">Remove</span>
                    </button>
                </td>
            </tr>
        );
    }

    _delete() {
        return removeWatchingGroup(this.props.group);
    }
}
