/*
 * Copyright (c) 2017. GLiNTECH Pty Ltd.
 */

import AppDispatcher from "../dispatchers/AppDispatcher.js";
import BlogWatchersConstants from "../constants/BlogWatchersConstants.js";

export const searchForUserOrGroup = (query) => {
    AppDispatcher.dispatch({
        type: BlogWatchersConstants.ActionTypes.SEARCH_FOR_USER_GROUP,
        data: query,
    });
};

export const setSelectedResult = (i) => {
    AppDispatcher.dispatch({
        type: BlogWatchersConstants.ActionTypes.SELECT_RESULT,
        data: i,
    });
};

export const chooseResult = (i) => {
    AppDispatcher.dispatch({
        type: BlogWatchersConstants.ActionTypes.CHOOSE_RESULT,
        data: i,
    });
};

export const removeWatchingUser = (watcher) => {
    AppDispatcher.dispatch({
        type: BlogWatchersConstants.ActionTypes.REMOVE_WATCHING_USER,
        data: watcher,
    });
};

export const removeWatchingGroup = (group) => {
    AppDispatcher.dispatch({
        type: BlogWatchersConstants.ActionTypes.REMOVE_WATCHING_GROUP,
        data: group,
    });
};

export const setSpaceOptions = (options) => {
    AppDispatcher.dispatch({
        type: BlogWatchersConstants.ActionTypes.SET_SPACE_OPTIONS,
        data: options,
    });
};

export const clear = () => {
    AppDispatcher.dispatch({
        type: BlogWatchersConstants.ActionTypes.CLEAR,
    });
};
