/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.service;

import com.arijea.plugins.betterblogs.model.BlogWatchingGroup;
import com.arijea.plugins.betterblogs.service.BlogWatchersSubscriptionService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Named
public class BlogWatchersSubscriptionServiceImpl
implements BlogWatchersSubscriptionService {
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Inject
    public BlogWatchersSubscriptionServiceImpl(SpaceManager spaceManager, NotificationManager notificationManager, ActiveObjects ao, UserAccessor userAccessor) {
        this.spaceManager = spaceManager;
        this.notificationManager = notificationManager;
        this.ao = ao;
        this.userAccessor = userAccessor;
    }

    @Override
    public Set<ConfluenceUser> getBlogWatchersForSpace(String spaceKey) {
        HashSet watchers = Sets.newHashSet();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space != null) {
            List notifications = this.notificationManager.getNotificationsBySpaceAndType(space, ContentTypeEnum.BLOG);
            for (Notification notification : notifications) {
                watchers.add(notification.getReceiver());
            }
        }
        return watchers;
    }

    @Override
    public Set<String> getGroupsWatchingSpaceBlog(Space space) {
        HashSet groupKeys = Sets.newHashSet();
        BlogWatchingGroup[] watchers = (BlogWatchingGroup[])this.ao.find(BlogWatchingGroup.class, Query.select().where("SPACE_KEY = ?", new Object[]{space.getKey()}));
        if (watchers != null && watchers.length > 0) {
            for (BlogWatchingGroup blogWatchingGroup : watchers) {
                String groupString = blogWatchingGroup.getGroupName();
                String[] groups = groupString.split(",");
                Collections.addAll(groupKeys, groups);
            }
        }
        return groupKeys;
    }

    @Override
    public Optional<BlogWatchingGroup> getBlogWatchingGroupForSpace(String spaceKey, String groupName) {
        Optional<BlogWatchingGroup> blogWatchingGroupOptional = Optional.empty();
        BlogWatchingGroup[] watchingGroups = (BlogWatchingGroup[])this.ao.find(BlogWatchingGroup.class, Query.select().where("SPACE_KEY = ? AND GROUP_NAME = ?", new Object[]{spaceKey, groupName}));
        if (watchingGroups != null && watchingGroups.length == 1) {
            blogWatchingGroupOptional = Optional.of(watchingGroups[0]);
        }
        return blogWatchingGroupOptional;
    }

    @Override
    public void addBlogWatcherForSpace(String spaceKey, String username) {
        ConfluenceUser userToAdd = this.userAccessor.getUserByName(username);
        Space space = this.spaceManager.getSpace(spaceKey);
        if (userToAdd != null && space != null) {
            this.notificationManager.addSpaceNotification((User)userToAdd, space, ContentTypeEnum.BLOG);
        }
    }

    @Override
    public void removeBlogWatcherForSpace(String spaceKey, String username) {
        Notification spaceBlogNotification;
        ConfluenceUser userToRemove = this.userAccessor.getUserByName(username);
        Space space = this.spaceManager.getSpace(spaceKey);
        if (userToRemove != null && space != null && (spaceBlogNotification = this.notificationManager.getNotificationByUserAndSpaceAndType((User)userToRemove, space, ContentTypeEnum.BLOG)) != null) {
            this.notificationManager.removeNotification(spaceBlogNotification);
        }
    }

    @Override
    public void addBlogWatchingGroupForSpace(String spaceKey, String groupName) {
        Optional<BlogWatchingGroup> blogWatchingGroupOptional = this.getBlogWatchingGroupForSpace(spaceKey, groupName);
        if (!blogWatchingGroupOptional.isPresent()) {
            BlogWatchingGroup blogWatchingGroup = (BlogWatchingGroup)this.ao.create(BlogWatchingGroup.class, new DBParam[0]);
            blogWatchingGroup.setSpaceKey(spaceKey);
            blogWatchingGroup.setGroupName(groupName);
            blogWatchingGroup.save();
        }
    }

    @Override
    public void removeBlogWatchingGroupForSpace(String spaceKey, String groupName) {
        Optional<BlogWatchingGroup> blogWatchingGroupOptional = this.getBlogWatchingGroupForSpace(spaceKey, groupName);
        if (blogWatchingGroupOptional.isPresent()) {
            BlogWatchingGroup blogWatchingGroup = blogWatchingGroupOptional.get();
            this.ao.delete(new RawEntity[]{blogWatchingGroup});
        }
    }
}

