/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.service;

import com.arijea.plugins.betterblogs.model.BlogWatchersModel;
import com.arijea.plugins.betterblogs.model.BlogWatchersOptionsModel;
import com.arijea.plugins.betterblogs.model.BlogWatchingGroupModel;
import com.arijea.plugins.betterblogs.model.BlogWatchingUserModel;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptOutService;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptionsService;
import com.arijea.plugins.betterblogs.service.BlogWatchersService;
import com.arijea.plugins.betterblogs.service.BlogWatchersSubscriptionService;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class BlogWatchersServiceImpl
implements BlogWatchersService {
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final BlogWatcherOptOutService blogWatcherOptOutService;
    private final BlogWatchersSubscriptionService blogWatchersSubscriptionService;
    private final BlogWatcherOptionsService blogWatcherOptionsService;

    @Inject
    public BlogWatchersServiceImpl(NotificationManager notificationManager, SpaceManager spaceManager, UserAccessor userAccessor, BlogWatcherOptOutService blogWatcherOptOutService, BlogWatchersSubscriptionService blogWatchersSubscriptionService, BlogWatcherOptionsService blogWatcherOptionsService) {
        this.notificationManager = notificationManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.blogWatcherOptOutService = blogWatcherOptOutService;
        this.blogWatchersSubscriptionService = blogWatchersSubscriptionService;
        this.blogWatcherOptionsService = blogWatcherOptionsService;
    }

    @Override
    public BlogWatchersModel getBlogWatchers(String spaceKey) {
        BlogWatchersModel blogWatchersModel = new BlogWatchersModel(spaceKey);
        ArrayList watchers = Lists.newArrayList();
        ArrayList watchingGroups = Lists.newArrayList();
        Space space = this.spaceManager.getSpace(spaceKey);
        Set<ConfluenceUser> users = this.blogWatchersSubscriptionService.getBlogWatchersForSpace(spaceKey);
        for (ConfluenceUser user : users) {
            ProfilePictureInfo profilePicture = this.userAccessor.getUserProfilePicture((User)user);
            watchers.add(new BlogWatchingUserModel(user, profilePicture.getDownloadPath()));
        }
        Set<String> groups = this.blogWatchersSubscriptionService.getGroupsWatchingSpaceBlog(space);
        for (String group : groups) {
            watchingGroups.add(new BlogWatchingGroupModel(group));
        }
        blogWatchersModel.setUsers(watchers);
        blogWatchersModel.setGroups(watchingGroups);
        blogWatchersModel.setSpaceOptions(new BlogWatchersOptionsModel(this.blogWatcherOptionsService.getOptions(spaceKey)));
        return blogWatchersModel;
    }

    @Override
    public List<ConfluenceUser> getUsersWatchingSpaceBlog(Space space) {
        ArrayList users = Lists.newArrayList();
        Set<String> groups = this.blogWatchersSubscriptionService.getGroupsWatchingSpaceBlog(space);
        List notifications = this.notificationManager.getNotificationsBySpaceAndType(space, ContentTypeEnum.BLOG);
        ArrayList usersAreadySubscribed = Lists.newArrayList();
        Set<String> optOuts = this.blogWatcherOptOutService.getBlogWatcherOptOutsForSpace(space.getKey());
        for (Notification notification : notifications) {
            usersAreadySubscribed.add(notification.getReceiver().getName());
        }
        for (String groupName : groups) {
            Group group = this.userAccessor.getGroup(groupName);
            if (group == null) continue;
            List userNames = this.userAccessor.getMemberNamesAsList(group);
            for (String userName : userNames) {
                ConfluenceUser user = this.userAccessor.getUserByName(userName);
                if (user == null || usersAreadySubscribed.contains(user.getName()) || optOuts.contains(user.getKey().getStringValue())) continue;
                users.add(user);
            }
        }
        return users;
    }

    @Override
    public void setOptions(String spaceKey, BlogWatchersOptionsModel options) {
        this.blogWatcherOptionsService.setOptOutDisabled(spaceKey, options.isDisableOptOut());
    }
}

