/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.service;

import com.arijea.plugins.betterblogs.model.SpaceOptions;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptionsService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BlogWatcherOptionsServiceImpl
implements BlogWatcherOptionsService {
    @ComponentImport
    private final ActiveObjects ao;
    private static final Logger log = LoggerFactory.getLogger(BlogWatcherOptionsServiceImpl.class);

    @Inject
    public BlogWatcherOptionsServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void setOptOutDisabled(String spaceKey, boolean isOptOutDisabled) {
        SpaceOptions options = this.getOptions(spaceKey);
        options.setOptOutDisabled(isOptOutDisabled);
        options.save();
    }

    @Override
    public SpaceOptions getOptions(String spaceKey) {
        SpaceOptions spaceOptions = null;
        try {
            Optional<SpaceOptions> spaceOptionsOptional = this.getOptionsOptional(spaceKey);
            if (spaceOptionsOptional.isPresent()) {
                return spaceOptionsOptional.get();
            }
            spaceOptions = (SpaceOptions)this.ao.create(SpaceOptions.class, new DBParam[0]);
            spaceOptions.setSpaceKey(spaceKey);
            return spaceOptions;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return spaceOptions;
        }
    }

    private Optional<SpaceOptions> getOptionsOptional(String spaceKey) {
        Optional<SpaceOptions> spaceOptionsOptional = Optional.empty();
        SpaceOptions[] options = (SpaceOptions[])this.ao.find(SpaceOptions.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
        if (options != null && options.length >= 1) {
            spaceOptionsOptional = Optional.of(options[0]);
        }
        return spaceOptionsOptional;
    }
}

