/*
 * Copyright (c) 2016. Glintech Products Pty Ltd.
 */

import React from "react";
import BlogWatchersUserGroupStore from "../../stores/BlogWatchersUserGroupStore.js";
import { setSpaceOptions } from "../../actions/BlogWatchersActions.js";

export default class OptOutToggle extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            spaceOptions: {},
        };
        this._onChange = this._onChange.bind(this);
    }

    getInitialState() {
        return this.getState();
    }

    componentDidMount() {
        let initialSpaceOptions = BlogWatchersUserGroupStore.getSpaceOptions();
        this.setState({ spaceOptions: initialSpaceOptions });
        BlogWatchersUserGroupStore.addChangeListener(this._onChange);
    }

    componentWillUnmount() {
        BlogWatchersUserGroupStore.removeChangeListener(this._onChange);
    }

    _onChange() {
        this.setState(this.getState());
    }

    getState() {
        return BlogWatchersUserGroupStore.getAll();
    }

    render() {
        return (
            <form className="aui top-label">
                <fieldset className="group">
                    <div className="checkbox">
                        <input
                            onClick={this._onClick.bind(this)}
                            defaultChecked={this.state.spaceOptions.disableOptOut}
                            className="checkbox"
                            type="checkbox"
                            name="disableOptOut"
                            id="disableOptOut"
                        />
                        <label htmlFor="disableOptOut">
                            Prevent users from opting out of updates for this Space
                        </label>
                    </div>
                </fieldset>
            </form>
        );
    }

    _onClick() {
        setSpaceOptions({
            disableOptOut: !this.state.spaceOptions.disableOptOut,
        });
    }
}
