/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.rest;

import com.arijea.plugins.betterblogs.model.BlogWatchersOptionsModel;
import com.arijea.plugins.betterblogs.rest.BlogWatchersOptOutRequest;
import com.arijea.plugins.betterblogs.rest.BlogWatchersRequest;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptOutService;
import com.arijea.plugins.betterblogs.service.BlogWatchersService;
import com.arijea.plugins.betterblogs.service.BlogWatchersSubscriptionService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@ReadOnlyAccessBlocked
@Path(value="/{space}")
public class BlogWatchersResource {
    private final BlogWatchersService blogWatchersService;
    private final BlogWatchersSubscriptionService blogWatchersSubscriptionService;
    private final BlogWatcherOptOutService blogWatcherOptOutService;

    public BlogWatchersResource(BlogWatchersService blogWatchersService, BlogWatchersSubscriptionService blogWatchersSubscriptionService, BlogWatcherOptOutService blogWatcherOptOutService) {
        this.blogWatchersService = blogWatchersService;
        this.blogWatchersSubscriptionService = blogWatchersSubscriptionService;
        this.blogWatcherOptOutService = blogWatcherOptOutService;
    }

    @PUT
    @Path(value="/watcher")
    @Consumes(value={"application/json"})
    public Response addBlogWatcher(@PathParam(value="space") String spaceKey, BlogWatchersRequest request) {
        this.blogWatchersSubscriptionService.addBlogWatcherForSpace(spaceKey, request.getUsername());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/watcher")
    public Response removeBlogWatcher(@PathParam(value="space") String space, BlogWatchersRequest request) {
        this.blogWatchersSubscriptionService.removeBlogWatcherForSpace(space, request.getUsername());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/group")
    @Consumes(value={"application/json"})
    public Response addBlogWatchingGroup(@PathParam(value="space") String spaceKey, BlogWatchersRequest request) {
        this.blogWatchersSubscriptionService.addBlogWatchingGroupForSpace(spaceKey, request.getGroupName());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/group")
    public Response removeBlogWatchingGroup(@PathParam(value="space") String spaceKey, BlogWatchersRequest blogWatchersRequest) {
        this.blogWatchersSubscriptionService.removeBlogWatchingGroupForSpace(spaceKey, blogWatchersRequest.getGroupName());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/opt-out")
    @Consumes(value={"application/json"})
    public Response addBlogWatcherOptOut(@PathParam(value="space") String spaceKey, BlogWatchersOptOutRequest request) {
        this.blogWatcherOptOutService.addBlogWatcherOptOut(spaceKey, request.getUserKey());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/opt-out/{userkey}")
    @Consumes(value={"application/json"})
    public Response removeBlogWatcherOptOut(@PathParam(value="space") String spaceKey, @PathParam(value="userkey") String userKey) {
        this.blogWatcherOptOutService.removeBlogWatcherOptOut(spaceKey, userKey);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/spaceOptions")
    @Consumes(value={"application/json"})
    public Response setSpaceOptions(@PathParam(value="space") String spaceKey, BlogWatchersOptionsModel options) {
        this.blogWatchersService.setOptions(spaceKey, options);
        return Response.ok().build();
    }
}

