/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.action;

import com.arijea.plugins.betterblogs.model.BlogWatchersOptOutModel;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptOutService;
import com.arijea.plugins.betterblogs.service.SubscriptionType;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.gson.Gson;
import com.opensymphony.webwork.ServletActionContext;
import javax.servlet.http.HttpServletRequest;

@ReadOnlyAccessBlocked
public class BlogWatchersOptOutAction
extends ConfluenceActionSupport {
    private BlogWatcherOptOutService blogWatcherOptOutService;
    private SpaceManager spaceManager;

    public String doDefault() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String spaceKey = request.getParameter("key");
        Space space = this.getSpace();
        if (space == null) {
            return "error";
        }
        SubscriptionType subscriptionType = this.blogWatcherOptOutService.getSubscriptionType(spaceKey);
        if (subscriptionType.equals((Object)SubscriptionType.NONE) || subscriptionType.equals((Object)SubscriptionType.OPTED_OUT)) {
            return "success";
        }
        return "none";
    }

    private Space getSpace() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String spaceKey = request.getParameter("key");
        return this.spaceManager.getSpace(request.getParameter("key"));
    }

    public String getOptOutData() {
        Space space = this.getSpace();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        BlogWatchersOptOutModel model = new BlogWatchersOptOutModel();
        model.setSpaceKey(space.getKey());
        model.setUserKey(user.getKey().getStringValue());
        Gson gson = new Gson();
        return gson.toJson((Object)model);
    }

    public String getSpaceName() {
        HttpServletRequest request = ServletActionContext.getRequest();
        Space space = this.spaceManager.getSpace(request.getParameter("key"));
        String spaceName = "";
        if (space != null) {
            spaceName = space.getName();
        }
        return spaceName;
    }

    public void setBlogWatcherOptOutService(BlogWatcherOptOutService blogWatcherOptOutService) {
        this.blogWatcherOptOutService = blogWatcherOptOutService;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

