if (!global._babelPolyfill) {
    require("@babel/polyfill");
}

import React from "react";
import ReactDom from "react-dom";
import BlogWatchers from "./components/blog-watchers/index.js";
import BlogWatchersUserGroupStore from "./stores/BlogWatchersUserGroupStore.js";

var analyticsUrl = "https://d39cgjmjzu38fd.cloudfront.net/a.js";

if (process.env.NODE_ENV !== "production") {
    analyticsUrl = "http://127.0.0.1:8080/index.js";
}

let script = document.createElement("script");
script.setAttribute("src", analyticsUrl);
script.onload = () => require("./analytics")("bb-config");
document.head.appendChild(script);

$(() => {
    var dataElement = $("#glintech-data");
    // There's no data when there's no license
    if (dataElement.length) {
        var data = AJS.$("<div />").html(dataElement.text()).text();
        try {
            var parsedData = JSON.parse(data);
            BlogWatchersUserGroupStore.setInitData(parsedData);
        } catch (e) {
            console.error("Could not parse blog watchers init data");
        }

        var root = document.getElementById("blog-watchers");
        if (root) {
            ReactDom.render(<BlogWatchers />, root);
        }
    }
});
