/*
 * Copyright (c) 2017. GLiNTECH Pty Ltd.
 */

import React from "react";
import BlogWatchersActions from "../../actions/BlogWatchersActions.js";
import BlogWatchersUserGroupStore from "../../stores/BlogWatchersUserGroupStore.js";
import BlogWatchersUserRow from "./BlogWatchersUserRow.js";
import BlogWatchersGroupRow from "./BlogWatchersGroupRow.js";
import classnames from "classnames";
import { map } from "lodash";

export default class BlogWatchersUserGroupList extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            users: [],
            groups: [],
        };
        this._getState = this._getState.bind(this);
        this._onChange = this._onChange.bind(this);
    }

    getInitialState() {
        return this._getState();
    }

    componentDidMount() {
        let initialData = BlogWatchersUserGroupStore.getAll();
        this.setState({ users: initialData.users, groups: initialData.groups });
        BlogWatchersUserGroupStore.addChangeListener(this._onChange);
    }

    componentWillUnmount() {
        BlogWatchersUserGroupStore.removeChangeListener(this._onChange);
    }

    render() {
        return (
            <div className="aui-group">
                {this._getResults("Users", this._getUserRows())}
                {this._getResults("Groups", this._getGroupRows())}
            </div>
        );
    }

    _getResults(name, rows) {
        var content = rows.length ? this._getTable(rows) : this._getEmptyState(name);
        var count = this._getCount(name, rows);
        return (
            <div className="aui-item">
                <h2>
                    {name} {count}
                </h2>
                {content}
            </div>
        );
    }

    _getCount(name, rows) {
        const verb = name === "Users" ? "watching" : "subscribed";
        return (
            <aside>
                ({rows.length} {verb})
            </aside>
        );
    }

    _getTable(rows) {
        return (
            <table className="aui">
                <tbody>{rows}</tbody>
            </table>
        );
    }

    _getEmptyState(name) {
        return <p>There are no {name.toLowerCase()} watching this Space's blog</p>;
    }

    _getState() {
        return BlogWatchersUserGroupStore.getAll();
    }

    _onChange() {
        this.setState(this._getState());
    }

    _getUserRows() {
        return map(this.state.users, (user) => (
            <BlogWatchersUserRow key={"user_" + user.username} user={user} />
        ));
    }

    _getGroupRows() {
        return map(this.state.groups, (group) => (
            <BlogWatchersGroupRow key={"group_" + group.name} group={group} />
        ));
    }
}
