/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.license;

import com.arijea.plugins.betterblogs.license.LicenseConditionEvaluator;
import com.arijea.plugins.betterblogs.license.LicenseConditionType;
import com.arijea.plugins.betterblogs.model.LicenseDetailsModel;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;

public class LicenseConditionEvaluatorImpl
implements LicenseConditionEvaluator {
    private final PluginLicenseManager pluginLicenseManager;
    private final HostLicenseInformation hostLicenseInformation;
    private final PluginAccessor pluginAccessor;

    public LicenseConditionEvaluatorImpl(PluginLicenseManager pluginLicenseManager, HostLicenseInformation hostLicenseInformation, PluginAccessor pluginAccessor) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.hostLicenseInformation = hostLicenseInformation;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public boolean evaluate(LicenseConditionType type) {
        switch (type) {
            case LICENSED: {
                Option license = this.pluginLicenseManager.getLicense();
                return license.isDefined() && ((PluginLicense)license.get()).isValid();
            }
        }
        return false;
    }

    @Override
    public LicenseDetailsModel getLicenseDetails() {
        LicenseDetailsModel licenseDetailsModel = new LicenseDetailsModel();
        licenseDetailsModel.setHostSen((String)this.hostLicenseInformation.hostSen().getOrElse((Object)"No host SEN"));
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            licenseDetailsModel.setSupportEntitlementNumber((String)pluginLicense.getSupportEntitlementNumber().getOrElse((Object)"No Plugin SEN"));
            licenseDetailsModel.setPluginKey("com.arijea.plugins.betterblogs");
            licenseDetailsModel.setPluginVersion(this.pluginAccessor.getPlugin("com.arijea.plugins.betterblogs").getPluginInformation().getVersion());
        }
        return licenseDetailsModel;
    }
}

