$(function() {

    var pageData = $("#opt-out-data").text();
    if (pageData) {
        pageData = JSON.parse(pageData);
    }

    var BASE_URL = AJS.contextPath() + "/rest/blogwatchersresource/latest/" + pageData.spaceKey + "/opt-out";

    function doRequest(url, type, data) {
        $(".aui-message-error").hide();
        var options = {
            url: url,
            type: type,
            error: function() {
                $(".aui-message-error").show();
            },
            success: function() {
                window.location.reload();
            }
        };

        if (data) {
            options.contentType = "application/json";
            options.data = JSON.stringify(data);
        }

        return $.ajax(options);
    }

    $(document).on("submit", "#unsubscribe", function(e) {
        e.preventDefault();
        var data = {
            userKey: pageData.userKey
        };

        doRequest(BASE_URL, "PUT", data);
    });

    $(document).on("submit", "#resubscribe", function(e) {
        e.preventDefault();
        var url = BASE_URL + "/" + pageData.userKey;
        doRequest(url, "DELETE", pageData);
    });
});