/*
 * Copyright (c) 2017. GLiNTECH Pty Ltd.
 */

import React from "react";
import { chooseResult, setSelectedResult } from "../../actions/BlogWatchersActions";
import UserGroupStore from "../../stores/UserGroupStore";
import SmallAvatar from "../common/SmallAvatar";
import classnames from "classnames";
import { map } from "lodash";

export default class UserGroupResultsList extends React.Component {
    render() {

        var results = map(
            this.props.results,
            (result, index) => this._getResult(index, result),
            this
        );

        var style = {
            display: this.props.visible && results.length ? "block" : "none",
            position: "absolute",
            top: "2em",
            left: 0,
            width: "250px",
            height: "auto",
        };

        return (
            <div
                className="aui-dropdown2 aui-style-default aui-layer"
                aria-hidden={!this.props.visible}
                style={style}
            >
                <ul className="aui-list-truncate">{results}</ul>
            </div>
        );
    }

    _getResult(index, result) {
        var classes = classnames({
            active: index === this.props.selectedResult,
        });

        var avatar = this._getResultAvatar(result);
        var displayname = this._getDisplayName(result);
        return (
            <li key={index}>
                <a
                    className={classes}
                    href=""
                    onMouseOver={this.selectResult(index)}
                    onClick={this._onClick}
                >
                    {avatar}
                    {displayname}
                </a>
            </li>
        );
    }

    _onClick(e) {
        e.preventDefault();
        chooseResult(UserGroupStore.getSelectedResult());
    }

    _getResultAvatar(result) {
        var avatar = `${AJS.contextPath()}/images/logo/default-space-logo-256.png`;
        if (result.type === "user" && result.thumbnailLink) {
            avatar = result.thumbnailLink.href;
        }

        return <SmallAvatar avatar={avatar} onClick={this._onClick} />;
    }

    _getDisplayName(result) {
        if (result.type === "user") {
            return result.title;
        } else {
            return result.name;
        }
    }

    selectResult(i) {
        return function () {
            setSelectedResult(i);
        };
    }
}
