(function() {
    var productVersion = $("meta[name='ajs-build-number']").attr("content");
    if (!productVersion) {
        return;
    }

    if (parseInt(productVersion) < 5780) {
        return;
    }

    var spaceKey = $("meta[name='confluence-space-key']").attr("content");
    var remoteUser = $("meta[name='ajs-remote-user']").attr("content");

    var LIKE = 0,
        UNLIKE = 1,
        likesCache = {};

    function getRestUrl(contentId) {
        return Confluence.getContextPath() + "/rest/likes/1.0/content/" + contentId + "/likes";
    }

    function loadLikes(blogPost, $endSection) {
        var remoteUserIsAnonymous = remoteUser.length === 0;

        function updateLikeSummary(data, contentId, $summaryContainer) {
            var summary = Confluence.Likes.LikeSummaryFactory.getLikeSummary(data.likes, contentId, remoteUser);

            if (!summary.key) {
                if (remoteUser.length > 0 && (data["content_type"] == "page" || data["content_type"] == "blogpost")) {
                    summary.text = "Be the first to like this";
                }
            }

            // Can't pass summary.args to AJS.format because it is an array. Need to call AJS.format.apply()
            // which takes an array of arguments, so need to construct the string and args into an array
            var formatArgs = [];
            formatArgs.push(summary.text);
            formatArgs = formatArgs.concat(summary.args);
            var summaryText = AJS.format.apply(AJS, formatArgs);

            if (summaryText && summaryText.length > 0) {
                $summaryContainer.html(summaryText);
            } else {
                $summaryContainer.empty();
            }

            if (!summaryText) {
                return;
            }

            $summaryContainer.find(".likes").click(Confluence.Likes.showLikeUsers);

            Confluence.Binder.userHover(); // to ensure user hover over user links work

            if (data["content_type"] == "comment") {
                $summaryContainer.prepend("<span class='comment-action-separator'>•</span><span class='aui-icon aui-icon-small aui-iconfont-like-small'></span>");
            }
        }
        function createHandlerFor(type, contentId, contentType) {
            if (type === undefined) {
                throw new Error("type is required");
            }
            if (contentId === undefined) {
                throw new Error("contentId is required");
            }
            if (contentType === undefined) {
                throw new Error("contentType is required");
            }

            return function () {
                if (typeof this !== "object" || !this.nodeType || this.nodeType !== 1 || this.nodeName != "A") {
                    throw new Error("this handler should be bound to a DOM anchor element");
                }

                var $likeLink = $(this),
                    callee = arguments.callee,
                    $summaryContainer = $likeLink.next(".like-summary");

                $.ajax({
                    type: type === LIKE ? "POST" : "DELETE",
                    url: getRestUrl(contentId),
                    data: {
                        "atlassian-token": AJS.Meta.get("atlassian-token")
                    },
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader("Content-Type", "application/json")
                    },
                    dataType: "json",
                    timeout: 5000
                }).fail(function () {
                    var $likeError = $summaryContainer.siblings(".like-error");
                    var likeErrorText;
                    if (type === LIKE) {
                        likeErrorText = "Like failed";
                    } else {
                        likeErrorText = "Unlike failed";
                    }

                    if ($likeError.length === 0) {
                        $summaryContainer.after('<span class="like-error" title="' + likeErrorText + '"></span>');
                    } else {
                        $likeError.attr("title", likeErrorText);
                    }
                }).success(function () {
                    $summaryContainer.attr("data-liked", type === LIKE);
                    $summaryContainer.parent().find(".like-error").remove();
                });

                // instantly update like link and summary
                $likeLink
                    .unbind("click", callee)
                    .bind("click", type === LIKE ? createHandlerFor(UNLIKE, contentId, contentType) : createHandlerFor(LIKE, contentId, contentType))
                    .find(".like-button-text")
                    .html(type === LIKE ? "Unlike" : "Like");

                likesCache[contentId] = likesCache[contentId] || {
                        content_type: contentType,
                        likes: []
                    };

                if (type === LIKE) { // simulate an immediate "like"
                    likesCache[contentId].likes.push({
                        user: { name: remoteUser }
                    });
                } else { // simulate an immediate "unlike"
                    likesCache[contentId].likes = $.grep(likesCache[contentId].likes, function (like) {
                        return like.user.name != remoteUser;
                    });
                }

                updateLikeSummary(likesCache[contentId], contentId, $summaryContainer);

                return false;
            }
        }

        var $contentLikeSection = $(Confluence.Templates.Likes.likeSection({
            showLikeButton: !remoteUserIsAnonymous
        }));

        $contentLikeSection.removeAttr("id");
        $contentLikeSection.addClass("likes-section");

        $endSection.append($contentLikeSection);

        $.ajax({
            type: "GET",
            url: getRestUrl(blogPost.id),
            dataType: "json"
        }).done(function (data) {
            if (remoteUser) {
                var existingLike = $.grep(data.likes, function (like) {
                    return like.user.name == remoteUser;
                }).length > 0;

                var contentType = data["content_type"];
                $contentLikeSection.find(".like-button")
                    .click(existingLike ? createHandlerFor(UNLIKE, blogPost.id, contentType) : createHandlerFor(LIKE, blogPost.id, contentType))
                    .find(".like-button-text")
                    .html(existingLike ? "Unlike" : "Like");
            }

            var $likeSummary = $contentLikeSection.find(".like-summary");

            updateLikeSummary(data, data["content_id"], $likeSummary);

            if ($likeSummary.html() == "" && remoteUserIsAnonymous) {
                $contentLikeSection.hide();
            }

            likesCache[data["content_id"]] = data;
        });
    }

    $(function() {
        if (spaceKey) {
            var $blogPostListing = $(".blog-post-listing");
            if ($blogPostListing.length) {
                $.ajax({
                    type: "GET",
                    url: AJS.contextPath() + "/rest/api/content/search?cql=type=blogpost and space = " + spaceKey + " order by created"
                }).then(function(response) {
                    var blogPosts = response.results;
                    $blogPostListing.each(function (i, listing) {
                        var $listing = $(listing);
                        var $a = $listing.find("a.blogHeading");
                        var href = $a.attr("href");
                        var blogPost;
                        var x = 0;

                        while (!blogPost && x < blogPosts.length) {
                            var thisBlogPost = blogPosts[x];
                            if (href.indexOf(thisBlogPost._links.webui) > -1) {
                                blogPost = thisBlogPost;
                            }
                            x++;
                        }

                        if (blogPost) {
                            var $endSection = $("<div class='endsection'></div>");
                            $listing.append($endSection);
                            loadLikes(blogPost, $endSection);
                        }
                    });
                });
            }
        }
    });
})();