/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.service;

import bucket.user.UserAccessor;
import com.arijea.plugins.betterblogs.model.BlogWatcherOptOut;
import com.arijea.plugins.betterblogs.model.SpaceOptions;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptOutService;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptionsService;
import com.arijea.plugins.betterblogs.service.BlogWatchersSubscriptionService;
import com.arijea.plugins.betterblogs.service.SubscriptionType;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class BlogWatcherOptOutServiceImpl
implements BlogWatcherOptOutService {
    private final ActiveObjects ao;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final BlogWatchersSubscriptionService blogWatchersSubscriptionService;
    private final BlogWatcherOptionsService blogWatcherOptionsService;

    public BlogWatcherOptOutServiceImpl(ActiveObjects ao, SpaceManager spaceManager, UserAccessor userAccessor, BlogWatchersSubscriptionService blogWatchersSubscriptionService, BlogWatcherOptionsService blogWatcherOptionsService) {
        this.ao = ao;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.blogWatchersSubscriptionService = blogWatchersSubscriptionService;
        this.blogWatcherOptionsService = blogWatcherOptionsService;
    }

    @Override
    public Optional<BlogWatcherOptOut> getBlogWatcherOptOut(String spaceKey, String userKey) {
        Optional optOutOptional = Optional.absent();
        BlogWatcherOptOut[] watchingGroups = (BlogWatcherOptOut[])this.ao.find(BlogWatcherOptOut.class, Query.select().where("SPACE_KEY = ? AND USER_KEY = ?", new Object[]{spaceKey, userKey}));
        if (watchingGroups != null && watchingGroups.length == 1) {
            optOutOptional = Optional.of((Object)watchingGroups[0]);
        }
        return optOutOptional;
    }

    @Override
    public boolean userIsOptedOut(String spaceKey, String userKey) {
        Optional<BlogWatcherOptOut> optOutOptional = this.getBlogWatcherOptOut(spaceKey, userKey);
        return optOutOptional.isPresent();
    }

    @Override
    public Set<String> getBlogWatcherOptOutsForSpace(String spaceKey) {
        SpaceOptions options = this.blogWatcherOptionsService.getOptions(spaceKey);
        HashSet optOutUserKeys = Sets.newHashSet();
        if (options.isOptOutDisabled()) {
            return optOutUserKeys;
        }
        BlogWatcherOptOut[] blogWatcherOptOuts = (BlogWatcherOptOut[])this.ao.find(BlogWatcherOptOut.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
        if (blogWatcherOptOuts != null && blogWatcherOptOuts.length > 0) {
            for (BlogWatcherOptOut optOut : blogWatcherOptOuts) {
                optOutUserKeys.add(optOut.getUserKey());
            }
        }
        return optOutUserKeys;
    }

    @Override
    public void addBlogWatcherOptOut(String spaceKey, String userKey) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        this.blogWatchersSubscriptionService.removeBlogWatcherForSpace(spaceKey, currentUser.getName());
        Optional<BlogWatcherOptOut> optOutOptional = this.getBlogWatcherOptOut(spaceKey, userKey);
        if (!optOutOptional.isPresent()) {
            BlogWatcherOptOut blogWatcherOptOut = (BlogWatcherOptOut)this.ao.create(BlogWatcherOptOut.class, new DBParam[0]);
            blogWatcherOptOut.setSpaceKey(spaceKey);
            blogWatcherOptOut.setUserKey(userKey);
            blogWatcherOptOut.save();
        }
    }

    @Override
    public void removeBlogWatcherOptOut(String spaceKey, String userKey) {
        SubscriptionType subscriptionType = this.getSubscriptionType(spaceKey);
        if (subscriptionType.equals((Object)SubscriptionType.GROUP_MEMBER) || subscriptionType.equals((Object)SubscriptionType.OPTED_OUT)) {
            Optional<BlogWatcherOptOut> optOutOptional = this.getBlogWatcherOptOut(spaceKey, userKey);
            if (optOutOptional.isPresent()) {
                BlogWatcherOptOut blogWatcherOptOut = (BlogWatcherOptOut)optOutOptional.get();
                this.ao.delete(new RawEntity[]{blogWatcherOptOut});
            }
        } else if (subscriptionType.equals((Object)SubscriptionType.NONE)) {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            this.blogWatchersSubscriptionService.addBlogWatcherForSpace(spaceKey, currentUser.getName());
        }
    }

    @Override
    public SubscriptionType getSubscriptionType(String spaceKey) {
        Set<ConfluenceUser> watchers = this.blogWatchersSubscriptionService.getBlogWatchersForSpace(spaceKey);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        for (ConfluenceUser user : watchers) {
            if (!user.getKey().getStringValue().equals(currentUser.getKey().getStringValue())) continue;
            return SubscriptionType.WATCHER;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space != null) {
            if (this.userIsOptedOut(spaceKey, currentUser.getKey().getStringValue())) {
                return SubscriptionType.OPTED_OUT;
            }
            Set<String> groups = this.blogWatchersSubscriptionService.getGroupsWatchingSpaceBlog(space);
            for (String groupName : groups) {
                if (!this.userAccessor.hasMembership(groupName, currentUser.getName())) continue;
                return SubscriptionType.GROUP_MEMBER;
            }
        }
        return SubscriptionType.NONE;
    }
}

