/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.listeners;

import com.arijea.plugins.betterblogs.license.LicenseConditionEvaluator;
import com.arijea.plugins.betterblogs.license.LicenseConditionType;
import com.arijea.plugins.betterblogs.service.BlogWatcherOptionsService;
import com.arijea.plugins.betterblogs.service.BlogWatchersService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationsSender;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.DefaultPageManager;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class BlogPublishedListener
implements DisposableBean {
    protected EventPublisher eventPublisher;
    private final BlogWatchersService blogWatchersService;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final NotificationsSender notificationsSender;
    private final DataSourceFactory dataSourceFactory;
    private final LicenseConditionEvaluator licenseConditionEvaluator;
    private final BlogWatcherOptionsService blogWatcherOptionsService;
    private static final Logger LOG = LoggerFactory.getLogger(BlogPublishedListener.class);
    private Timer timer;
    private TimerTask timerTask;

    public BlogPublishedListener(EventPublisher eventPublisher, BlogWatchersService blogWatchersService, SpaceManager spaceManager, UserAccessor userAccessor, GroupManager groupManager, NotificationsSender notificationsSender, DataSourceFactory dataSourceFactory, LicenseConditionEvaluator licenseConditionEvaluator, BlogWatcherOptionsService blogWatcherOptionsService) {
        this.eventPublisher = eventPublisher;
        this.blogWatchersService = blogWatchersService;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.notificationsSender = notificationsSender;
        this.dataSourceFactory = dataSourceFactory;
        this.licenseConditionEvaluator = licenseConditionEvaluator;
        this.blogWatcherOptionsService = blogWatcherOptionsService;
        eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    @EventListener
    public void onBlogCreated(BlogPostCreateEvent blogPostCreateEvent) {
        if (blogPostCreateEvent.getSource().getClass() != DefaultPageManager.class && this.licenseConditionEvaluator.evaluate(LicenseConditionType.LICENSED)) {
            String spaceKey = blogPostCreateEvent.getBlogPost().getSpaceKey();
            Space space = this.spaceManager.getSpace(spaceKey);
            final ArrayList notificationList = Lists.newArrayList();
            List<ConfluenceUser> users = this.blogWatchersService.getUsersWatchingSpaceBlog(space);
            for (ConfluenceUser user : users) {
                Notification notification = new Notification();
                notification.setContent(blogPostCreateEvent.getContent());
                notification.setDigest(true);
                notification.setReceiver(user);
                notification.setSpace(space);
                notification.setType(ContentTypeEnum.BLOG);
                notification.setNetwork(false);
                if (user == null || user.getEmail() == null || user.getEmail().isEmpty()) continue;
                notificationList.add(notification);
            }
            if (!notificationList.isEmpty()) {
                final NotificationData notificationData = this.getNotificationDataForEvent((BlogPostEvent)blogPostCreateEvent);
                final ConversionContext conversionContext = this.getConversionContext(notificationData);
                notificationData.setTemplateName("blogwatchers-adg-blogpost-added.vm");
                if (!this.blogWatcherOptionsService.getOptions(spaceKey).isOptOutDisabled()) {
                    notificationData.addToContext("unsubscribePath", (Serializable)((Object)("/plugins/betterblogs/blog-watchers-optout.action?key=" + spaceKey)));
                }
                this.attachAvatar(notificationData);
                notificationData.addTemplateImage(this.dataSourceFactory.getServletContainerResource("/images/icons/contenttypes/blog_post_16.png", "blogpost-icon"));
                notificationData.addTemplateImage(this.dataSourceFactory.getServletContainerResource("/images/icons/like_16.png", "like-icon"));
                notificationData.addTemplateImage(this.dataSourceFactory.getServletContainerResource("/images/icons/comment_16.png", "comment-icon"));
                this.timer = new Timer();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        BlogPublishedListener.this.notificationsSender.sendNotifications(notificationList, notificationData, conversionContext);
                    }
                };
                this.timer.schedule(this.timerTask, 3000L);
            }
        }
    }

    protected void attachAvatar(NotificationData notificationData) {
        DataSource avatarDataSource = this.dataSourceFactory.getAvatar(notificationData.getModifier());
        notificationData.addToContext("avatarCid", (Serializable)((Object)avatarDataSource.getName()));
        notificationData.addTemplateImage(avatarDataSource);
    }

    private ConversionContext getConversionContext(NotificationData notificationData) {
        ContentEntityObject notificationObject = this.getContentEntityObject(notificationData.getCommonContext().getMap());
        if (notificationObject == null) {
            return null;
        }
        PageContext context = notificationObject.toPageContext();
        context.setOutputType("email");
        return new DefaultConversionContext((RenderContext)context);
    }

    private boolean shouldNotifyOnOwnActions(User user) {
        UserPreferences preferences = new UserPreferences(this.userAccessor.getPropertySet(user));
        return preferences.getBoolean("confluence.prefs.notify.for.my.own.actions");
    }

    protected final NotificationData getNotificationDataForEvent(Event event, ConfluenceEntityObject entity) {
        ConfluenceUser user = entity.getCreator();
        NotificationData notificationData = new NotificationData((User)user, this.shouldNotifyOnOwnActions((User)user), entity);
        NotificationContext commonContext = notificationData.getCommonContext();
        if (event instanceof ContentEvent) {
            commonContext.setContent((ConfluenceEntityObject)((ContentEvent)event).getContent());
        }
        commonContext.setEvent(event);
        return notificationData;
    }

    protected ContentEntityObject getContentEntityObject(Map contextMap) {
        return (ContentEntityObject)contextMap.get("content");
    }

    private NotificationData getNotificationDataForEvent(BlogPostEvent blogEvent) {
        BlogPost blog = blogEvent.getBlogPost();
        Space space = blogEvent.getBlogPost().getSpace();
        NotificationData notificationData = this.getNotificationDataForEvent((Event)blogEvent, (ConfluenceEntityObject)blog);
        notificationData.addToContext("content", (Serializable)blog);
        notificationData.addToContext("page", (Serializable)blog);
        notificationData.addToContext("contentType", (Serializable)((Object)"blogpost"));
        notificationData.addToContext("space", (Serializable)space);
        notificationData.addToContext("contentId", (Serializable)Long.valueOf(blog.getId()));
        notificationData.addToContext("enableEmailReply", (Serializable)Boolean.valueOf(true));
        notificationData.setSubject("$space.name > $content.title");
        return notificationData;
    }
}

