/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.action;

import com.arijea.plugins.betterblogs.license.LicenseConditionEvaluator;
import com.arijea.plugins.betterblogs.license.LicenseConditionType;
import com.arijea.plugins.betterblogs.model.BlogWatchersModel;
import com.arijea.plugins.betterblogs.service.BlogWatchersService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.google.gson.Gson;

@ReadOnlyAccessBlocked
public class BlogWatchersManagerAction
extends SpaceAdminAction {
    private BlogWatchersService blogWatchersService;
    private LicenseConditionEvaluator licenseConditionEvaluator;

    public String doDefault() {
        return "input";
    }

    public String getBlogWatchers() {
        BlogWatchersModel watchersModel = this.blogWatchersService.getBlogWatchers(this.getSpaceKey());
        watchersModel.setLicenseDetailsModel(this.licenseConditionEvaluator.getLicenseDetails());
        Gson gson = new Gson();
        return gson.toJson((Object)watchersModel);
    }

    public boolean getIsLicensed() {
        return this.licenseConditionEvaluator.evaluate(LicenseConditionType.LICENSED);
    }

    public void setBlogWatchersService(BlogWatchersService blogWatchersService) {
        this.blogWatchersService = blogWatchersService;
    }

    public void setLicenseConditionEvaluator(LicenseConditionEvaluator licenseConditionEvaluator) {
        this.licenseConditionEvaluator = licenseConditionEvaluator;
    }
}

