/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.utility;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtil() {
    }

    public static ObjectMapper mapper() {
        return MAPPER;
    }

    public static ObjectNode parseObjectOrEmpty(String json) {
        try {
            JsonNode n = MAPPER.readTree(json);
            return n != null && n.isObject() ? (ObjectNode)n : MAPPER.createObjectNode();
        }
        catch (Exception e) {
            return MAPPER.createObjectNode();
        }
    }

    public static JsonNode parseOrNull(String json) {
        try {
            return MAPPER.readTree(json);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toJsonOrEmpty(Object value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String toJsonOrEmpty(Object value, Class<?> type) {
        try {
            return MAPPER.writerFor(type).writeValueAsString(value);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static <T> T fromJsonOrNull(String json, Class<T> type) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T fromJsonOrNull(String json, TypeReference<T> typeRef) {
        try {
            return (T)MAPPER.readValue(json, typeRef);
        }
        catch (Exception e) {
            return null;
        }
    }
}

