/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.servlets;

import com.appanvil.aura.servlets.IconRenderer;
import com.appanvil.aura.utility.JsonUtil;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousSiteAccess
public class MacroPreviewRenderer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Autowired
    private final IconRenderer iconRenderer;

    public MacroPreviewRenderer(IconRenderer iconRenderer) {
        this.iconRenderer = iconRenderer;
    }

    private String renderButton(Map<String, String> templateParams) {
        if (templateParams != null && templateParams.containsKey("icon") && templateParams.get("icon").length() > 0) {
            try {
                String icon = this.iconRenderer.renderIconByName(templateParams.get("icon"), templateParams.get("color"), new Dimension(12, 12));
                templateParams.put("renderedIconWithHtml", icon);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return VelocityUtils.getRenderedTemplate((String)String.format("/previews/%s.vm", "Button"), templateParams);
    }

    private String renderCards(Map<String, String> templateParams) {
        return VelocityUtils.getRenderedTemplate((String)String.format("/previews/%s.vm", "Cards"), templateParams);
    }

    private String renderDivider(Map<String, String> templateParams) {
        return VelocityUtils.getRenderedTemplate((String)String.format("/previews/%s.vm", "Divider"), templateParams);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String templateName = req.getParameter("templateName");
        if (templateName == null) {
            res.sendError(404);
            return;
        }
        Map<String, String> templateParams = null;
        String params = req.getParameter("params");
        if (params != null) {
            String gsonString = new String(Base64.getDecoder().decode(params));
            templateParams = JsonUtil.fromJsonOrNull(gsonString, new TypeReference<Map<String, String>>(){});
        }
        String previewImage = "";
        if (templateName.equals("Button")) {
            previewImage = this.renderButton(templateParams);
        } else if (templateName.equals("Cards")) {
            previewImage = this.renderCards(templateParams);
        } else if (templateName.equals("Divider")) {
            previewImage = this.renderDivider(templateParams);
        } else {
            res.sendError(404);
            return;
        }
        res.setContentType("image/svg+xml");
        res.getWriter().println(previewImage);
    }
}

