/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.servlets;

import com.appanvil.aura.utility.JsonUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.servlet.http.HttpServlet;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@ExportAsService(value={IconRenderer.class})
@Component
public class IconRenderer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ResourceLoader resourceLoader;
    private Map<String, Map<String, String>> iconData = new HashMap<String, Map<String, String>>();
    private boolean hasInitialized = false;

    public void init() {
        Resource resource = this.resourceLoader.getResource("classpath:templates/icondata.json");
        try {
            InputStream inputStream = resource.getInputStream();
            StringBuilder textBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    textBuilder.append((char)c);
                }
            }
            inputStream.close();
            this.iconData = JsonUtil.fromJsonOrNull(textBuilder.toString(), new TypeReference<Map<String, Map<String, String>>>(){});
            this.hasInitialized = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String renderIconCharacterByName(String iconName) throws Exception {
        Map<String, String> data;
        if (!this.hasInitialized) {
            this.init();
        }
        if ((data = this.iconData.get(iconName)) != null) {
            return data.get("unicode");
        }
        throw new Exception("Icon Name not found.");
    }

    public String renderIconByName(String iconName, String color) throws Exception {
        return this.renderIconByName(iconName, color, null);
    }

    public String renderIconByName(String iconName, String color, Dimension size) throws Exception {
        Map<String, String> data;
        if (!this.hasInitialized) {
            this.init();
        }
        if ((data = this.iconData.get(iconName)) == null) {
            return "";
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("color", color);
        context.put("path", data.get("path"));
        context.put("viewboxWidth", data.get("width"));
        context.put("viewboxHeight", data.get("height"));
        context.put("iconName", iconName.substring(2));
        if (size != null) {
            context.put("width", (int)size.getWidth() + "");
            context.put("height", (int)size.getHeight() + "");
        }
        return VelocityUtils.getRenderedTemplate((String)"/templates/Icon.vm", context);
    }
}

