/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.servlets;

import com.appanvil.aura.utility.AuraConfigPersister;
import com.appanvil.aura.utility.JsonUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminConfig
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @ComponentImport
    private final UserManager userManager;
    @Autowired
    private final AuraConfigPersister auraConfigPersister;
    private final Config fallbackConfig;

    @Inject
    public AdminConfig(UserManager userManager, AuraConfigPersister auraConfigPersister) {
        this.userManager = userManager;
        this.auraConfigPersister = auraConfigPersister;
        ColorPaletteOption auraPalette = new ColorPaletteOption();
        auraPalette.setActive(true);
        auraPalette.setId("0");
        auraPalette.setName("Aura");
        auraPalette.setPalette(Arrays.asList("#000038", "#0139D5", "#0385E7", "#B01EC1", "#DF1183", "#E13566", "#EC6541", "#F8AD11"));
        ColorPaletteOption defaultPalette = new ColorPaletteOption();
        defaultPalette.setActive(true);
        defaultPalette.setId("1");
        defaultPalette.setName("Default");
        defaultPalette.setPalette(Arrays.asList("#0065ff", "#0049b0", "#344563", "#f3f3f3", "#e2e2e2", "#d0d0d0"));
        ColorPaletteOption pastelPalette = new ColorPaletteOption();
        pastelPalette.setActive(true);
        pastelPalette.setId("2");
        pastelPalette.setName("Pastel");
        pastelPalette.setPalette(Arrays.asList("#ee5253", "#f79f1f", "#f9ca24", "#bac961", "#81ecec", "#66afff", "#918aff", "#fd79a8"));
        ColorPaletteOption statusPalette = new ColorPaletteOption();
        statusPalette.setActive(true);
        statusPalette.setId("3");
        statusPalette.setName("Status");
        statusPalette.setPalette(Arrays.asList("#dfe1e5", "#de350b", "#ffab00", "#00875a", "#b3d4ff", "#0052cc"));
        ArrayList<ColorPaletteOption> colorPalettes = new ArrayList<ColorPaletteOption>();
        colorPalettes.add(defaultPalette);
        colorPalettes.add(auraPalette);
        colorPalettes.add(pastelPalette);
        colorPalettes.add(statusPalette);
        this.fallbackConfig = new Config();
        this.fallbackConfig.setAllowColorPicker(true);
        this.fallbackConfig.setColors(colorPalettes);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String config = this.auraConfigPersister.getConfig();
        Consumer<HttpServletResponse> sendDefault = res -> {
            try {
                String defaultSerialized = JsonUtil.toJsonOrEmpty(this.fallbackConfig, Config.class);
                res.setContentType("application/json");
                res.setStatus(200);
                res.getWriter().write(defaultSerialized);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        if (config == null) {
            sendDefault.accept(response);
            return;
        }
        try {
            Config cfg = JsonUtil.fromJsonOrNull(config, Config.class);
            if (cfg == null || cfg.colors == null || cfg.colors.size() == 0) {
                sendDefault.accept(response);
                return;
            }
            response.setContentType("application/json");
            response.setStatus(200);
            response.getWriter().write(config);
            return;
        }
        catch (Exception e) {
            sendDefault.accept(response);
            return;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userName = request.getRemoteUser();
        UserProfile user = null;
        if (userName != null) {
            user = this.userManager.getUserProfile(userName);
        }
        if (user == null || !this.userManager.isAdmin(userName)) {
            response.sendError(401);
            return;
        }
        String body = request.getReader().lines().map(String::trim).reduce("", String::concat);
        try {
            JsonUtil.fromJsonOrNull(body, Config.class);
            this.auraConfigPersister.saveConfig(body);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(400);
        }
    }

    private static class ColorPaletteOption {
        private List<String> palette;
        private String name;
        private boolean active;
        private String id;

        private ColorPaletteOption() {
        }

        public List<String> getPalette() {
            return this.palette;
        }

        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setPalette(List<String> palette) {
            this.palette = palette;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    private static class Config {
        private boolean allowColorPicker;
        private List<ColorPaletteOption> colors;

        private Config() {
        }

        public void setAllowColorPicker(boolean allowColorPicker) {
            this.allowColorPicker = allowColorPicker;
        }

        public boolean isAllowColorPicker() {
            return this.allowColorPicker;
        }

        public List<ColorPaletteOption> getColors() {
            return this.colors;
        }

        public void setColors(List<ColorPaletteOption> colors) {
            this.colors = colors;
        }
    }
}

