/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.macros.cards;

import com.appanvil.aura.macros.AbstractMultiOutputMacro;
import com.appanvil.aura.macros.cards.CardRenderer;
import com.appanvil.aura.utility.ClassNameCreator;
import com.appanvil.aura.utility.JsonUtil;
import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class Cards
extends AbstractMultiOutputMacro
implements EditorImagePlaceholder {
    @Autowired
    private final ClassNameCreator classNameCreator;
    @Autowired
    private final CardRenderer cardRenderer;
    private final SettingsManager settingsManager;
    @ComponentImport
    private final VelocityHelperService velocityHelperService;

    @Autowired
    public Cards(ClassNameCreator classNameCreator, CardRenderer cardRenderer, VelocityHelperService velocityHelperService) {
        this.cardRenderer = cardRenderer;
        this.classNameCreator = classNameCreator;
        this.settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        this.velocityHelperService = velocityHelperService;
    }

    @Override
    public String executePDF(Map<String, String> map, String s, ConversionContext context) throws MacroExecutionException {
        try {
            HashMap templateParams = new HashMap();
            map.forEach(templateParams::put);
            List<Map<String, String>> cards = JsonUtil.fromJsonOrNull(map.get("cardsCollection"), new TypeReference<List<Map<String, String>>>(){});
            List renderedCards = cards.stream().map(card -> String.format("<h5>%s</h5><p>%s</p>", card.get("title"), card.get("body"))).collect(Collectors.toList());
            return String.join((CharSequence)"\n", renderedCards);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String executeWeb(Map<String, String> map, String s, ConversionContext context) throws MacroExecutionException {
        boolean isMobile = context.getOutputDeviceType() == "mobile";
        try {
            HashMap<String, Object> templateParams = new HashMap<String, Object>();
            map.forEach(templateParams::put);
            if (!templateParams.containsKey("gutter")) {
                templateParams.put("gutter", "10");
            }
            List<Map<String, String>> cards = JsonUtil.fromJsonOrNull(map.get("cardsCollection"), new TypeReference<List<Map<String, String>>>(){});
            List renderedCards = cards.stream().map(card -> {
                card.put("theme", (String)map.get("theme"));
                card.put("isMobile", "" + isMobile);
                return card;
            }).map(this.cardRenderer::htmlFromCard).collect(Collectors.toList());
            templateParams.put("cards", renderedCards);
            String className = this.classNameCreator.createClassName("aura-cards", map);
            templateParams.put("className", className);
            String rendered = this.velocityHelperService.getRenderedTemplate("/templates/CardCollection.vm", templateParams);
            return rendered.trim().replace("\n", "").replaceAll(" +", " ");
        }
        catch (Exception e) {
            return "<div style=\"margin: 1rem; display: inline-block; padding: 1rem; border-radius: 1rem; box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.15); border: 2px solid #eee;\">Please configure the cards in <strong>edit mode!</strong></div>";
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> map, ConversionContext context) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        HashMap<String, String> theme = new HashMap<String, String>();
        theme.put("theme", map.get("theme"));
        String gsonString = JsonUtil.toJsonOrEmpty(theme);
        String base64 = Base64.getEncoder().encodeToString(gsonString.getBytes());
        String template = "%s/plugins/servlet/aura/macro-preview?templateName=Cards&params=%s";
        String src = String.format("%s/plugins/servlet/aura/macro-preview?templateName=Cards&params=%s", baseUrl, base64);
        return new DefaultImagePlaceholder(src, false, new ImageDimensions(-1, -1));
    }
}

