/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.macros;

import com.appanvil.aura.utility.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ColorParser {
    public static Object parseColor(String colorString) {
        try {
            ColorConfig colorConfig = (ColorConfig)JsonUtil.mapper().readValue(colorString, ColorConfig.class);
            return colorConfig;
        }
        catch (Exception e) {
            return colorString;
        }
    }

    public static String getColorStyle(String colorValue, String cssSelector, String cssVariable) {
        String lightColor = "inherit";
        String darkColor = "inherit";
        if (colorValue != null && !colorValue.isBlank()) {
            Object parsedColor = ColorParser.parseColor(colorValue);
            if (parsedColor instanceof ColorConfig) {
                ColorConfig colorConfig = (ColorConfig)parsedColor;
                lightColor = colorConfig.getLight();
                darkColor = colorConfig.getDark();
                if (lightColor == null && darkColor != null) {
                    lightColor = colorConfig.getDark();
                }
                if (darkColor == null && lightColor != null) {
                    darkColor = colorConfig.getLight();
                }
            } else {
                lightColor = colorValue;
                darkColor = colorValue;
            }
        }
        return String.format("<style>html[data-color-mode='dark'] %s { %s: %s; }\nhtml[data-color-mode='light'] %s { %s: %s; }\n</style>", cssSelector, cssVariable, darkColor, cssSelector, cssVariable, lightColor);
    }

    public static Map<String, String> processColorAttributes(String jsonString, String cssSelector) {
        ObjectNode jsonObject = JsonUtil.parseObjectOrEmpty(jsonString);
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> extractedColors = new HashMap<String, String>();
        ColorParser.traverseAndReplace((JsonNode)jsonObject, "", extractedColors);
        result.put("updatedStyles", JsonUtil.toJsonOrEmpty(jsonObject));
        StringBuilder colorStyle = new StringBuilder();
        for (Map.Entry entry : extractedColors.entrySet()) {
            String cssVariable = (String)entry.getKey();
            String colorValues = (String)entry.getValue();
            colorStyle.append(ColorParser.getColorStyle(colorValues, cssSelector, cssVariable));
        }
        result.put("colorStyle", colorStyle.toString());
        return result;
    }

    public static void traverseAndReplace(JsonNode element, String parentEntryKey, Map<String, String> extractedColors) {
        block9: {
            block8: {
                if (element == null) {
                    return;
                }
                if (!element.isObject()) break block8;
                ObjectNode jsonObject = (ObjectNode)element;
                Iterator fields = jsonObject.fields();
                HashMap<String, TextNode> replacements = new HashMap<String, TextNode>();
                while (fields.hasNext()) {
                    String newKey;
                    Map.Entry entry = (Map.Entry)fields.next();
                    String string = newKey = parentEntryKey.isEmpty() ? (String)entry.getKey() : parentEntryKey + "-" + (String)entry.getKey();
                    if (((String)entry.getKey()).equals("color") && ((JsonNode)entry.getValue()).isObject()) {
                        ObjectNode colorObject = (ObjectNode)entry.getValue();
                        if (colorObject.has("light")) {
                            String cssVariable = "--" + newKey;
                            replacements.put((String)entry.getKey(), new TextNode("var(" + cssVariable + ")"));
                            String colorValues = colorObject.toString();
                            extractedColors.put(cssVariable, colorValues);
                        }
                    } else if (((String)entry.getKey()).equals("color") && ((JsonNode)entry.getValue()).isValueNode()) {
                        jsonObject.set((String)entry.getKey(), (JsonNode)entry.getValue());
                    }
                    ColorParser.traverseAndReplace((JsonNode)entry.getValue(), newKey, extractedColors);
                }
                for (Map.Entry r : replacements.entrySet()) {
                    jsonObject.set((String)r.getKey(), (JsonNode)r.getValue());
                }
                break block9;
            }
            if (!element.isArray()) break block9;
            ArrayNode array = (ArrayNode)element;
            for (JsonNode arrayElement : array) {
                ColorParser.traverseAndReplace(arrayElement, parentEntryKey, extractedColors);
            }
        }
    }

    public static String extractLightColorFromStyles(String jsonString) {
        ObjectNode jsonObject = JsonUtil.parseObjectOrEmpty(jsonString);
        ColorParser.traverseAndReplaceLightColor((JsonNode)jsonObject);
        return JsonUtil.toJsonOrEmpty(jsonObject);
    }

    public static void traverseAndReplaceLightColor(JsonNode element) {
        block6: {
            block5: {
                if (element == null) {
                    return;
                }
                if (!element.isObject()) break block5;
                ObjectNode jsonObject = (ObjectNode)element;
                Iterator fields = jsonObject.fields();
                HashMap<String, TextNode> replacements = new HashMap<String, TextNode>();
                while (fields.hasNext()) {
                    ObjectNode colorObject;
                    Map.Entry entry = (Map.Entry)fields.next();
                    if (((String)entry.getKey()).equals("color") && ((JsonNode)entry.getValue()).isObject() && (colorObject = (ObjectNode)entry.getValue()).has("light")) {
                        String lightColor = colorObject.get("light").asText();
                        replacements.put((String)entry.getKey(), new TextNode(lightColor));
                    }
                    ColorParser.traverseAndReplaceLightColor((JsonNode)entry.getValue());
                }
                for (Map.Entry r : replacements.entrySet()) {
                    jsonObject.set((String)r.getKey(), (JsonNode)r.getValue());
                }
                break block6;
            }
            if (!element.isArray()) break block6;
            ArrayNode array = (ArrayNode)element;
            for (JsonNode arrayElement : array) {
                ColorParser.traverseAndReplaceLightColor(arrayElement);
            }
        }
    }

    public static String extractLightColor(String colorValue) {
        if (colorValue != null && !colorValue.isBlank()) {
            try {
                JsonNode colorObject = JsonUtil.parseOrNull(colorValue);
                if (colorObject != null && colorObject.isObject() && colorObject.has("light")) {
                    return colorObject.get("light").asText();
                }
            }
            catch (Exception e) {
                return colorValue;
            }
        }
        return colorValue;
    }

    public static class ColorConfig {
        private String light;
        private String dark;

        public ColorConfig() {
        }

        public ColorConfig(String light, String dark) {
            this.light = light;
            this.dark = dark;
        }

        public String getLight() {
            return this.light;
        }

        public void setLight(String light) {
            this.light = light;
        }

        public String getDark() {
            return this.dark;
        }

        public void setDark(String dark) {
            this.dark = dark;
        }

        public String toString() {
            return "ColorConfig{light='" + this.light + "', dark='" + this.dark + "'}";
        }
    }
}

