/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.utility;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class AuraConfigPersister {
    public static final String PERSISTENCE_KEY = "APPANVIL_AURA_ADMIN_CONFIG";
    @ConfluenceImport
    private final BandanaManager bandanaManager;
    @ConfluenceImport
    private final PluginSettingsFactory pluginSettingsFactory;

    @Inject
    public AuraConfigPersister(BandanaManager bandanaManager, PluginSettingsFactory pluginSettingsFactory) {
        this.bandanaManager = bandanaManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public String getConfig() {
        String legacyConfig;
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        String config = (String)pluginSettings.get(PERSISTENCE_KEY);
        if (config == null && (legacyConfig = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), PERSISTENCE_KEY)) != null) {
            pluginSettings.put(PERSISTENCE_KEY, (Object)legacyConfig);
            config = legacyConfig;
        }
        return config;
    }

    public void saveConfig(String config) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(PERSISTENCE_KEY, (Object)config);
    }
}

