/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.macros;

import com.appanvil.aura.macros.AbstractMultiOutputMacro;
import com.appanvil.aura.macros.ColorParser;
import com.appanvil.aura.servlets.IconRenderer;
import com.appanvil.aura.utility.ClassNameCreator;
import com.appanvil.aura.utility.ConfluenceLinkBuilder;
import com.appanvil.aura.utility.JsonUtil;
import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import java.awt.Dimension;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;

public class Button
extends AbstractMultiOutputMacro
implements EditorImagePlaceholder {
    @Autowired
    private final ClassNameCreator classNameCreator;
    @Autowired
    private final IconRenderer iconRenderer;
    @Autowired
    private final ConfluenceLinkBuilder linkBuilder;
    private final SettingsManager settingsManager;
    @ComponentImport
    private final VelocityHelperService velocityHelperService;

    @Autowired
    public Button(ClassNameCreator classNameCreator, IconRenderer iconRenderer, ConfluenceLinkBuilder linkBuilder, VelocityHelperService velocityHelperService) {
        this.iconRenderer = iconRenderer;
        this.settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        this.classNameCreator = classNameCreator;
        this.linkBuilder = linkBuilder;
        this.velocityHelperService = velocityHelperService;
    }

    @Override
    public String executePDF(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        map.remove("icon");
        map.put("pdfColor", ColorParser.extractLightColor(map.get("color")));
        map.put("pdfBackground", ColorParser.extractLightColor(map.get("background")));
        map.put("mode", "pdf");
        return this.executeWeb(map, s, conversionContext);
    }

    @Override
    public String executeWeb(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        boolean isMobile = conversionContext.getOutputDeviceType() == "mobile";
        String link = this.linkBuilder.getUrl(map.get("hrefType"), map.get("href"), isMobile);
        String className = this.classNameCreator.createClassName("aura-button", map);
        String backgroundColorStyle = ColorParser.getColorStyle(map.get("background"), "." + className, "--aura-button-background");
        String foregroundColorStyle = ColorParser.getColorStyle(map.get("color"), "." + className, "--aura-button-foreground");
        map.put("className", className);
        map.put("computedLink", link);
        if (map.containsKey("icon") && map.get("icon").length() > 0) {
            try {
                String renderedIcon = this.iconRenderer.renderIconByName(map.get("icon"), map.get("color"), new Dimension(14, 14));
                map.put("renderedIcon", renderedIcon);
            }
            catch (Exception renderedIcon) {
                // empty catch block
            }
        }
        BiFunction<String, String, String> escape = (k, v) -> HtmlUtil.htmlEncode((String)v);
        map.computeIfPresent("label", escape);
        map.put("backgroundColorStyleWithHtml", backgroundColorStyle);
        map.put("foregroundColorStyleWithHtml", foregroundColorStyle);
        HashMap<String, String> templateParams = new HashMap<String, String>(map);
        String rendered = this.velocityHelperService.getRenderedTemplate("/templates/Button.vm", templateParams);
        return rendered.trim().replace("\n", "").replaceAll(" +", " ");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> map, ConversionContext conversionContext) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String label = map.get("label");
        if (label != null && label.length() > 30) {
            map.put("label", label.substring(0, 30) + "...");
        }
        map.put("color", ColorParser.extractLightColor(map.get("color")));
        map.put("background", ColorParser.extractLightColor(map.get("background")));
        String gsonString = JsonUtil.toJsonOrEmpty(map);
        String base64 = Base64.getEncoder().encodeToString(gsonString.getBytes());
        String template = "%s/plugins/servlet/aura/macro-preview?params=%s&templateName=Button";
        String src = String.format(template, baseUrl, base64);
        return new DefaultImagePlaceholder(src, false, new ImageDimensions(-1, -1));
    }
}

