/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.gateway;

import java.util.Objects;

public class EntityProperty {
    private final String entityId;
    private final String key;
    private final String value;

    private EntityProperty(String entityId, String key, String value) {
        this.entityId = entityId;
        this.key = key;
        this.value = value;
        this.requireNotEmpty("entityId", this.entityId);
        this.requireNotEmpty("key", this.key);
        this.requireNotEmpty("value", this.value);
    }

    private void requireNotEmpty(String fieldName, String field) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be null or empty");
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static EntityPropertyBuilder builder() {
        return new EntityPropertyBuilder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityProperty that = (EntityProperty)o;
        return Objects.equals(this.entityId, that.entityId) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.key, this.value);
    }

    public String toString() {
        return "EntityProperty{entityId='" + this.entityId + '\'' + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static class EntityPropertyBuilder {
        private String entityId;
        private String key;
        private String value;

        private EntityPropertyBuilder() {
        }

        public EntityPropertyBuilder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityPropertyBuilder key(String key) {
            this.key = key;
            return this;
        }

        public EntityPropertyBuilder value(String value) {
            this.value = value;
            return this;
        }

        public EntityProperty build() {
            return new EntityProperty(this.entityId, this.key, this.value);
        }
    }
}

