/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.macros;

import com.appanvil.aura.macros.ColorParser;
import com.appanvil.aura.utility.ClassNameCreator;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.HtmlUtils;

public class PrettyTitle
implements Macro {
    private static final List<String> allowedTags = Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "p");
    @Autowired
    private final ClassNameCreator classNameCreator;

    @Autowired
    public PrettyTitle(ClassNameCreator classNameCreator) {
        this.classNameCreator = classNameCreator;
    }

    public String execute(Map<String, String> map, String body, ConversionContext conversionContext) throws MacroExecutionException {
        HashMap<String, String> styles = new HashMap<String, String>();
        map.put("seed", "" + new Random().nextInt(999999999));
        String headline = map.containsKey("tag") && allowedTags.contains(map.get("tag")) ? map.get("tag") : "h1";
        styles.put("font-size", map.getOrDefault("fontSize", "16") + "px");
        styles.put("line-height", map.getOrDefault("lineHeight", "16") + "px");
        String id = this.classNameCreator.createClassName("title", map);
        String colorStyle = "";
        if (conversionContext.getOutputType().toLowerCase().equals("pdf")) {
            styles.put("color", ColorParser.extractLightColor(map.get("color")));
        } else {
            String cssVariable = "--aura-title-color";
            colorStyle = ColorParser.getColorStyle(map.get("color"), "#" + id, cssVariable);
            styles.put("color", String.format("var(%s)", cssVariable));
        }
        styles.put("font-weight", map.getOrDefault("fontWeight", "inherit"));
        styles.put("text-align", map.getOrDefault("textAlign", "inherit"));
        List styleList = styles.entrySet().stream().map(set -> (String)set.getKey() + ":" + (String)set.getValue()).collect(Collectors.toList());
        String computedStyles = String.join((CharSequence)" !important; ", styleList);
        return colorStyle + String.format("<%s id=\"%s\" role=\"heading\" style=\"%s\">%s</%s>", headline, id, computedStyles, HtmlUtils.htmlEscape((String)body).replace("\n", "<br />"), headline);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

