/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.macros.cards;

import com.appanvil.aura.macros.ColorParser;
import com.appanvil.aura.macros.cards.CardStyle;
import com.appanvil.aura.servlets.IconRenderer;
import com.appanvil.aura.utility.ClassNameCreator;
import com.appanvil.aura.utility.ConfluenceLinkBuilder;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;

@Component
public class CardRenderer {
    @Autowired
    private IconRenderer iconRenderer;
    @Autowired
    private ConfluenceLinkBuilder linkBuilder;
    @ComponentImport
    private final VelocityHelperService velocityHelperService;
    @Autowired
    private final ClassNameCreator classNameCreator;
    private final String cssVariableName = "--aura-card-color";
    private final String cssVariable = "var(--aura-card-color)";
    private Map<String, Function<Map<String, Object>, CardStyle>> cardStyleGenerators;

    public CardRenderer(ClassNameCreator classNameCreator, ConfluenceLinkBuilder linkBuilder, IconRenderer iconRenderer, VelocityHelperService velocityHelperService) {
        this.classNameCreator = classNameCreator;
        this.iconRenderer = iconRenderer;
        this.linkBuilder = linkBuilder;
        this.velocityHelperService = velocityHelperService;
        this.cardStyleGenerators = new HashMap<String, Function<Map<String, Object>, CardStyle>>();
        this.cardStyleGenerators.put("aura", map -> {
            CardStyle styles = new CardStyle("background: var(--ds-surface, #fff);", "", "var(--aura-card-color)");
            return styles;
        });
        this.cardStyleGenerators.put("aura-accent", map -> {
            CardStyle styles = new CardStyle("background: var(--ds-surface, #fff); border-top: 4px solid var(--aura-card-color);", "background-color: var(--aura-card-color);", "var(--aura-card-color)");
            return styles;
        });
        this.cardStyleGenerators.put("fabric", map -> {
            CardStyle styles = new CardStyle(String.format("background: %s;", "var(--aura-card-color)"), "", "#fff");
            return styles;
        });
    }

    public String htmlFromCard(Map<String, String> map) {
        String link = this.linkBuilder.getUrl(map.get("hrefType"), map.get("href"), map.get("isMobile").equals("true"));
        String image = "";
        if (map.containsKey("image") && map.containsKey("imageType")) {
            image = this.linkBuilder.getAttachment(map.get("imageType"), map.get("image"));
        }
        map.put("image", image);
        HashMap<String, Object> params = new HashMap<String, Object>();
        map.forEach(params::put);
        if (link != "#") {
            params.put("computedLink", link);
        }
        BiFunction<String, Object, String> escape = (k, v) -> HtmlUtils.htmlEscape((String)v.toString());
        params.computeIfPresent("title", escape);
        params.computeIfPresent("body", escape);
        params.computeIfPresent("body", (k, v) -> v.toString().replace("\n", "<br>"));
        String theme = map.get("theme");
        Function<Map<String, Object>, CardStyle> generator = this.cardStyleGenerators.containsKey(theme) ? this.cardStyleGenerators.get(theme) : this.cardStyleGenerators.get("aura");
        CardStyle styles = generator.apply(params);
        params.put("styles", styles);
        if (map.containsKey("icon") && map.get("icon").length() > 0) {
            try {
                String renderedIcon = this.iconRenderer.renderIconByName(map.get("icon"), styles.getIconColor(), new Dimension(14, 14));
                params.put("renderedIcon", renderedIcon);
            }
            catch (Exception renderedIcon) {
                // empty catch block
            }
        }
        String className = this.classNameCreator.createClassName("aura-card", map);
        params.put("className", className);
        String colorStyle = ColorParser.getColorStyle(map.get("color"), "." + className, "--aura-card-color");
        String rendered = colorStyle + this.velocityHelperService.getRenderedTemplate("/templates/Card.vm", params);
        return rendered;
    }
}

