/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.macros;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class ColorParser {
    public static Object parseColor(String colorString) {
        Gson gson = new Gson();
        try {
            ColorConfig colorConfig = gson.fromJson(colorString, ColorConfig.class);
            return colorConfig;
        }
        catch (Exception e) {
            return colorString;
        }
    }

    public static String getColorStyle(String colorValue, String cssSelector, String cssVariable) {
        String lightColor = "inherit";
        String darkColor = "inherit";
        if (colorValue != null && !colorValue.isBlank()) {
            Object parsedColor = ColorParser.parseColor(colorValue);
            if (parsedColor instanceof ColorConfig) {
                ColorConfig colorConfig = (ColorConfig)parsedColor;
                lightColor = colorConfig.getLight();
                darkColor = colorConfig.getDark();
                if (lightColor == null && darkColor != null) {
                    lightColor = colorConfig.getDark();
                }
                if (darkColor == null && lightColor != null) {
                    darkColor = colorConfig.getLight();
                }
            } else {
                lightColor = colorValue;
                darkColor = colorValue;
            }
        }
        return String.format("<style>html[data-color-mode='dark'] %s { %s: %s; }\nhtml[data-color-mode='light'] %s { %s: %s; }\n</style>", cssSelector, cssVariable, darkColor, cssSelector, cssVariable, lightColor);
    }

    public static Map<String, String> processColorAttributes(String jsonString, String cssSelector) {
        JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> extractedColors = new HashMap<String, String>();
        ColorParser.traverseAndReplace(jsonObject, "", extractedColors);
        result.put("updatedStyles", jsonObject.toString());
        StringBuilder colorStyle = new StringBuilder();
        for (Map.Entry entry : extractedColors.entrySet()) {
            String cssVariable = (String)entry.getKey();
            String colorValues = (String)entry.getValue();
            colorStyle.append(ColorParser.getColorStyle(colorValues, cssSelector, cssVariable));
        }
        result.put("colorStyle", colorStyle.toString());
        return result;
    }

    public static void traverseAndReplace(JsonElement element, String parentEntryKey, Map<String, String> extractedColors) {
        block7: {
            block6: {
                if (!element.isJsonObject()) break block6;
                JsonObject jsonObject = element.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                    String newKey;
                    String string = newKey = parentEntryKey.isEmpty() ? entry.getKey() : parentEntryKey + "-" + entry.getKey();
                    if (entry.getKey().equals("color") && entry.getValue().isJsonObject()) {
                        JsonObject colorObject = entry.getValue().getAsJsonObject();
                        if (colorObject.has("light")) {
                            String cssVariable = "--" + newKey;
                            jsonObject.add(entry.getKey(), new JsonPrimitive("var(" + cssVariable + ")"));
                            String colorValues = colorObject.toString();
                            extractedColors.put(cssVariable, colorValues);
                        }
                    } else if (entry.getKey().equals("color") && entry.getValue().isJsonPrimitive()) {
                        jsonObject.add(entry.getKey(), entry.getValue());
                    }
                    ColorParser.traverseAndReplace(entry.getValue(), newKey, extractedColors);
                }
                break block7;
            }
            if (!element.isJsonArray()) break block7;
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                ColorParser.traverseAndReplace(arrayElement, parentEntryKey, extractedColors);
            }
        }
    }

    public static String extractLightColorFromStyles(String jsonString) {
        JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
        ColorParser.traverseAndReplaceLightColor(jsonObject);
        return jsonObject.toString();
    }

    public static void traverseAndReplaceLightColor(JsonElement element) {
        block4: {
            block3: {
                if (!element.isJsonObject()) break block3;
                JsonObject jsonObject = element.getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                    JsonObject colorObject;
                    if (entry.getKey().equals("color") && entry.getValue().isJsonObject() && (colorObject = entry.getValue().getAsJsonObject()).has("light")) {
                        String lightColor = colorObject.get("light").getAsString();
                        jsonObject.add(entry.getKey(), new JsonPrimitive(lightColor));
                    }
                    ColorParser.traverseAndReplaceLightColor(entry.getValue());
                }
                break block4;
            }
            if (!element.isJsonArray()) break block4;
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                ColorParser.traverseAndReplaceLightColor(arrayElement);
            }
        }
    }

    public static String extractLightColor(String colorValue) {
        if (colorValue != null && !colorValue.isBlank()) {
            try {
                JsonObject colorObject = JsonParser.parseString(colorValue).getAsJsonObject();
                if (colorObject.has("light")) {
                    return colorObject.get("light").getAsString();
                }
            }
            catch (Exception e) {
                return colorValue;
            }
        }
        return colorValue;
    }

    public static class ColorConfig {
        private String light;
        private String dark;

        public ColorConfig(String light, String dark) {
            this.light = light;
            this.dark = dark;
        }

        public String getLight() {
            return this.light;
        }

        public void setLight(String light) {
            this.light = light;
        }

        public String getDark() {
            return this.dark;
        }

        public void setDark(String dark) {
            this.dark = dark;
        }

        public String toString() {
            return "ColorConfig{light='" + this.light + "', dark='" + this.dark + "'}";
        }
    }
}

