var allMacros = [
  "aura-button",
  "aura-panel",
  "aura-background-image",
  "aura-cards",
  "aura-pretty-title",
  "aura-divider",
  "aura-tab-collection",
  "aura-tab",
  "aura-composition",
];

var AJS = require("ajs");
var $ = require("jquery");

var dialogTemplate = `
<section id="license-expired-dialog" class="aui-dialog2 aui-dialog2-small aui-layer" role="dialog" aria-hidden="true">
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">Aura License Expired</h2>
        <a class="aui-dialog2-header-close">
            <span class="aui-icon aui-icon-small aui-iconfont-close-dialog">Close</span>
        </a>
    </header>
    <div class="aui-dialog2-content">
        <p>Your Aura license has expired. Please renew your license. After renewal you will be able to use Aura macros again.</p>
    </div>
    <footer class="aui-dialog2-footer">
        <div class="aui-dialog2-footer-actions">
            <button id="license-expired-submit-button" class="aui-button aui-button-primary">Close</button>
        </div>
   </footer>
</section> 
`;

try {
  AJS.bind("init.rte", function () {
    allMacros.forEach(function (macro) {
      AJS.MacroBrowser.setMacroJsOverride(macro, {
        opener: function (macro) {
          $("body").append(dialogTemplate);
          AJS.dialog2("#license-expired-dialog").show();
          $("#license-expired-submit-button").click(function (e) {
            e.preventDefault();
            AJS.dialog2("#license-expired-dialog").hide();
          });
        },
      });
    });
  });
} catch (e) {
  console.error("Could not load Aura due to expired license.");
}
