/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.migration;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.KeyValueParameters;
import com.atlassian.migration.app.PaginatedMapping;
import com.atlassian.migration.app.gateway.AppCloudForgeMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableForgeListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService
@Named
public class MigrationListener
implements DiscoverableForgeListener {
    private static final Logger log = LoggerFactory.getLogger(MigrationListener.class);
    private static final String keyPrefix = "id-mapping-";

    @Override
    public String getCloudAppKey() {
        return "com.appanvil.aura.aura";
    }

    @Override
    public String getServerAppKey() {
        return "com.appanvil.aura.aura";
    }

    @Override
    public void onStartAppMigration(AppCloudForgeMigrationGateway migrationGateway, MigrationDetailsV1 migrationDetails) {
        log.info("Aura App migration STARTED");
        log.info("Aura App migration transferId: {}", (Object)migrationGateway.getTransferId());
        Map<String, String> pageMappings = this.getMappingsForNamespace("confluence:page", migrationGateway);
        Map<String, String> blogPostMappings = this.getMappingsForNamespace("confluence:blogPost", migrationGateway);
        Map<String, String> attachmentMappings = this.getMappingsForNamespace("confluence:attachment", migrationGateway);
        HashMap<String, String> allMappings = new HashMap<String, String>(pageMappings);
        allMappings.putAll(blogPostMappings);
        allMappings.putAll(attachmentMappings);
        KeyValueParameters parameters = new KeyValueParameters(null, true);
        migrationGateway.sendKeyValuePair(allMappings, parameters);
        migrationGateway.completeExport();
        log.info("Aura App migration FINISHED");
    }

    private Map<String, String> getMappingsForNamespace(String namespace, AppCloudForgeMigrationGateway migrationGateway) {
        HashMap<String, String> result = new HashMap<String, String>();
        PaginatedMapping paginatedMapping = migrationGateway.getPaginatedMapping(namespace, 5000);
        try {
            while (paginatedMapping.next()) {
                Map<String, String> page = paginatedMapping.getMapping();
                page.forEach((k, v) -> result.put(keyPrefix + k, (String)v));
            }
        }
        catch (Exception e) {
            log.error("Aura App migration: Error retrieving migration mappings for namespace: " + namespace, (Throwable)e);
        }
        return result;
    }

    @Override
    public UUID getForgeAppId() {
        return UUID.fromString("1dde0629-5b53-4119-9484-91d92cf27b7d");
    }

    @Override
    public String getForgeEnvironmentName() {
        return "production";
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

