/*
 * Decompiled with CFR 0.152.
 */
package com.appanvil.aura.jobs.analytics;

import com.appanvil.aura.jobs.analytics.AnalyticsMacroCount;
import com.appanvil.aura.jobs.analytics.AnalyticsMeta;
import com.appanvil.aura.jobs.analytics.AnalyticsTenant;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.user.AuthenticatedUserImpersonator;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;

@Named
public class AuraAnalyticsJobRunner
implements JobRunner {
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final CQLSearchService searchService;
    private final PluginAccessor pluginAccessor;

    @Inject
    public AuraAnalyticsJobRunner(CQLSearchService searchService, PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.searchService = searchService;
        this.pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
    }

    private String createHash(String value) {
        String hash = "unknown";
        try {
            MessageDigest md = null;
            md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(value.getBytes());
            BigInteger no = new BigInteger(1, messageDigest);
            hash = no.toString(16);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return hash;
    }

    private AnalyticsTenant receiveAnalytics() {
        AnalyticsTenant analyticsObjects = new AnalyticsTenant();
        AnalyticsMacroCount macroCount = new AnalyticsMacroCount();
        AnalyticsMeta meta = new AnalyticsMeta();
        int cardsCount = this.searchService.countContent("macro=\"aura-cards\"");
        int buttonCount = this.searchService.countContent("macro=\"aura-button\"");
        int panelCount = this.searchService.countContent("macro=\"aura-panel\"");
        int dividerCount = this.searchService.countContent("macro=\"aura-divider\"");
        int titleCount = this.searchService.countContent("macro=\"aura-pretty-title\"");
        int backgroundContentCount = this.searchService.countContent("macro=\"aura-background-image\"");
        int tabGroupCount = this.searchService.countContent("macro=\"aura-tab-collection\"");
        int tabCount = this.searchService.countContent("macro=\"aura-tab\"");
        int pagesCount = this.searchService.countContent("type=page");
        String auraVersion = "unknown";
        String sen = "unknown";
        String edition = "unknown";
        String isDataCenter = "unknown";
        String isActive = "unknown";
        String isEvaluation = "unknown";
        String isSubscription = "unknown";
        String licenseExpires = "unknown";
        String organization = "unknown";
        List otherPlugins = null;
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            ArrayList<String> pluginBlacklist = new ArrayList<String>(Arrays.asList("com.atlassian.", "confluence.", "org.osgi.", "tac.confluence.", "com.appanvil.aura.aura", "org.apache", "com.ibm", "crowd.system.passwordencoders", "org.randombits.confluence.toc"));
            auraVersion = this.pluginAccessor.getPlugin(license.getPluginKey()).getPluginInformation().getVersion();
            otherPlugins = this.pluginAccessor.getEnabledPlugins().stream().map(plugin -> plugin.getKey()).filter(pluginName -> pluginBlacklist.stream().noneMatch(blacklisted -> pluginName.startsWith((String)blacklisted))).collect(Collectors.toList());
            edition = ((Integer)license.getEdition().getOrElse((Object)-1)).toString();
            isDataCenter = license.isDataCenter() ? "true" : "false";
            isActive = license.isActive() ? "true" : "false";
            isEvaluation = license.isEvaluation() ? "true" : "false";
            isSubscription = license.isSubscription() ? "true" : "false";
            sen = (String)license.getSupportEntitlementNumber().getOrElse((Object)"unknown");
            if (sen != "unknown") {
                sen = this.createHash(sen);
            }
            Option expiryDate = license.getExpiryDate();
            try {
                if (expiryDate != null && expiryDate.get() != null) {
                    licenseExpires = String.valueOf(((DateTime)license.getExpiryDate().get()).getMillis());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            organization = license.getOrganization().getName();
        }
        macroCount.setCards(cardsCount);
        macroCount.setButton(buttonCount);
        macroCount.setPanel(panelCount);
        macroCount.setTitle(titleCount);
        macroCount.setDivider(dividerCount);
        macroCount.setBackgroundContent(backgroundContentCount);
        macroCount.setTabGroup(tabGroupCount);
        macroCount.setTab(tabCount);
        meta.setAuraVersion(auraVersion);
        meta.setConfluenceVersion(GeneralUtil.getVersionNumber());
        meta.setEdition(edition);
        meta.setIsDataCenter(isDataCenter);
        meta.setIsActive(isActive);
        meta.setIsEvaluation(isEvaluation);
        meta.setIsSubscription(isSubscription);
        meta.setLicenseExpires(licenseExpires);
        meta.setOtherPlugins(otherPlugins);
        meta.setTotalPages(pagesCount);
        analyticsObjects.setOrganization(organization);
        analyticsObjects.setServerId(sen);
        analyticsObjects.setMacroCount(macroCount);
        analyticsObjects.setMeta(meta);
        return analyticsObjects;
    }

    private ConfluenceUser getAdminUser() {
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        ConfluenceUser adminUser = userAccessor.getUserByName("admin");
        if (adminUser == null) {
            List users = userAccessor.getUserNamesWithConfluenceAccess();
            if (users.isEmpty()) {
                return null;
            }
            adminUser = userAccessor.getUserByName((String)users.get(0));
        }
        return adminUser;
    }

    private void sendMetrics() {
        URL url = null;
        HttpURLConnection con = null;
        String json = "";
        Gson gson = new Gson();
        AnalyticsTenant analyticsObjects = this.receiveAnalytics();
        if (analyticsObjects.getMeta().getAuraVersion().equals("unknown")) {
            return;
        }
        json = gson.toJson((Object)analyticsObjects, AnalyticsTenant.class);
        try {
            url = new URL("http://167.71.62.232:3000/v1/add");
            con = (HttpURLConnection)url.openConnection();
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            con.connect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (url == null || con == null) {
            return;
        }
        try {
            Throwable e = null;
            Object var7_13 = null;
            try (OutputStream os = con.getOutputStream();){
                os.write(json.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            System.out.println(String.format("Aura Analytics answered with: %s", con.getResponseCode()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        con.disconnect();
    }

    public JobRunnerResponse runJob(JobRunnerRequest req) {
        ConfluenceUser admin;
        block3: {
            admin = this.getAdminUser();
            if (admin != null) break block3;
            return null;
        }
        try {
            AuthenticatedUserImpersonator.REQUEST_AGNOSTIC.asUser(() -> {
                this.sendMetrics();
                return null;
            }, (User)admin);
        }
        catch (Exception e) {
            System.out.println("Aura Analytics: Error while trying to send Aura Analytics:");
            e.printStackTrace();
        }
        return null;
    }
}

