AJS.toInit(function ($) {

	var uaProgressContainer = $("#ua-progress-container"),
			uaPanelContents = $("#ua-panel-contents"),
			uaSuccessMessageContainer = $("#ua-success-message-container"),
			uaSuccessMessage = $("#ua-success-message"),
			uaErrorMessageContainer = $("#ua-error-message-container"),
			uaErrorMessage = $("#ua-error-message"),
			uaInfoMessageContainer = $("#ua-info-message-container"),
			uaInfoMessage = $("#ua-info-message"),
			uaProgressBar = $("#ua-progress-bar"),
			uaInProgress = $("#ua-in-progress").length > 0,
			uaButtonFind = $("#ua-button-find"),
			uaButtonCancel = $("#ua-button-cancel"),
			uaButtonDeleteCancel = $("#ua-button-delete-cancel"),
			uaButtonBack = $("#ua-button-back"),
			uaDeleteAllLink = $("#ua-delete-all"),
			uaDeleteAllConfirm = $("#ua-delete-all-confirm"),
			uaCheckNotify = $("#ua-check-notify"),
			uaDeleteSelectedConfirm = $("#ua-delete-selected-confirm"),
			uaDeleteCancel = $("#ua-delete-cancel"),
			uaSelectAll = $(".ua-select-all"),
			uaSelectAllCheck = $("#ua-select-all-check"),
			uaSelect = $(".ua-select"),
			uaDeleteSelectedLabel = $("#ua-delete-selected-label"),
			uaDeleteSelectedLink = $("#ua-delete-selected-link"),
			uaDeleteSelected = $(".ua-delete-selected"),
			uaSortBy = $("#ua-sort-by"),
			uaSortOrder = $("#ua-sort-order"),
			uaSortLink = $(".ua-sort-link"),
			uaFilter = $("#ua-filter"),
			uaSpace = $("#ua-space"),
			uaPageId = $("#ua-page-id"),
			uaListForm = $("#ua-list-form"),
			uaRowsPerPage = $("#ua-rows-per-page"),
			uaPageIndex = $("#ua-page-index"),
			uaPageLink = $(".ua-page-link"),
			uaRemainingTime = $("#ua-remaining-time"),
			uaNoLicenseLink = $(".noLicenseLink"),
			uaNoDeleteLink = $(".noDeleteLink"),
			uaStatus = $("#ua-status"),
			uaPercentage = $("#ua-percentage"),
			uaAge = $("#ua-age"),
			uaList = $("#ua-list"),
			oldFilterText = $.trim(uaFilter.val()),
			searchInterval,
			filterTimer;

	function updateProgressBar(percentage) 
	{
		uaProgressBar[0].value = percentage;
	}

	uaButtonFind.click(function	()
	{
		findUnusedAttachments();

		return false;
	});

	function findUnusedAttachments() 
	{
		AJS.safe.ajax({
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/findunusedattachments",
			type: "PUT",
			contentType: "application/json",
			dataType: "json",
			data: {}, // must declare this to use AJS.safe.ajax
			success: function (resp) {
				if (resp.accepted)
				{
					updateProgressBar(0);
					uaAge.hide();
					uaList.hide();
					monitorProgress();
				}
				else
				{
					taskNotAccepted();
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				var data = AJS.$.parseJSON(jqXHR.responseText) || jqXHR.responseText;
				if (jqXHR.status === 405 && data.reason === "READ_ONLY")
				{
					var templates = AJS.Confluence.Templates.Attachments;
					var messageDialog = AJS.ConfluenceDialog({
						width : 600,
						height : 300,
						id : 'readonly-message-dialog',
						closeOnOutsideClick : true
					});
					messageDialog.addHeader(AJS.I18n.getText("com.alutustech.confluentis.attachments.title.readonly"));
					messageDialog.addPanel(
						"", 
						"<div class=\"aui-message aui-message-info\"><p>" 
							+ AJS.I18n.getText("com.alutustech.confluentis.attachments.message.readonly") 
							+ "</p></div>"
						);
					messageDialog.addButton(AJS.I18n.getText("close.name"), function() {
						messageDialog.hide();
					});
					messageDialog.show();
					return false;
				}
				else
				{
					taskNotAccepted();
				}
			}
		});
	}

	uaButtonCancel.click(function (e) 
	{
		e.preventDefault();

		AJS.safe.ajax({
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/cancelfindunusedattachments",
			type: "PUT",
			contentType: "application/json",
			dataType: "json",
			data: {}, // must declare this to use AJS.safe.ajax
			success: function (data) {
				uaInfoMessageContainer.show();
				clearInterval(searchInterval);
				setTimeout(function() { location.reload(true) }, 1500);
			}
		});

		return false;
	});
	
	uaButtonDeleteCancel.click(function (e) 
	{
		e.preventDefault();

		// here we need to read from div data attributes, 
		// because form input control do not exist on the page at this particular moment,
		// and also because on global search page the space-key needs to be ignored and
		// indeed the data attribute for it is intentionally missing there
		var spaceKey = uaPanelContents.data('space-key');
		var pageId = uaPanelContents.data('page-id');
		
		AJS.safe.ajax({
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/canceldeleteattachments" 
				+ (spaceKey ? '?spaceKey=' + spaceKey : '')
				+ (pageId ? '?pageId=' + pageId : ''),
			type: "PUT",
			contentType: "application/json",
			dataType: "json",
			data: {}, // must declare this to use AJS.safe.ajax
			success: function (data) {
				uaInfoMessageContainer.show();
				clearInterval(searchInterval);
				setTimeout(function() { location.reload(true) }, 1500);
			}
		});

		return false;
	});
	
	uaButtonBack.click(function (e) 
	{
		e.preventDefault();

		location.reload(true);
	});
	
	uaDeleteAllLink.click(function (e) 
	{
		e.preventDefault();
		uaDeleteAllConfirm.show();
		uaDeleteSelectedConfirm.hide();
		AJS.dialog2("#ua-delete-dialog").show();
	});

	uaDeleteSelected.click(function (e) 
	{
		e.preventDefault();
		uaDeleteAllConfirm.hide();
		uaDeleteSelectedConfirm.show();
		AJS.dialog2("#ua-delete-dialog").show();
	});

	uaDeleteAllConfirm.click(function (e) 
	{
		e.preventDefault();

		callDeleteAttachments();

		AJS.dialog2("#ua-delete-dialog").hide();
	});

	uaDeleteSelectedConfirm.click(function (e) 
	{
		e.preventDefault();

		attachments = '';
		isFirst = true;
		
		checkboxes = uaSelect;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			if (checkboxes[i].checked)
			{
				attachments = attachments + (isFirst ? '' : ',') + checkboxes[i].getAttribute('data-attachment-id');
				isFirst = false;
			}
		}

		callDeleteAttachments(attachments);

		AJS.dialog2("#ua-delete-dialog").hide();
	});

	function callDeleteAttachments(attachments) 
	{
		var global = uaPanelContents.data('space-key') === undefined;
		// here it's OK to read from form input controls, 
		// because they exist on the page at this particular moment
		var spaceKey = uaSpace.val();
		var pageId = uaPageId.val();
		
		AJS.$.ajax({
		//AJS.safe.ajax({ //simply does not work when non empty data needs to be sent
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/deleteunusedattachments",
			type: "POST",
			contentType: "application/json",
			dataType: "json",
			data: '{' 
				+ ('"global" : "' + global + '", ') 
				+ (spaceKey ? '"spaceKey" : "' + spaceKey + '", ' : '') 
				+ (pageId ? '"pageId" : "' + pageId + '", ' : '') 
				+ (oldFilterText ? '"filterText" : "' + oldFilterText + '", ' : '') 
				+ '"notifyWatchers" : "' + uaCheckNotify[0].checked + '"' 
				+ (attachments ? ', "attachments" : [' + attachments + ']' : '') 
				+ '}',
			success: function(resp, textStatus, jqXHR) {
				if (resp.accepted)
				{
					updateProgressBar(0);
					uaAge.hide();
					uaList.hide();
					monitorProgress();
				}
				else
				{
					taskNotAccepted();
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				var templates = AJS.Confluence.Templates.Attachments;
				var errorDialog = AJS.ConfluenceDialog({
					width : 600,
					height : 300,
					id : 'attachment-removal-error-dialog'
				});
				errorDialog.addHeader(templates.removalErrorTitle());
				errorDialog.addPanel("", templates.removalErrorBody({
					messages : null
				}));
				errorDialog.addButton(AJS.I18n.getText("close.name"), function() {
					location.reload(true);
				});
				errorDialog.show();
			}
		});
	}

	uaDeleteCancel.click(function (e) 
	{
		e.preventDefault();
		AJS.dialog2("#ua-delete-dialog").hide();
	});

	uaSortLink.click(function (e) 
	{
		e.preventDefault();
		
		var target = e.target;
		uaSortBy.val(target.getAttribute('data-sort-by'));
		uaSortOrder.val(target.getAttribute('data-sort-order'));
		
		uaListForm.submit();
	});

	uaSpace.on('change', function () 
	{
		uaListForm.submit();
	});

	uaRowsPerPage.on('change', function () 
	{
		uaListForm.submit();
	});

	uaPageLink.click(function (e) 
	{
		e.preventDefault();
		
		var target = e.target;
		uaPageIndex.val(target.getAttribute('data-page-index'));
		
		uaListForm.submit();
	});

	function monitorProgress() 
	{
		uaButtonFind.prop("disabled", true);
		uaButtonCancel.prop("disabled", false);
		uaButtonDeleteCancel.prop("disabled", false);
		
		// here we need to read from div data attributes, 
		// because form input control do not exist on the page at this particular moment,
		// and also because on global search page the space-key needs to be ignored and
		// indeed the data attribute for it is intentionally missing there
		var spaceKey = uaPanelContents.data('space-key');
		var pageId = uaPanelContents.data('page-id');

		searchInterval = setInterval(function () {
			$.getJSON(
				contextPath + '/rest/confluentis/1.0/unusedattachmentsstatus' 
					+ (spaceKey ? '?spaceKey=' + spaceKey : '')
					+ (pageId ? '?pageId=' + pageId : ''), 
			function (status) 
			{
				if (!status)
				{
					location.reload(true);
					return;
				}
			
				if (status.cancelled) 
				{
					clearInterval(searchInterval);

					setTimeout(function() { location.reload(true) }, 1500);

					return;
				}
				
				uaButtonFind.hide();
				if (status.isDeleteTask)
				{
					uaInfoMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.delete.stopped"));
					uaButtonDeleteCancel.show();
				}
				else
				{
					if (status.isSaveTask)
					{
						uaButtonCancel.prop("value", AJS.I18n.getText("com.alutustech.confluentis.attachments.button.label.stop"));
						uaInfoMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.save.stopped"));
					}
					else
					{
						uaButtonCancel.prop("value", AJS.I18n.getText("com.alutustech.confluentis.attachments.button.label.cancel"));
						uaInfoMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.search.cancelled"));
					}
					uaButtonCancel.show();
				}
				uaProgressContainer.show();
				uaSuccessMessageContainer.hide();
				uaErrorMessageContainer.hide();
				uaInfoMessageContainer.hide();
				
				updateProgressBar(status.percentage);
				uaStatus.text(status.message);
				uaPercentage.text(status.percentage + "%");

				uaRemainingTime.html(status.remainingTime);

				if (!status.inProgress) 
				{
					uaButtonCancel.prop("disabled", true);
					uaButtonDeleteCancel.prop("disabled", true);
					uaProgressContainer.hide();

					clearInterval(searchInterval);
					
					if (status.success) 
					{
						if (status.isDeleteTask)
						{
							uaSuccessMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.delete.success"));
						}
						else
						{
							uaSuccessMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.search.success"));
						}
						uaSuccessMessageContainer.show();
						setTimeout(function() { location.reload(true) }, 1500);
					}
					else
					{
						if (status.isDeleteTask)
						{
							uaErrorMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.delete.error"));
							uaButtonBack.show();
						}
						else
						{
							uaErrorMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.search.error"));
							uaButtonFind.prop("disabled", false);
							uaButtonFind.show();
						}
						uaErrorMessageContainer.show();
						uaButtonCancel.hide();
						uaButtonDeleteCancel.hide();
					}
				}
			});
		}, 1000);
	}

	uaNoLicenseLink.click(function()
	{
		var templates = AJS.Confluence.Templates.Attachments;
		var messageDialog = AJS.ConfluenceDialog({
			width : 600,
			height : 300,
			id : 'license-message-dialog',
			closeOnOutsideClick : true
		});
		messageDialog.addHeader(AJS.I18n.getText("com.alutustech.confluentis.attachments.title.no.license"));
		messageDialog.addPanel(
			"", 
			"<div class=\"aui-message aui-message-error\"><p>" 
				+ AJS.I18n.getText("com.alutustech.confluentis.attachments.message.no.license") 
				+ "</p></div>"
			);
		messageDialog.addButton(AJS.I18n.getText("close.name"), function() {
			messageDialog.hide();
		});
		messageDialog.show();
		return false;
	});

	uaNoDeleteLink.click(function()
	{
		var templates = AJS.Confluence.Templates.Attachments;
		var messageDialog = AJS.ConfluenceDialog({
			width : 600,
			height : 300,
			id : 'ua-no-delete-message-dialog',
			closeOnOutsideClick : true
		});
		messageDialog.addHeader(AJS.I18n.getText("com.alutustech.confluentis.attachments.title.no.delete"));
		messageDialog.addPanel(
			"", 
			"<div class=\"aui-message aui-message-info\"><p>" 
				+ AJS.I18n.getText("com.alutustech.confluentis.attachments.message.no.delete") 
				+ "</p></div>"
			);
		messageDialog.addButton(AJS.I18n.getText("close.name"), function() {
			messageDialog.hide();
		});
		messageDialog.show();
		return false;
	});

	function taskNotAccepted()
	{
		var templates = AJS.Confluence.Templates.Attachments;
		var messageDialog = AJS.ConfluenceDialog({
			width : 600,
			height : 300,
			id : 'ua-no-delete-message-dialog',
			closeOnOutsideClick : true
		});
		messageDialog.addHeader(AJS.I18n.getText("com.alutustech.confluentis.attachments.title.task.not.accepted"));
		messageDialog.addPanel(
			"", 
			"<div class=\"aui-message aui-message-info\"><p>" 
				+ AJS.I18n.getText("com.alutustech.confluentis.attachments.message.task.not.accepted") 
				+ "</p></div>"
			);
		messageDialog.addButton(AJS.I18n.getText("close.name"), function() {
			location.reload(true);
		});
		messageDialog.show();
		return false;
	}

	uaFilter.keyup(function (e)
	{
		var filterText = $.trim(uaFilter.val());

		// Don't run the search if the string is short
		if (!(/^\S{1,2}$/).test(filterText))
		{
			if (oldFilterText != filterText)
			{
				oldFilterText = filterText;
			
				clearTimeout(filterTimer);

				filterTimer = setTimeout(
					function() {
						uaListForm.submit()
					}, 
					300
					);
			}
		}
	});

	$(".ua-labels-editor").click(function (e)
	{
		e.preventDefault();
		var target = $(e.target).closest(".labels-section-content");
		AJS.Labels.openDialog(target);
	});

	AJS.bind("hide.dialog", function(e, data) 
	{
		if (data.dialog.id == 'edit-labels-dialog')
		{
			location.reload(true);
		}
	});

	uaSelectAll.click(function (e)
	{
		checkboxes = uaSelect;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			checkboxes[i].checked = e.target.checked;
		}
		checkboxes = uaSelectAll;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			checkboxes[i].checked = e.target.checked;
		}
		toggleDeleteSelectedLink(e.target.checked);
	});
	
	uaSelect.click(function (e)
	{
		allSelected = true;
		noneSelected = true;
		checkboxes = uaSelect;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			allSelected = allSelected & checkboxes[i].checked;
			noneSelected = noneSelected & !checkboxes[i].checked;
		}
		checkboxes = uaSelectAll;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			checkboxes[i].checked = allSelected;
		}
		toggleDeleteSelectedLink(!noneSelected);
	});

	function toggleDeleteSelectedLink(checked)
	{
		if (checked)
		{
			uaDeleteSelectedLabel.hide();
			uaDeleteSelectedLink.show();
		}
		else
		{
			uaDeleteSelectedLabel.show();
			uaDeleteSelectedLink.hide();
		}
	}

	if (uaInProgress) 
	{
		monitorProgress();
	}
	else
	{
		if (uaList.length > 0)
		{
			uaButtonFind.prop("value", AJS.I18n.getText("com.alutustech.confluentis.attachments.button.label.refresh"));
		}
		else
		{
			uaButtonFind.prop("value", AJS.I18n.getText("com.alutustech.confluentis.attachments.button.label.find"));
		}
		uaButtonFind.show();
		uaButtonCancel.hide();
		uaButtonDeleteCancel.hide();
		uaButtonBack.hide();
		uaProgressContainer.hide();
		uaSuccessMessageContainer.hide();
		uaErrorMessageContainer.hide();
		uaInfoMessageContainer.hide();
	}
	
	toggleDeleteSelectedLink(false);

});
