/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.FindUnusedAttachmentsTaskResult;
import com.alutustech.confluentis.attachments.UnusedAttachmentsManager;
import com.alutustech.confluentis.attachments.UnusedAttachmentsStatus;
import com.alutustech.confluentis.attachments.data.AttachmentData;
import com.alutustech.confluentis.attachments.data.SpaceData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsActionData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsFormData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsListData;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UnusedAttachmentsSearchSpaceAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final long serialVersionUID = 1L;
    public static final String LICENSE_MESSAGE_KEY_NO_LICENSE = "com.alutustech.confluentis.attachments.message.no.license";
    public static final String LICENSE_MESSAGE_KEY_INVALID_LICENSE = "com.alutustech.confluentis.attachments.message.invalid.license";
    private final UserManager salUserManager;
    private final SpaceManager spaceManager;
    private final AttachmentManager attachmentManager;
    private final UnusedAttachmentsManager unusedAttachmentsManager;
    private final PluginLicenseManager licenseManager;
    private final AccessModeService accessModeService;
    private final HtmlUtil htmlUtil = new HtmlUtil();
    private UnusedAttachmentsActionData actionData;

    public UnusedAttachmentsSearchSpaceAction(UserManager salUserManager, SpaceManager spaceManager, AttachmentManager attachmentManager, UnusedAttachmentsManager unusedAttachmentsManager, PluginLicenseManager licenseManager, AccessModeService accessModeService) {
        this.salUserManager = salUserManager;
        this.spaceManager = spaceManager;
        this.attachmentManager = attachmentManager;
        this.unusedAttachmentsManager = unusedAttachmentsManager;
        this.licenseManager = licenseManager;
        this.accessModeService = accessModeService;
    }

    public HtmlUtil getHtmlUtil() {
        return this.htmlUtil;
    }

    public UnusedAttachmentsActionData getActionData() {
        return this.actionData;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.VIEW, (Object)this.getSpace());
    }

    public String execute() throws Exception {
        HttpServletRequest request = new StaticHttpContext().getRequest();
        this.actionData = new UnusedAttachmentsActionData();
        UnusedAttachmentsFormData formData = UnusedAttachmentsFormData.getInstance(request);
        this.actionData.setFormData(formData);
        UnusedAttachmentsListData listData = null;
        String spaceKey = formData.getSpaceKey();
        spaceKey = spaceKey == null || spaceKey.trim().length() == 0 ? null : spaceKey;
        Space space = spaceKey == null ? null : this.spaceManager.getSpace(spaceKey);
        formData.setSpaceKey(spaceKey);
        ConfluenceUser user = this.getAuthenticatedUser();
        boolean canDelete = false;
        if (!this.accessModeService.isReadOnlyAccessModeEnabled() && user != null && (this.salUserManager.isAdmin(user.getName()) || space != null && this.spacePermissionManager.hasPermission("REMOVEATTACHMENT", space, user))) {
            canDelete = true;
        }
        this.actionData.setCanDelete(canDelete);
        FindUnusedAttachmentsTaskResult result = this.unusedAttachmentsManager.loadUnusedAttachmentsResult(spaceKey);
        if (result != null) {
            listData = new UnusedAttachmentsListData();
            HashSet<Long> spaces = new HashSet<Long>();
            HashSet allUnusedAttachments = new HashSet();
            for (Map.Entry<Long, Set<Long>> entry : result.getUnusedAttachments().entrySet()) {
                if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
                spaces.add(entry.getKey());
                allUnusedAttachments.addAll(entry.getValue());
            }
            listData.setSpaces(spaces);
            Set<Long> filteredAndSortedAttachmentIds = this.unusedAttachmentsManager.getFilteredAndSortedAttachmentIds(formData);
            filteredAndSortedAttachmentIds.retainAll(allUnusedAttachments);
            listData.setAttachments(filteredAndSortedAttachmentIds);
            listData.setResultTime(result.getResultTime());
            UnusedAttachmentsListData globalListData = this.unusedAttachmentsManager.loadUnusedAttachmentsSpacesOnly();
            if (globalListData != null && globalListData.getResultTime() == result.getResultTime()) {
                this.actionData.setLatestResult(true);
            }
            this.actionData.setTotalAttachmentsCount(allUnusedAttachments.size());
        }
        this.processActionData(this.actionData, listData);
        return "success";
    }

    private void processActionData(UnusedAttachmentsActionData actionData, UnusedAttachmentsListData listData) {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                actionData.setLicenseMessage(LICENSE_MESSAGE_KEY_INVALID_LICENSE);
            }
        } else {
            actionData.setLicenseMessage(LICENSE_MESSAGE_KEY_NO_LICENSE);
        }
        actionData.setAppMajorVersion(Integer.parseInt(GeneralUtil.getVersionNumber().split("[.]")[0]));
        UnusedAttachmentsStatus status = this.unusedAttachmentsManager.getStatus(actionData.getFormData().getSpaceKey(), null);
        actionData.setInProgress(status == null ? false : status.inProgress);
        if (listData != null) {
            Space space;
            actionData.setResultCreationDate(this.getDateFormatter().formatDateTime(new Date(listData.getResultTime())));
            HashMap<String, SpaceData> spaces = new HashMap<String, SpaceData>();
            if (listData.getSpaces() != null) {
                for (Long spaceId : listData.getSpaces()) {
                    Space space2 = this.spaceManager.getSpace(spaceId.longValue());
                    if (space2 == null) continue;
                    spaces.put(space2.getKey(), new SpaceData(space2.getKey(), space2.getName()));
                }
            }
            if (actionData.getFormData() != null && actionData.getFormData().getSpaceKey() != null && actionData.getFormData().getSpaceKey().trim().length() > 0 && !spaces.containsKey(actionData.getFormData().getSpaceKey()) && (space = this.spaceManager.getSpace(actionData.getFormData().getSpaceKey())) != null) {
                spaces.put(space.getKey(), new SpaceData(space.getKey(), space.getName()));
            }
            ArrayList<SpaceData> spacesList = new ArrayList<SpaceData>(spaces.values());
            Collections.sort(spacesList);
            actionData.setSpaces(spacesList);
            if (listData.getAttachments() != null) {
                ArrayList<AttachmentData> spaceUnusedAttachments = new ArrayList<AttachmentData>();
                int filledPage = 0;
                int i = 0;
                String rowsPerPageStr = actionData.getFormData().getRowsPerPage();
                Integer rowsPerPage = rowsPerPageStr == null || rowsPerPageStr.trim().length() == 0 ? null : Integer.valueOf(Integer.parseInt(rowsPerPageStr));
                rowsPerPage = rowsPerPage == null || rowsPerPage <= 0 ? 20 : rowsPerPage;
                int filteredAttachmentsCount = listData.getAttachments().size();
                int paginationCount = filteredAttachmentsCount / rowsPerPage + (filteredAttachmentsCount % rowsPerPage == 0 ? 0 : 1);
                UnusedAttachmentsFormData formData = actionData.getFormData();
                int pageIndex = paginationCount < formData.getPageIndex() ? paginationCount : formData.getPageIndex();
                formData.setPageIndex(pageIndex);
                for (Long attachmentId : listData.getAttachments()) {
                    if ((filledPage = ++i / rowsPerPage + (i % rowsPerPage == 0 ? 0 : 1)) == pageIndex) {
                        ContentEntityObject attachmentCEO;
                        Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
                        Attachment attachmentObj = attachment;
                        ContentEntityObject contentEntityObject = attachmentCEO = attachmentObj instanceof ContentEntityObject ? (ContentEntityObject)attachmentObj : null;
                        if (attachment == null || attachmentCEO != null && attachmentCEO.isDeleted()) continue;
                        Space space3 = attachment.getSpace();
                        AttachmentData attachmentData = new AttachmentData(attachmentId, space3.getKey(), space3.getName(), attachment.getContainer().toPageContext().getEntity().getId(), attachment.getContainer().toPageContext().getPageTitle(), attachment.getFileName(), attachment.getVersionComment(), attachment.getNiceFileSize(), this.getDateFormatter().formatDateTime(attachment.getCreationDate()));
                        spaceUnusedAttachments.add(attachmentData);
                        continue;
                    }
                    if (filledPage <= pageIndex) continue;
                    break;
                }
                actionData.setUnusedAttachments(spaceUnusedAttachments);
                actionData.setPaginationPageCount(paginationCount);
                actionData.setFilteredAttachmentsCount(filteredAttachmentsCount);
            }
        }
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }
}

