/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.FindUnusedAttachmentsTaskResult;
import com.alutustech.confluentis.attachments.UnusedAttachmentsManager;
import com.alutustech.confluentis.attachments.UnusedAttachmentsStatus;
import com.alutustech.confluentis.attachments.data.AttachmentData;
import com.alutustech.confluentis.attachments.data.SpaceData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsActionData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsFormData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsListData;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.breadcrumbs.spaceia.ContentDetailAction;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UnusedAttachmentsSearchPageAction
extends AbstractPageAwareAction
implements ContentDetailAction {
    private static final long serialVersionUID = 1L;
    public static final String LICENSE_MESSAGE_KEY_NO_LICENSE = "com.alutustech.confluentis.attachments.message.no.license";
    public static final String LICENSE_MESSAGE_KEY_INVALID_LICENSE = "com.alutustech.confluentis.attachments.message.invalid.license";
    private final UserManager salUserManager;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;
    private final UnusedAttachmentsManager unusedAttachmentsManager;
    private final PluginLicenseManager licenseManager;
    private final AccessModeService accessModeService;
    private final HtmlUtil htmlUtil = new HtmlUtil();
    private UnusedAttachmentsActionData actionData;

    public UnusedAttachmentsSearchPageAction(UserManager salUserManager, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, UnusedAttachmentsManager unusedAttachmentsManager, PluginLicenseManager licenseManager, AccessModeService accessModeService) {
        this.salUserManager = salUserManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.unusedAttachmentsManager = unusedAttachmentsManager;
        this.licenseManager = licenseManager;
        this.accessModeService = accessModeService;
    }

    public HtmlUtil getHtmlUtil() {
        return this.htmlUtil;
    }

    public UnusedAttachmentsActionData getActionData() {
        return this.actionData;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.VIEW, (Object)this.getPage());
    }

    public String execute() throws Exception {
        Long pageId;
        HttpServletRequest request = new StaticHttpContext().getRequest();
        this.actionData = new UnusedAttachmentsActionData();
        UnusedAttachmentsFormData formData = UnusedAttachmentsFormData.getInstance(request);
        this.actionData.setFormData(formData);
        UnusedAttachmentsListData listData = null;
        Space space = null;
        AbstractPage page = null;
        String strPageId = formData.getPageId();
        Long l = pageId = strPageId == null ? null : Long.valueOf(strPageId);
        if (pageId != null) {
            ContentEntityObject contentEntity = this.pageManager.getById(pageId.longValue());
            page = contentEntity instanceof AbstractPage ? (AbstractPage)contentEntity : null;
        }
        String spaceKey = formData.getSpaceKey();
        if (page == null) {
            spaceKey = spaceKey == null || spaceKey.trim().length() == 0 ? null : spaceKey;
            space = spaceKey == null ? null : this.spaceManager.getSpace(spaceKey);
        } else {
            space = page.getSpace();
            spaceKey = space.getKey();
        }
        formData.setSpaceKey(spaceKey);
        ConfluenceUser user = this.getAuthenticatedUser();
        boolean canDelete = false;
        if (!this.accessModeService.isReadOnlyAccessModeEnabled() && user != null && (this.salUserManager.isAdmin(user.getName()) || space != null && this.spacePermissionManager.hasPermission("REMOVEATTACHMENT", space, user))) {
            canDelete = true;
        }
        this.actionData.setCanDelete(canDelete);
        FindUnusedAttachmentsTaskResult result = this.unusedAttachmentsManager.loadUnusedAttachmentsResult(spaceKey);
        if (result != null) {
            listData = new UnusedAttachmentsListData();
            HashSet<Long> spaces = new HashSet<Long>();
            HashSet<Long> allUnusedAttachments = new HashSet<Long>();
            for (Map.Entry<Long, Set<Long>> entry : result.getUnusedAttachments().entrySet()) {
                Set<Long> attachmentIds = entry.getValue();
                if (attachmentIds == null || attachmentIds.size() <= 0) continue;
                if (page == null) {
                    spaces.add(entry.getKey());
                    allUnusedAttachments.addAll(attachmentIds);
                    continue;
                }
                boolean pageAttachmentFound = false;
                for (Long attachmentId : attachmentIds) {
                    Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
                    if (attachment == null || attachment.getContainer().getId() != page.getId()) continue;
                    allUnusedAttachments.add(attachmentId);
                    pageAttachmentFound = true;
                }
                if (!pageAttachmentFound) continue;
                spaces.add(entry.getKey());
            }
            listData.setSpaces(spaces);
            Set<Long> filteredAndSortedAttachmentIds = this.unusedAttachmentsManager.getFilteredAndSortedAttachmentIds(formData);
            filteredAndSortedAttachmentIds.retainAll(allUnusedAttachments);
            listData.setAttachments(filteredAndSortedAttachmentIds);
            listData.setResultTime(result.getResultTime());
            UnusedAttachmentsListData globalListData = this.unusedAttachmentsManager.loadUnusedAttachmentsSpacesOnly();
            if (globalListData != null && globalListData.getResultTime() == result.getResultTime()) {
                this.actionData.setLatestResult(true);
            }
            this.actionData.setTotalAttachmentsCount(allUnusedAttachments.size());
        }
        this.processActionData(this.actionData, listData);
        return "success";
    }

    private void processActionData(UnusedAttachmentsActionData actionData, UnusedAttachmentsListData listData) {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                actionData.setLicenseMessage(LICENSE_MESSAGE_KEY_INVALID_LICENSE);
            }
        } else {
            actionData.setLicenseMessage(LICENSE_MESSAGE_KEY_NO_LICENSE);
        }
        actionData.setAppMajorVersion(Integer.parseInt(GeneralUtil.getVersionNumber().split("[.]")[0]));
        UnusedAttachmentsStatus status = this.unusedAttachmentsManager.getStatus(actionData.getFormData().getSpaceKey(), actionData.getFormData().getPageId() == null ? null : Long.valueOf(actionData.getFormData().getPageId()));
        actionData.setInProgress(status == null ? false : status.inProgress);
        if (listData != null) {
            actionData.setResultCreationDate(this.getDateFormatter().formatDateTime(new Date(listData.getResultTime())));
            HashMap<String, SpaceData> spaces = new HashMap<String, SpaceData>();
            if (listData.getSpaces() != null) {
                for (Long spaceId : listData.getSpaces()) {
                    Space space = this.spaceManager.getSpace(spaceId.longValue());
                    if (space == null) continue;
                    spaces.put(space.getKey(), new SpaceData(space.getKey(), space.getName()));
                }
            }
            if (actionData.getFormData() != null) {
                Space space;
                Long pageId;
                String spaceKey = null;
                String strPageId = actionData.getFormData().getPageId();
                Long l = pageId = strPageId == null ? null : Long.valueOf(strPageId);
                if (pageId != null) {
                    AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
                    spaceKey = page == null ? null : page.getSpaceKey();
                }
                String string = spaceKey = spaceKey == null ? actionData.getFormData().getSpaceKey() : spaceKey;
                if (spaceKey != null && spaceKey.trim().length() > 0 && !spaces.containsKey(spaceKey) && (space = this.spaceManager.getSpace(spaceKey)) != null) {
                    spaces.put(space.getKey(), new SpaceData(space.getKey(), space.getName()));
                }
            }
            ArrayList<SpaceData> spacesList = new ArrayList<SpaceData>(spaces.values());
            Collections.sort(spacesList);
            actionData.setSpaces(spacesList);
            if (listData.getAttachments() != null) {
                ArrayList<AttachmentData> spaceUnusedAttachments = new ArrayList<AttachmentData>();
                int filledPage = 0;
                int i = 0;
                String rowsPerPageStr = actionData.getFormData().getRowsPerPage();
                Integer rowsPerPage = rowsPerPageStr == null || rowsPerPageStr.trim().length() == 0 ? null : Integer.valueOf(Integer.parseInt(rowsPerPageStr));
                rowsPerPage = rowsPerPage == null || rowsPerPage <= 0 ? 20 : rowsPerPage;
                int filteredAttachmentsCount = listData.getAttachments().size();
                int paginationCount = filteredAttachmentsCount / rowsPerPage + (filteredAttachmentsCount % rowsPerPage == 0 ? 0 : 1);
                UnusedAttachmentsFormData formData = actionData.getFormData();
                int pageIndex = paginationCount < formData.getPageIndex() ? paginationCount : formData.getPageIndex();
                formData.setPageIndex(pageIndex);
                for (Long attachmentId : listData.getAttachments()) {
                    if ((filledPage = ++i / rowsPerPage + (i % rowsPerPage == 0 ? 0 : 1)) == pageIndex) {
                        ContentEntityObject attachmentCEO;
                        Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
                        Attachment attachmentObj = attachment;
                        ContentEntityObject contentEntityObject = attachmentCEO = attachmentObj instanceof ContentEntityObject ? (ContentEntityObject)attachmentObj : null;
                        if (attachment == null || attachmentCEO != null && attachmentCEO.isDeleted()) continue;
                        Space space = attachment.getSpace();
                        AttachmentData attachmentData = new AttachmentData(attachmentId, space.getKey(), space.getName(), attachment.getContainer().toPageContext().getEntity().getId(), attachment.getContainer().toPageContext().getPageTitle(), attachment.getFileName(), attachment.getVersionComment(), attachment.getNiceFileSize(), this.getDateFormatter().formatDateTime(attachment.getCreationDate()));
                        spaceUnusedAttachments.add(attachmentData);
                        continue;
                    }
                    if (filledPage <= pageIndex) continue;
                    break;
                }
                actionData.setUnusedAttachments(spaceUnusedAttachments);
                actionData.setPaginationPageCount(paginationCount);
                actionData.setFilteredAttachmentsCount(filteredAttachmentsCount);
            }
        }
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }
}

