/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.UnusedAttachmentsDeleteRequest;
import com.alutustech.confluentis.attachments.UnusedAttachmentsManager;
import com.alutustech.confluentis.attachments.data.LongTaskResponse;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsFormData;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public class UnusedAttachmentsRestService {
    private static final Logger log = LoggerFactory.getLogger(UnusedAttachmentsRestService.class);
    private final com.atlassian.sal.api.user.UserManager salUserManager;
    private final UserManager userManager;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final SpacePermissionManager spacePermissionManager;
    private final UnusedAttachmentsManager unusedAttachmentsManager;

    public UnusedAttachmentsRestService(com.atlassian.sal.api.user.UserManager salUserManager, UserManager userManager, SpaceManager spaceManager, PageManager pageManager, SpacePermissionManager spacePermissionManager, UnusedAttachmentsManager unusedAttachmentsManager) {
        this.salUserManager = salUserManager;
        this.userManager = userManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.spacePermissionManager = spacePermissionManager;
        this.unusedAttachmentsManager = unusedAttachmentsManager;
    }

    @PUT
    @Path(value="findunusedattachments")
    public Response findUnusedAttachments(@Context HttpServletRequest request) {
        String username = this.salUserManager.getRemoteUsername(request);
        if (username == null || !this.salUserManager.isAdmin(username)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        LongTaskResponse response = null;
        try {
            User user = this.userManager.getUser(username);
            response = this.unusedAttachmentsManager.createFindTask(user);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to find unused attachments.", (Throwable)e);
            }
            return Response.serverError().build();
        }
        return Response.ok((Object)response).build();
    }

    @PUT
    @Path(value="cancelfindunusedattachments")
    public Response cancelFindUnusedAttachments(@Context HttpServletRequest request) {
        String username = this.salUserManager.getRemoteUsername(request);
        if (username == null || !this.salUserManager.isAdmin(username)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.unusedAttachmentsManager.cancelFindUnusedAttachments();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to cancel unused attachments search.", (Throwable)e);
            }
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="unusedattachmentsstatus")
    public Response getUnusedAttachmentsStatus(@Context HttpServletRequest request) {
        String spaceKey = request.getParameter("spaceKey");
        String strPageId = request.getParameter("pageId");
        Long pageId = strPageId == null ? null : Long.valueOf(strPageId);
        return Response.ok((Object)this.unusedAttachmentsManager.getStatus(spaceKey, pageId)).build();
    }

    @POST
    @Path(value="deleteunusedattachments")
    public Response deleteUnusedAttachments(@Context HttpServletRequest httpRequest, UnusedAttachmentsDeleteRequest deleteRequest) {
        Long pageId;
        User user = null;
        String username = this.salUserManager.getRemoteUsername(httpRequest);
        if (username != null) {
            try {
                user = this.userManager.getUser(username);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Failed to load user object: " + username, (Throwable)e);
                }
                return Response.serverError().build();
            }
        }
        Space space = null;
        String spaceKey = null;
        AbstractPage page = null;
        String strPageId = deleteRequest.getPageId();
        Long l = pageId = strPageId == null ? null : Long.valueOf(strPageId);
        if (pageId != null) {
            ContentEntityObject contentEntity = this.pageManager.getById(pageId.longValue());
            AbstractPage abstractPage = page = contentEntity instanceof AbstractPage ? (AbstractPage)contentEntity : null;
        }
        if (page == null) {
            spaceKey = deleteRequest.isGlobal() != false ? null : deleteRequest.getSpaceKey();
            spaceKey = spaceKey == null || spaceKey.trim().length() == 0 ? null : spaceKey;
            space = spaceKey == null ? null : this.spaceManager.getSpace(spaceKey);
        } else {
            space = page.getSpace();
            spaceKey = space.getKey();
        }
        if (user == null || !this.salUserManager.isAdmin(username) && (space == null || !this.spacePermissionManager.hasPermission("REMOVEATTACHMENT", space, user))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        boolean notifyWatchers = deleteRequest != null && deleteRequest.getNotifyWatchers() != null ? deleteRequest.getNotifyWatchers() : false;
        LongTaskResponse response = null;
        try {
            if (deleteRequest != null && deleteRequest.getAttachments() != null && deleteRequest.getAttachments().size() > 0) {
                response = this.unusedAttachmentsManager.createDeleteTask(user, notifyWatchers, deleteRequest.getAttachments(), spaceKey, pageId);
            } else {
                UnusedAttachmentsFormData formData = new UnusedAttachmentsFormData();
                formData.setSpaceKey(deleteRequest.getSpaceKey());
                formData.setPageId(deleteRequest.getPageId());
                String filterText = deleteRequest.getFilterText();
                String string = filterText = filterText != null && filterText.trim().length() == 0 ? null : filterText;
                if (filterText != null) {
                    formData.setFilterText(filterText);
                }
                response = this.unusedAttachmentsManager.createDeleteTask(user, notifyWatchers, formData, spaceKey, pageId);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to delete unused attachments.", (Throwable)e);
            }
            return Response.serverError().build();
        }
        return Response.ok((Object)response).build();
    }

    @PUT
    @Path(value="canceldeleteattachments")
    public Response cancelDeleteAttachments(@Context HttpServletRequest httpRequest) {
        Long pageId;
        User user = null;
        String username = this.salUserManager.getRemoteUsername(httpRequest);
        if (username != null) {
            try {
                user = this.userManager.getUser(username);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Failed to load user object: " + username, (Throwable)e);
                }
                return Response.serverError().build();
            }
        }
        Space space = null;
        String spaceKey = null;
        AbstractPage page = null;
        String strPageId = httpRequest.getParameter("pageId");
        Long l = pageId = strPageId == null ? null : Long.valueOf(strPageId);
        if (pageId != null) {
            ContentEntityObject contentEntity = this.pageManager.getById(pageId.longValue());
            AbstractPage abstractPage = page = contentEntity instanceof AbstractPage ? (AbstractPage)contentEntity : null;
        }
        if (page == null) {
            spaceKey = httpRequest.getParameter("spaceKey");
            spaceKey = spaceKey == null || spaceKey.trim().length() == 0 ? null : spaceKey;
            space = spaceKey == null ? null : this.spaceManager.getSpace(spaceKey);
        } else {
            space = page.getSpace();
            spaceKey = space.getKey();
        }
        if (user == null || !this.salUserManager.isAdmin(username) && (space == null || !this.spacePermissionManager.hasPermission("REMOVEATTACHMENT", space, user))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.unusedAttachmentsManager.cancelDeleteAttachments(spaceKey, pageId);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to cancel unused attachments deletion.", (Throwable)e);
            }
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }
}

