/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.UnusedAttachmentsManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;

public class UnusedAttachmentsEventListener
implements DisposableBean {
    private static final String ATTACHMENT_TRASHED_EVENT_CLASS_NAME = "com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent";
    private final EventPublisher eventPublisher;
    private final UnusedAttachmentsManager unusedAttachmentsManager;

    public UnusedAttachmentsEventListener(EventPublisher eventPublisher, UnusedAttachmentsManager unusedAttachmentsManager) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
        this.unusedAttachmentsManager = unusedAttachmentsManager;
    }

    @EventListener
    public void spaceRemoveEvent(SpaceRemoveEvent event) {
        this.unusedAttachmentsManager.removeSpace(event.getSpace());
    }

    @EventListener
    public void spaceUpdateEvent(SpaceUpdateEvent event) {
        this.unusedAttachmentsManager.updateSpace(event.getSpace());
    }

    @EventListener
    public void pageCreateEvent(PageCreateEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getPage());
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getPage());
    }

    @EventListener
    public void pageRestoreEvent(PageRestoreEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getPage());
    }

    @EventListener
    public void pageMoveEvent(PageMoveEvent event) {
        Long oldSpaceId = event.getOldSpace().getId();
        Long newSpaceId = event.getPage().getSpace().getId();
        if (!newSpaceId.equals(oldSpaceId)) {
            this.unusedAttachmentsManager.movePage((AbstractPage)event.getPage(), oldSpaceId);
        }
    }

    @EventListener
    public void pageTrashedEvent(PageTrashedEvent event) {
        this.unusedAttachmentsManager.removePage((AbstractPage)event.getPage());
    }

    @EventListener
    public void blogPostCreateEvent(BlogPostCreateEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getBlogPost());
    }

    @EventListener
    public void blogPostUpdateEvent(BlogPostUpdateEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getBlogPost());
    }

    @EventListener
    public void blogPostRestoreEvent(BlogPostRestoreEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getBlogPost());
    }

    @EventListener
    public void blogPostMoveEvent(BlogPostMovedEvent event) {
        Long oldSpaceId = event.getOriginalSpace().getId();
        Long newSpaceId = event.getCurrentSpace().getId();
        if (!newSpaceId.equals(oldSpaceId)) {
            this.unusedAttachmentsManager.movePage((AbstractPage)event.getBlogPost(), oldSpaceId);
        }
    }

    @EventListener
    public void blogPostTrashedEvent(BlogPostTrashedEvent event) {
        this.unusedAttachmentsManager.removePage((AbstractPage)event.getBlogPost());
    }

    @EventListener
    public void commentCreateEvent(CommentCreateEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getComment());
    }

    @EventListener
    public void commentUpdateEvent(CommentUpdateEvent event) {
        this.unusedAttachmentsManager.processContent((ContentEntityObject)event.getComment());
    }

    @EventListener
    public void attachmentUpdateEvent(AttachmentUpdateEvent event) {
        List attachments;
        Attachment oldAttachment = event.getOld();
        Attachment newAttachment = event.getNew();
        Long oldSpaceId = oldAttachment.getSpace().getId();
        Long newSpaceId = newAttachment.getSpace().getId();
        if (!newSpaceId.equals(oldSpaceId) && (attachments = event.getAttachments()) != null && attachments.size() > 0) {
            this.unusedAttachmentsManager.moveAttachment((Attachment)attachments.get(0), oldSpaceId, newSpaceId);
        }
        if (!oldAttachment.getFileName().equals(newAttachment.getFileName()) && (attachments = event.getAttachments()) != null && attachments.size() > 0) {
            this.unusedAttachmentsManager.renameAttachment((Attachment)attachments.get(0), newAttachment.getFileName());
        }
    }

    @EventListener
    public void attachmentEvent(AttachmentEvent event) {
        List attachments;
        boolean supportsTrashedAttachments = true;
        try {
            Class.forName(ATTACHMENT_TRASHED_EVENT_CLASS_NAME, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            supportsTrashedAttachments = false;
        }
        if ((supportsTrashedAttachments && event.getClass().getName().equals(ATTACHMENT_TRASHED_EVENT_CLASS_NAME) || !supportsTrashedAttachments && event.getClass().getName().equals(AttachmentRemoveEvent.class.getName())) && (attachments = event.getAttachments()) != null && attachments.size() > 0) {
            this.unusedAttachmentsManager.removeAttachment((Attachment)attachments.get(0));
        }
    }

    @EventListener
    public void labelAddEvent(LabelAddEvent event) {
        Labelable labelable = event.getLabelled();
        if (labelable instanceof SpaceDescription) {
            this.unusedAttachmentsManager.addSpaceLabel(((SpaceDescription)event.getLabelled()).getSpace(), event.getLabel().getName());
        } else if (labelable instanceof AbstractPage) {
            this.unusedAttachmentsManager.addPageLabel((AbstractPage)labelable, event.getLabel().getName());
        } else if (labelable instanceof Attachment) {
            this.unusedAttachmentsManager.addAttachmentLabel((Attachment)labelable, event.getLabel().getName());
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

