/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.AbstractAttachmentXhtmlVisitor;
import com.alutustech.confluentis.attachments.UnusedAttachmentsConfig;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FindTaskAttachmentXhtmlVisitor
extends AbstractAttachmentXhtmlVisitor {
    private final Set<Long> ignoredAttachmentsSpaces;
    private final Map<Long, Set<Long>> unusedAttachmentsMap;
    private final Set<Long> attachmentsRefsSet;

    public FindTaskAttachmentXhtmlVisitor(UnusedAttachmentsConfig config, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager, Set<Long> ignoredAttachmentsSpaces, Map<Long, Set<Long>> unusedAttachmentsMap, Set<Long> attachmentsRefsSet) {
        super(config, spaceManager, pageManager, attachmentManager, thumbnailManager);
        this.ignoredAttachmentsSpaces = ignoredAttachmentsSpaces;
        this.unusedAttachmentsMap = unusedAttachmentsMap;
        this.attachmentsRefsSet = attachmentsRefsSet;
    }

    @Override
    public void processAttachmentReference(long spaceId, long attachmentId) {
        Set<Long> unusedAttachmentsSet = this.unusedAttachmentsMap.get(spaceId);
        if (unusedAttachmentsSet != null && unusedAttachmentsSet.contains(attachmentId)) {
            unusedAttachmentsSet.remove(attachmentId);
        } else {
            this.attachmentsRefsSet.add(attachmentId);
        }
    }

    @Override
    public void processSamePageAttachments(long spaceId, List<Attachment> attachments) {
        Set<Long> unusedAttachmentsSet = this.unusedAttachmentsMap.get(spaceId);
        for (Attachment attachment : attachments) {
            Long attachmentId = attachment.getId();
            if (unusedAttachmentsSet == null) continue;
            unusedAttachmentsSet.remove(attachmentId);
        }
    }

    @Override
    public void processOtherPageAttachments(long spaceId, List<Attachment> attachments) {
        Set<Long> unusedAttachmentsSet = this.unusedAttachmentsMap.get(spaceId);
        for (Attachment attachment : attachments) {
            Long attachmentId = attachment.getId();
            if (unusedAttachmentsSet != null && unusedAttachmentsSet.contains(attachmentId)) {
                unusedAttachmentsSet.remove(attachmentId);
                continue;
            }
            this.attachmentsRefsSet.add(attachmentId);
        }
    }

    @Override
    public void processSpaceAttachments(long spaceId) {
        this.ignoredAttachmentsSpaces.add(spaceId);
        if (this.unusedAttachmentsMap.containsKey(spaceId)) {
            this.unusedAttachmentsMap.put(spaceId, null);
        }
    }
}

