/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.AbstractAttachmentXhtmlVisitor;
import com.alutustech.confluentis.attachments.ContentEventAttachmentXhtmlVisitor;
import com.alutustech.confluentis.attachments.FindTaskAttachmentXhtmlVisitor;
import com.alutustech.confluentis.attachments.FindUnusedAttachmentsGlobalResult;
import com.alutustech.confluentis.attachments.FindUnusedAttachmentsSpaceResult;
import com.alutustech.confluentis.attachments.FindUnusedAttachmentsTaskResult;
import com.alutustech.confluentis.attachments.UnusedAttachmentsConfig;
import com.alutustech.confluentis.attachments.UnusedAttachmentsLongRunningTaskStatus;
import com.alutustech.confluentis.attachments.UnusedAttachmentsManager;
import com.alutustech.confluentis.attachments.UnusedAttachmentsStatus;
import com.alutustech.confluentis.attachments.data.LongTaskResponse;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsFormData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsListData;
import com.alutustech.confluentis.attachments.util.UnusedAttachmentsUtil;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.DefaultSearchResults;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchConstants;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.MultiTextFieldQuery;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.FilenameSort;
import com.atlassian.confluence.search.v2.sort.FilesizeSort;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultUnusedAttachmentsManager
implements UnusedAttachmentsManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUnusedAttachmentsManager.class);
    private static final SearchResults EMPTY_RESULTS = new DefaultSearchResults(Collections.emptyList(), 0);
    private static final String UNUSED_ATTACHMENTS_BANDANA_GLOBAL_KEY = DefaultUnusedAttachmentsManager.class.getName() + ":spaces";
    private static final String UNUSED_ATTACHMENTS_BANDANA_SPACE_KEY = DefaultUnusedAttachmentsManager.class.getName() + ":attachments";
    private static final String TASK_STATUS_BANDANA_KEY = DefaultUnusedAttachmentsManager.class.getName() + ":task.status";
    private static final String CANCEL_FLAG_BANDANA_KEY = DefaultUnusedAttachmentsManager.class.getName() + ":cancel.flag";
    private static final Lock TASK_STATUS_LOCK = new ReentrantLock();
    private final UserManager userManager;
    private final SearchManager searchManager;
    private final ContentEntityManager contentEntityManager;
    private final SpaceManager spaceManager;
    private final LabelManager labelManager;
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;
    private final ConfluenceIndexer indexer;
    private final EventPublisher eventManager;
    private final ThumbnailManager thumbnailManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final XhtmlContent xhtmlContent;
    private final I18nResolver i18n;
    private final LongRunningTaskManager taskManager;
    private final BandanaManager bandanaManager;
    private Map<Long, UnusedAttachmentsLongRunningTaskStatus> deleteTaskStatusMap = new HashMap<Long, UnusedAttachmentsLongRunningTaskStatus>();
    private Map<Long, Long> deleteCancelFlagMap = new HashMap<Long, Long>();
    private Map<Long, Set<Long>> crtUnusedAttachmentsMap;
    private Set<Long> skipRemoveEventAttachments = new HashSet<Long>();

    public DefaultUnusedAttachmentsManager(UserManager userManager, SearchManager searchManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, SpaceManager spaceManager, LabelManager labelManager, PageManager pageManager, AttachmentManager attachmentManager, ConfluenceIndexer indexer, EventPublisher eventManager, ThumbnailManager thumbnailManager, PluginSettingsFactory pluginSettingsFactory, XhtmlContent xhtmlContent, I18nResolver i18n, LongRunningTaskManager taskManager, BandanaManager bandanaManager) {
        this.userManager = userManager;
        this.searchManager = searchManager;
        this.contentEntityManager = contentEntityManager;
        this.spaceManager = spaceManager;
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.indexer = indexer;
        this.eventManager = eventManager;
        this.thumbnailManager = thumbnailManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.xhtmlContent = xhtmlContent;
        this.i18n = i18n;
        this.taskManager = taskManager;
        this.bandanaManager = bandanaManager;
    }

    @Override
    public UnusedAttachmentsStatus getStatus(String spaceKey, Long pageId) {
        UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus(spaceKey, pageId);
        if (taskStatus == null) {
            return null;
        }
        boolean isCancelled = this.isCancelled(spaceKey, pageId);
        UnusedAttachmentsStatus status = new UnusedAttachmentsStatus();
        status.isDeleteTask = taskStatus.isDeleteTask();
        status.isSaveTask = taskStatus.isSaveTask();
        status.message = this.i18n.getText(taskStatus.getTotal() == null ? "com.alutustech.confluentis.attachments.message.estimate.status" : (status.isDeleteTask ? "com.alutustech.confluentis.attachments.message.delete.status" : (taskStatus.isSaveTask() ? "com.alutustech.confluentis.attachments.message.save.status" : "com.alutustech.confluentis.attachments.message.search.status")), new Serializable[]{taskStatus.getCurrentCount(), taskStatus.getTotal()});
        status.inProgress = !taskStatus.isComplete() && !isCancelled;
        status.cancelled = isCancelled;
        status.success = taskStatus.isSuccessful();
        status.remainingTime = taskStatus.getRemainingTime();
        status.percentage = taskStatus.getPercentage();
        return status;
    }

    @Override
    public UnusedAttachmentsListData loadUnusedAttachmentsSpacesOnly() {
        UnusedAttachmentsListData listData = null;
        FindUnusedAttachmentsGlobalResult globalResult = this.getGlobalResult();
        if (globalResult != null) {
            listData = new UnusedAttachmentsListData();
            Long[] spaceIds = globalResult.getUnusedAttachmentsSpaces();
            if (spaceIds != null) {
                listData.setSpaces(new HashSet<Long>(Arrays.asList(spaceIds)));
            }
            listData.setResultTime(globalResult.getResultTime());
        }
        return listData;
    }

    private FindUnusedAttachmentsGlobalResult getGlobalResult() {
        Map globalResultMap;
        Object globalResultObject = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, UNUSED_ATTACHMENTS_BANDANA_GLOBAL_KEY, false);
        Map map = globalResultMap = globalResultObject instanceof Map ? (Map)globalResultObject : null;
        if (globalResultMap == null) {
            return null;
        }
        return new FindUnusedAttachmentsGlobalResult(globalResultMap);
    }

    private void setGlobalResult(FindUnusedAttachmentsGlobalResult globalResult) {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, UNUSED_ATTACHMENTS_BANDANA_GLOBAL_KEY, globalResult.getValues());
    }

    private void removeGlobalResult() {
        this.bandanaManager.removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, UNUSED_ATTACHMENTS_BANDANA_GLOBAL_KEY);
    }

    private FindUnusedAttachmentsSpaceResult getSpaceResult(Space space) {
        Map spaceResultMap;
        Object spaceResultObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), UNUSED_ATTACHMENTS_BANDANA_SPACE_KEY, false);
        Map map = spaceResultMap = spaceResultObject instanceof Map ? (Map)spaceResultObject : null;
        if (spaceResultMap == null) {
            return null;
        }
        return new FindUnusedAttachmentsSpaceResult(spaceResultMap);
    }

    private void setSpaceResult(Space space, FindUnusedAttachmentsSpaceResult spaceResult) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), UNUSED_ATTACHMENTS_BANDANA_SPACE_KEY, spaceResult.getValues());
    }

    private UnusedAttachmentsLongRunningTaskStatus getTaskStatus() {
        Map findTaskStatusMap;
        Object findTaskStatusObject = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, TASK_STATUS_BANDANA_KEY, false);
        Map map = findTaskStatusMap = findTaskStatusObject instanceof Map ? (Map)findTaskStatusObject : null;
        if (findTaskStatusMap == null) {
            return null;
        }
        return new UnusedAttachmentsLongRunningTaskStatus(findTaskStatusMap);
    }

    private void setTaskStatus(UnusedAttachmentsLongRunningTaskStatus findTaskStatus) {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, TASK_STATUS_BANDANA_KEY, findTaskStatus.getValues());
    }

    private Long getCancelFlag() {
        return (Long)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, CANCEL_FLAG_BANDANA_KEY, false);
    }

    private void setCancelFlag() {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, CANCEL_FLAG_BANDANA_KEY, (Object)System.currentTimeMillis());
    }

    private void setCancelFlag(String spaceKey, Long pageId) {
        if (pageId == null) {
            if (spaceKey == null) {
                this.setCancelFlag();
            } else {
                Space space = this.spaceManager.getSpace(spaceKey);
                this.setCancelFlag(space);
            }
        } else {
            this.setCancelFlag(pageId);
        }
    }

    private void removeCancelFlag() {
        this.bandanaManager.removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, CANCEL_FLAG_BANDANA_KEY);
    }

    private void removeCancelFlag(Space space, Long pageId) {
        if (pageId == null) {
            if (space == null) {
                this.removeCancelFlag();
            } else {
                this.removeCancelFlag(space);
            }
        } else {
            this.removeCancelFlag(pageId);
        }
    }

    private void setDeleteTaskStatus(Space space, Long pageId, UnusedAttachmentsLongRunningTaskStatus deleteTaskStatus) {
        if (pageId == null) {
            if (space == null) {
                this.setTaskStatus(deleteTaskStatus);
            } else {
                this.setDeleteTaskStatus(space, deleteTaskStatus);
            }
        } else {
            this.setDeleteTaskStatus(pageId, deleteTaskStatus);
        }
    }

    private UnusedAttachmentsLongRunningTaskStatus getDeleteTaskStatus(Space space) {
        Map deleteTaskStatusMap;
        Object deleteTaskStatusObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), TASK_STATUS_BANDANA_KEY, false);
        Map map = deleteTaskStatusMap = deleteTaskStatusObject instanceof Map ? (Map)deleteTaskStatusObject : null;
        if (deleteTaskStatusMap == null) {
            return null;
        }
        return new UnusedAttachmentsLongRunningTaskStatus(deleteTaskStatusMap);
    }

    private void setDeleteTaskStatus(Space space, UnusedAttachmentsLongRunningTaskStatus deleteTaskStatus) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), TASK_STATUS_BANDANA_KEY, deleteTaskStatus.getValues());
    }

    private UnusedAttachmentsLongRunningTaskStatus getDeleteTaskStatus(Long pageId) {
        return this.deleteTaskStatusMap.get(pageId);
    }

    private void setDeleteTaskStatus(Long pageId, UnusedAttachmentsLongRunningTaskStatus deleteTaskStatus) {
        this.deleteTaskStatusMap.put(pageId, deleteTaskStatus);
    }

    private Long getCancelFlag(Space space) {
        return (Long)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), CANCEL_FLAG_BANDANA_KEY, false);
    }

    private void setCancelFlag(Space space) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), CANCEL_FLAG_BANDANA_KEY, (Object)System.currentTimeMillis());
    }

    private void removeCancelFlag(Space space) {
        this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(space), CANCEL_FLAG_BANDANA_KEY);
    }

    private Long getCancelFlag(Long pageId) {
        return this.deleteCancelFlagMap.get(pageId);
    }

    private void setCancelFlag(Long pageId) {
        this.deleteCancelFlagMap.put(pageId, System.currentTimeMillis());
    }

    private void removeCancelFlag(Long pageId) {
        this.deleteCancelFlagMap.remove(pageId);
    }

    @Override
    public FindUnusedAttachmentsTaskResult loadUnusedAttachmentsResult(String spaceKey) {
        Long resultTime = null;
        Long[] spaceIds = null;
        if (spaceKey == null || spaceKey.trim().length() == 0) {
            FindUnusedAttachmentsGlobalResult globalResult = this.getGlobalResult();
            if (globalResult != null) {
                spaceIds = globalResult.getUnusedAttachmentsSpaces();
                resultTime = globalResult.getResultTime();
            }
        } else {
            Long[] longArray;
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = space.getId();
            }
            spaceIds = longArray;
        }
        return this.loadUnusedAttachmentsResult(resultTime, spaceIds);
    }

    private FindUnusedAttachmentsTaskResult loadUnusedAttachmentsResult(Long spaceId) {
        return this.loadUnusedAttachmentsResult(null, new Long[]{spaceId});
    }

    private FindUnusedAttachmentsTaskResult loadUnusedAttachmentsResult(Long resultTime, Long[] spaceIds) {
        FindUnusedAttachmentsTaskResult result = null;
        if (spaceIds != null) {
            HashMap<Long, Set<Long>> unusedAttachments = new HashMap<Long, Set<Long>>();
            for (Long spaceId : spaceIds) {
                FindUnusedAttachmentsSpaceResult spaceResult;
                Space space = this.spaceManager.getSpace(spaceId.longValue());
                if (space == null || (spaceResult = this.getSpaceResult(space)) == null) continue;
                HashSet<Long> attachmentIdsSet = null;
                Long[] attachmentIds = spaceResult.getUnusedAttachments();
                if (attachmentIds != null) {
                    attachmentIdsSet = new HashSet<Long>(attachmentIds.length);
                    for (Long attachmentId : attachmentIds) {
                        attachmentIdsSet.add(attachmentId);
                    }
                }
                unusedAttachments.put(spaceId, attachmentIdsSet);
                if (resultTime != null) continue;
                resultTime = spaceResult.getResultTime();
            }
            if (resultTime != null) {
                result = new FindUnusedAttachmentsTaskResult(unusedAttachments, resultTime);
            }
        }
        return result;
    }

    @Override
    public void configSaveCleanup() {
        this.removeGlobalResult();
        this.removeCancelFlag();
    }

    private void saveUnusedAttachmentsResult(ConfluenceAbstractLongRunningTask task, ProgressMeter progress, FindUnusedAttachmentsTaskResult result, boolean isGlobal) {
        if (result == null) {
            if (isGlobal) {
                this.removeGlobalResult();
            }
        } else {
            Long[] spaceIds = null;
            Map<Long, Set<Long>> unusedAttachments = result.getUnusedAttachments();
            if (unusedAttachments != null) {
                Set<Long> spaceIdsSet = result.getUnusedAttachments().keySet();
                spaceIds = spaceIdsSet == null ? null : spaceIdsSet.toArray(new Long[spaceIdsSet.size()]);
            }
            HashSet<Object> globalSpaceIds = null;
            if (spaceIds != null) {
                if (progress != null) {
                    progress.setTotalObjects(spaceIds.length);
                    progress.setCurrentCount(0);
                    UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
                    if (taskStatus != null) {
                        taskStatus.update((LongRunningTask)task, progress);
                        taskStatus.setSaveTask(true);
                        this.setTaskStatus(taskStatus);
                    }
                }
                globalSpaceIds = new HashSet<Object>();
                for (Long spaceId : spaceIds) {
                    if (progress != null && this.isCancelled((Space)null, null)) {
                        progress.setPercentage(100);
                        progress.setCompletedSuccessfully(false);
                        UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
                        taskStatus.update((LongRunningTask)task, progress);
                        this.setTaskStatus(taskStatus);
                        return;
                    }
                    Space space = this.spaceManager.getSpace(spaceId.longValue());
                    if (space != null) {
                        Long[] attachmentIds = null;
                        Set<Long> attachmentIdsSet = result.getUnusedAttachments().get(spaceId);
                        if (attachmentIdsSet != null && attachmentIdsSet.size() > 0) {
                            attachmentIds = attachmentIdsSet.toArray(new Long[attachmentIdsSet.size()]);
                            globalSpaceIds.add(spaceId);
                        }
                        FindUnusedAttachmentsSpaceResult spaceResult = new FindUnusedAttachmentsSpaceResult(attachmentIds, result.getResultTime());
                        this.setSpaceResult(space, spaceResult);
                    }
                    if (progress == null || progress.getTotal() <= progress.getCurrentCount() + 1) continue;
                    progress.setCurrentCount(progress.getCurrentCount() + 1);
                    UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
                    taskStatus.update((LongRunningTask)task, progress);
                    this.setTaskStatus(taskStatus);
                }
            }
            if (isGlobal) {
                FindUnusedAttachmentsGlobalResult globalResult = new FindUnusedAttachmentsGlobalResult(globalSpaceIds == null ? null : globalSpaceIds.toArray(new Long[globalSpaceIds.size()]), result.getResultTime());
                this.setGlobalResult(globalResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongTaskResponse createFindTask(User user) {
        LongTaskResponse response = new LongTaskResponse();
        UnusedAttachmentsStatus status = this.getStatus(null, null);
        if (status != null && status.inProgress) {
            response.accepted = false;
        } else {
            UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
            Object task = null;
            if (taskStatus != null && (task = this.getLongRunningTask(taskStatus.getUser(), taskStatus.getTaskId())) != null) {
                this.taskManager.stopTrackingLongRunningTask(LongRunningTaskId.valueOf((String)taskStatus.getTaskId()));
            }
            boolean lockAcquired = false;
            try {
                lockAcquired = TASK_STATUS_LOCK.tryLock(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (lockAcquired) {
                try {
                    taskStatus = new UnusedAttachmentsLongRunningTaskStatus(user.getName());
                    task = new ConfluenceAbstractLongRunningTask(){

                        public String getName() {
                            return "Confluentis Unused Attachments Find Task";
                        }

                        protected void runInternal() {
                            DefaultUnusedAttachmentsManager.this.findUnusedAttachments(this, this.progress);
                        }
                    };
                    taskStatus.setTaskId(this.taskManager.startLongRunningTask(user, task).toString());
                    this.removeCancelFlag();
                    this.setTaskStatus(taskStatus);
                }
                finally {
                    TASK_STATUS_LOCK.unlock();
                }
                response.accepted = true;
            } else {
                response.accepted = false;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findUnusedAttachments(ConfluenceAbstractLongRunningTask task, ProgressMeter progress) {
        UnusedAttachmentsConfig config = UnusedAttachmentsConfig.getInstance(this.pluginSettingsFactory);
        Set<String> extentIncludeSpaceKeys = UnusedAttachmentsUtil.getLabels(config.getExtentIncludeSpaceKeys());
        Set<String> extentIncludeSpaceLabels = UnusedAttachmentsUtil.getLabels(config.getExtentExcludeSpaceLabels());
        Set<String> extentExcludeSpaceKeys = UnusedAttachmentsUtil.getLabels(config.getExtentExcludeSpaceKeys());
        Set<String> extentExcludeSpaceLabels = UnusedAttachmentsUtil.getLabels(config.getExtentExcludeSpaceLabels());
        Set<String> filtersExcludeSpaceLabels = UnusedAttachmentsUtil.getLabels(config.getFiltersExcludeSpaceLabels());
        Set<String> filtersExcludePageLabels = UnusedAttachmentsUtil.getLabels(config.getFiltersExcludePageLabels());
        Set<String> filtersExcludeAttachmentLabels = UnusedAttachmentsUtil.getLabels(config.getFiltersExcludeAttachmentLabels());
        Predicate<Attachment> filtersExcludeAttachmentPatternsFilter = null;
        String filtersExcludePatterns = config.getFiltersExcludeAttachmentPatterns();
        if (filtersExcludePatterns != null && filtersExcludePatterns.trim().length() > 0) {
            filtersExcludeAttachmentPatternsFilter = DefaultUnusedAttachmentsManager.attachmentFilenameFilter(filtersExcludePatterns);
        }
        HashSet<Long> ignoredAttachmentsSpaces = new HashSet<Long>();
        HashMap<Long, Set<Long>> unusedAttachmentsMap = new HashMap<Long, Set<Long>>();
        HashSet<Long> attachmentsRefsSet = new HashSet<Long>();
        this.crtUnusedAttachmentsMap = unusedAttachmentsMap;
        try {
            boolean bl;
            ArrayList<FindTaskAttachmentXhtmlVisitor> visitors = new ArrayList<FindTaskAttachmentXhtmlVisitor>();
            visitors.add(new FindTaskAttachmentXhtmlVisitor(config, this.spaceManager, this.pageManager, this.attachmentManager, this.thumbnailManager, ignoredAttachmentsSpaces, unusedAttachmentsMap, attachmentsRefsSet));
            HashSet<String> includeSpaceKeys = null;
            if (extentIncludeSpaceKeys != null && extentIncludeSpaceKeys.size() > 0) {
                includeSpaceKeys = new HashSet<String>();
                includeSpaceKeys.addAll(extentIncludeSpaceKeys);
            }
            HashSet<String> includeSpaceLabelsSpaceKeys = null;
            if (extentIncludeSpaceLabels != null && extentIncludeSpaceLabels.size() > 0) {
                includeSpaceLabelsSpaceKeys = new HashSet<String>();
                for (String strLabel : extentIncludeSpaceLabels) {
                    Label label = this.labelManager.getLabel(strLabel, Namespace.TEAM);
                    if (label == null) continue;
                    List list = this.labelManager.getSpacesWithLabel(label);
                    for (Space space : list) {
                        includeSpaceLabelsSpaceKeys.add(space.getKey());
                    }
                }
            }
            if (includeSpaceKeys == null) {
                includeSpaceKeys = includeSpaceLabelsSpaceKeys;
            } else if (includeSpaceLabelsSpaceKeys != null) {
                includeSpaceKeys.retainAll(includeSpaceLabelsSpaceKeys);
            }
            HashSet<String> excludeSpaceKeys = null;
            if (extentExcludeSpaceKeys != null && extentExcludeSpaceKeys.size() > 0) {
                excludeSpaceKeys = new HashSet<String>();
                excludeSpaceKeys.addAll(extentExcludeSpaceKeys);
            }
            HashSet<String> excludeSpaceLabelsSpaceKeys = null;
            if (extentExcludeSpaceLabels != null && extentExcludeSpaceLabels.size() > 0) {
                excludeSpaceLabelsSpaceKeys = new HashSet<String>();
                for (String string : extentExcludeSpaceLabels) {
                    Label label = this.labelManager.getLabel(string, Namespace.TEAM);
                    if (label == null) continue;
                    List labelSpaces = this.labelManager.getSpacesWithLabel(label);
                    for (Space space : labelSpaces) {
                        excludeSpaceLabelsSpaceKeys.add(space.getKey());
                    }
                }
            }
            if (excludeSpaceKeys == null) {
                excludeSpaceKeys = excludeSpaceLabelsSpaceKeys;
            } else if (excludeSpaceLabelsSpaceKeys != null) {
                excludeSpaceKeys.addAll(excludeSpaceLabelsSpaceKeys);
            }
            if (includeSpaceKeys == null) {
                if (excludeSpaceKeys != null) {
                    includeSpaceKeys = new HashSet();
                    List spaces = this.spaceManager.getAllSpaces();
                    for (Space space2 : spaces) {
                        if (excludeSpaceKeys.contains(space2.getKey())) continue;
                        includeSpaceKeys.add(space2.getKey());
                    }
                }
            } else if (excludeSpaceKeys != null) {
                includeSpaceKeys.removeAll(excludeSpaceKeys);
            }
            if (config.isExtentIgnoreArchivedSpaces()) {
                HashSet<String> spaceKeys = new HashSet<String>();
                if (includeSpaceKeys == null) {
                    List list = this.spaceManager.getAllSpaces();
                    for (Space space : list) {
                        if (space.isArchived()) continue;
                        spaceKeys.add(space.getKey());
                    }
                } else {
                    for (String spaceKey : includeSpaceKeys) {
                        Space space;
                        space = this.spaceManager.getSpace(spaceKey);
                        if (space == null || space.isArchived()) continue;
                        spaceKeys.add(space.getKey());
                    }
                }
                includeSpaceKeys = spaceKeys;
            }
            SearchQuery contentTypeQuery = BooleanQuery.orQuery((SearchQuery[])new SearchQuery[]{new ContentTypeQuery(ContentTypeEnum.PAGE), new ContentTypeQuery(ContentTypeEnum.BLOG), new ContentTypeQuery(ContentTypeEnum.COMMENT)});
            boolean bl2 = true;
            SearchQuery query = null;
            if (includeSpaceKeys == null) {
                query = contentTypeQuery;
            } else if (includeSpaceKeys.size() > 0) {
                query = BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{new InSpaceQuery(includeSpaceKeys), contentTypeQuery});
            } else {
                boolean bl3 = false;
            }
            SearchSort sort = null;
            int startIndex = 0;
            while (bl) {
                ContentSearch search = new ContentSearch(query, sort, startIndex, SearchConstants.MAX_LIMIT);
                SearchResults searchResults = null;
                try {
                    searchResults = this.searchManager.search((ISearch)search);
                }
                catch (InvalidSearchException e) {
                    searchResults = EMPTY_RESULTS;
                }
                if (startIndex == 0) {
                    progress.setTotalObjects(searchResults.getUnfilteredResultsCount());
                    progress.setCurrentCount(0);
                    boolean lockAcquired = false;
                    try {
                        lockAcquired = TASK_STATUS_LOCK.tryLock(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (lockAcquired) {
                        try {
                            UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
                            taskStatus.update((LongRunningTask)task, progress);
                            this.setTaskStatus(taskStatus);
                        }
                        finally {
                            TASK_STATUS_LOCK.unlock();
                        }
                    }
                }
                bl = searchResults.getUnfilteredResultsCount() > startIndex + SearchConstants.MAX_LIMIT;
                startIndex += SearchConstants.MAX_LIMIT;
                List allSearchResults = searchResults.getAll();
                for (SearchResult searchResult : allSearchResults) {
                    long pageId;
                    ContentEntityObject contentEntity;
                    if (this.isCancelled((Space)null, null)) {
                        progress.setPercentage(100);
                        progress.setCompletedSuccessfully(false);
                        UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
                        taskStatus.update((LongRunningTask)task, progress);
                        this.setTaskStatus(taskStatus);
                        this.crtUnusedAttachmentsMap = null;
                        return;
                    }
                    Handle handle = searchResult.getHandle();
                    if (handle instanceof HibernateHandle && (contentEntity = this.contentEntityManager.getById(pageId = ((HibernateHandle)handle).getId())) != null) {
                        boolean ignoreSpaceAttachments;
                        Space space;
                        long spaceId;
                        if (log.isDebugEnabled()) {
                            log.debug("Processing content entity: " + pageId + " | " + contentEntity.getTitle() + " | " + contentEntity.getClass().getName());
                        }
                        if (!unusedAttachmentsMap.containsKey(spaceId = (space = contentEntity instanceof AbstractPage ? ((AbstractPage)contentEntity).getSpace() : (contentEntity instanceof Comment ? ((Comment)contentEntity).getSpace() : null)).getId())) {
                            unusedAttachmentsMap.put(spaceId, null);
                        }
                        if (!(ignoreSpaceAttachments = ignoredAttachmentsSpaces.contains(spaceId))) {
                            boolean bl4 = ignoreSpaceAttachments = config.isFiltersIgnoreArchivedSpaces() && space.getSpaceStatus() == SpaceStatus.ARCHIVED;
                            if (!ignoreSpaceAttachments) {
                                ignoreSpaceAttachments = DefaultUnusedAttachmentsManager.hasAnyOfTheLabels((Labelable)space.getDescription(), filtersExcludeSpaceLabels);
                            }
                        }
                        if (ignoreSpaceAttachments) {
                            ignoredAttachmentsSpaces.add(spaceId);
                        } else {
                            boolean ignoreEntityAttachments = DefaultUnusedAttachmentsManager.hasAnyOfTheLabels((Labelable)contentEntity, filtersExcludePageLabels);
                            if (!ignoreEntityAttachments) {
                                List attachments = contentEntity.getLatestVersionsOfAttachments();
                                if (filtersExcludeAttachmentPatternsFilter != null) {
                                    attachments = attachments.stream().filter(filtersExcludeAttachmentPatternsFilter).collect(Collectors.toList());
                                }
                                for (Attachment attachment : attachments) {
                                    boolean ignoreAttachment = DefaultUnusedAttachmentsManager.hasAnyOfTheLabels((Labelable)attachment, filtersExcludeAttachmentLabels);
                                    if (ignoreAttachment) continue;
                                    long attachmentId = attachment.getId();
                                    if (attachmentsRefsSet.contains(attachmentId)) {
                                        attachmentsRefsSet.remove(attachmentId);
                                        continue;
                                    }
                                    HashSet<Long> unusedAttachmentsSet = (HashSet<Long>)unusedAttachmentsMap.get(spaceId);
                                    if (unusedAttachmentsSet == null) {
                                        unusedAttachmentsSet = new HashSet<Long>();
                                        unusedAttachmentsMap.put(spaceId, unusedAttachmentsSet);
                                    }
                                    unusedAttachmentsSet.add(attachmentId);
                                }
                            }
                        }
                        do {
                            String content;
                            if (!AbstractAttachmentXhtmlVisitor.toProcessXhtml(content = contentEntity.getEntity().getBodyAsString())) continue;
                            this.xhtmlContent.handleXhtmlElements(content, (ConversionContext)new DefaultConversionContext((RenderContext)contentEntity.toPageContext()), visitors);
                        } while (!config.isIgnoreHistory() && (contentEntity.getTypeEnum() == ContentTypeEnum.PAGE || contentEntity.getTypeEnum() == ContentTypeEnum.BLOG) && (contentEntity = this.contentEntityManager.getPreviousVersion(contentEntity)) != null);
                    }
                    if (progress.getTotal() <= progress.getCurrentCount() + 1) continue;
                    progress.setCurrentCount(progress.getCurrentCount() + 1);
                    progress.setStatus(null);
                    UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
                    taskStatus.update((LongRunningTask)task, progress);
                    this.setTaskStatus(taskStatus);
                }
            }
            this.saveUnusedAttachmentsResult(task, progress, new FindUnusedAttachmentsTaskResult(unusedAttachmentsMap, System.currentTimeMillis()), true);
            progress.setPercentage(100);
            progress.setCompletedSuccessfully(true);
            UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
            taskStatus.update((LongRunningTask)task, progress);
            this.setTaskStatus(taskStatus);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Unused attachments search failed.", (Throwable)e);
            }
            progress.setPercentage(100);
            progress.setCompletedSuccessfully(false);
            UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
            taskStatus.update((LongRunningTask)task, progress);
            this.setTaskStatus(taskStatus);
        }
        this.crtUnusedAttachmentsMap = null;
        this.removeCancelFlag();
    }

    private static Set<String> getLabels(Labelable labelable) {
        List labels;
        HashSet<String> labelSet = null;
        if (labelable != null && (labels = labelable.getLabels()) != null && labels.size() > 0) {
            labelSet = new HashSet<String>();
            for (Label label : labels) {
                labelSet.add(label.getName());
            }
        }
        return labelSet;
    }

    private static boolean hasAnyOfTheLabels(Labelable labelable, Set<String> labels) {
        Set<String> labelSet;
        boolean hasAnyLabel = false;
        if (labels != null && labels.size() > 0 && (labelSet = DefaultUnusedAttachmentsManager.getLabels(labelable)) != null && labelSet.size() > 0) {
            labelSet.retainAll(labels);
            if (labelSet.size() > 0) {
                hasAnyLabel = true;
            }
        }
        return hasAnyLabel;
    }

    private static Predicate<Attachment> attachmentFilenameFilter(String fileNamePatterns) {
        if (fileNamePatterns != null) {
            List<Pattern> patterns = AbstractAttachmentXhtmlVisitor.compileFilenamePatterns(fileNamePatterns);
            return attachment -> !patterns.stream().anyMatch(pattern -> pattern.matcher(attachment.getFileName()).matches());
        }
        return x -> false;
    }

    @Override
    public void removeSpace(Space space) {
        FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(space.getId());
        if (result != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(space.getId())) {
            if (this.crtUnusedAttachmentsMap != null) {
                this.clearUnusedAttachments(space);
            }
            this.clearUnusedAttachments(space, result);
        }
    }

    private void clearUnusedAttachments(Space space) {
        this.crtUnusedAttachmentsMap.remove(space.getId());
    }

    private void clearUnusedAttachments(Space space, FindUnusedAttachmentsTaskResult result) {
        Map<Long, Set<Long>> unusedAttachmentsMap = result.getUnusedAttachments();
        unusedAttachmentsMap.remove(space.getId());
        this.saveUnusedAttachmentsResult(null, null, result, false);
        this.updateGlobalResult(result.getResultTime(), null, space.getId());
    }

    @Override
    public void updateSpace(Space space) {
        UnusedAttachmentsConfig config;
        FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(space.getId());
        if ((result != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(space.getId())) && (config = UnusedAttachmentsConfig.getInstance(this.pluginSettingsFactory)).isFiltersIgnoreArchivedSpaces() && space.getSpaceStatus() == SpaceStatus.ARCHIVED) {
            FindUnusedAttachmentsGlobalResult globalResult;
            if (this.crtUnusedAttachmentsMap != null) {
                this.clearUnusedAttachments(space);
            }
            if ((globalResult = this.getGlobalResult()) != null && globalResult.getResultTime() == result.getResultTime()) {
                this.clearUnusedAttachments(space, result);
            }
        }
    }

    @Override
    public void addSpaceLabel(Space space, String label) {
        UnusedAttachmentsConfig config;
        Set<String> filtersExcludeSpaceLabels;
        FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(space.getId());
        if ((result != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(space.getId())) && (filtersExcludeSpaceLabels = UnusedAttachmentsUtil.getLabels((config = UnusedAttachmentsConfig.getInstance(this.pluginSettingsFactory)).getFiltersExcludeSpaceLabels())) != null && filtersExcludeSpaceLabels.contains(label)) {
            FindUnusedAttachmentsGlobalResult globalResult;
            if (this.crtUnusedAttachmentsMap != null) {
                this.clearUnusedAttachments(space);
            }
            if ((globalResult = this.getGlobalResult()) != null && globalResult.getResultTime() == result.getResultTime()) {
                this.clearUnusedAttachments(space, result);
            }
        }
    }

    @Override
    public void removePage(AbstractPage page) {
        FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(page.getSpace().getId());
        if (result != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(page.getSpace().getId())) {
            HashSet<Long> pageAttachments = new HashSet<Long>();
            for (Attachment attachment : this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page)) {
                pageAttachments.add(attachment.getId());
            }
            if (this.crtUnusedAttachmentsMap != null) {
                this.clearUnusedAttachments(page.getSpace().getId(), pageAttachments);
            }
            this.clearUnusedAttachments(page.getSpace().getId(), pageAttachments, result);
        }
    }

    private void clearUnusedAttachments(Long spaceId, Set<Long> pageAttachments) {
        Set<Long> unusedAttachmentsSet;
        Set<Long> set = unusedAttachmentsSet = this.crtUnusedAttachmentsMap == null ? null : this.crtUnusedAttachmentsMap.get(spaceId);
        if (unusedAttachmentsSet != null) {
            unusedAttachmentsSet.removeAll(pageAttachments);
        }
    }

    private void clearUnusedAttachments(Long spaceId, Set<Long> pageAttachments, FindUnusedAttachmentsTaskResult result) {
        Map<Long, Set<Long>> unusedAttachmentsMap = result.getUnusedAttachments();
        Set<Long> unusedAttachmentsSet = unusedAttachmentsMap.get(spaceId);
        if (unusedAttachmentsSet != null) {
            unusedAttachmentsSet.removeAll(pageAttachments);
            this.saveUnusedAttachmentsResult(null, null, result, false);
            if (unusedAttachmentsSet.size() == 0) {
                this.updateGlobalResult(result.getResultTime(), null, spaceId);
            }
        }
    }

    @Override
    public void movePage(AbstractPage page, Long oldSpaceId) {
        FindUnusedAttachmentsTaskResult oldSpaceResult = this.loadUnusedAttachmentsResult(oldSpaceId);
        if (oldSpaceResult != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(oldSpaceId)) {
            Map<Long, Set<Long>> oldUnusedAttachmentsMap;
            Set<Long> oldSpaceUnusedAttachmentsSet;
            HashSet<Long> pageAttachments = new HashSet<Long>();
            for (Attachment attachment : this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page)) {
                pageAttachments.add(attachment.getId());
            }
            Set<Long> set = oldSpaceUnusedAttachmentsSet = this.crtUnusedAttachmentsMap == null ? null : this.crtUnusedAttachmentsMap.get(oldSpaceId);
            if (oldSpaceUnusedAttachmentsSet != null) {
                HashSet pageUnusedAttachments = new HashSet(pageAttachments);
                pageUnusedAttachments.retainAll(oldSpaceUnusedAttachmentsSet);
                if (pageUnusedAttachments.size() > 0) {
                    Long newSpaceId = page.getSpace().getId();
                    Set<Long> newSpaceUnusedAttachmentsSet = this.crtUnusedAttachmentsMap.get(newSpaceId);
                    if (newSpaceUnusedAttachmentsSet == null) {
                        newSpaceUnusedAttachmentsSet = new HashSet<Long>();
                        this.crtUnusedAttachmentsMap.put(newSpaceId, newSpaceUnusedAttachmentsSet);
                    }
                    newSpaceUnusedAttachmentsSet.addAll(pageUnusedAttachments);
                    oldSpaceUnusedAttachmentsSet.removeAll(pageUnusedAttachments);
                }
            }
            if ((oldSpaceUnusedAttachmentsSet = (oldUnusedAttachmentsMap = oldSpaceResult.getUnusedAttachments()).get(oldSpaceId)) != null) {
                HashSet pageUnusedAttachments = new HashSet(pageAttachments);
                pageUnusedAttachments.retainAll(oldSpaceUnusedAttachmentsSet);
                if (pageUnusedAttachments.size() > 0) {
                    Long globalSpaceIdToAdd = null;
                    Long globalSpaceIdToRemove = null;
                    Long newSpaceId = page.getSpace().getId();
                    FindUnusedAttachmentsTaskResult newSpaceResult = this.loadUnusedAttachmentsResult(newSpaceId);
                    if (newSpaceResult != null && newSpaceResult.getResultTime() == oldSpaceResult.getResultTime()) {
                        Map<Long, Set<Long>> newUnusedAttachmentsMap = newSpaceResult.getUnusedAttachments();
                        Set<Long> newSpaceUnusedAttachmentsSet = newUnusedAttachmentsMap.get(newSpaceId);
                        if (newSpaceUnusedAttachmentsSet == null) {
                            newSpaceUnusedAttachmentsSet = new HashSet<Long>();
                            newUnusedAttachmentsMap.put(newSpaceId, newSpaceUnusedAttachmentsSet);
                        }
                        if (newSpaceUnusedAttachmentsSet.size() == 0) {
                            globalSpaceIdToAdd = newSpaceId;
                        }
                        newSpaceUnusedAttachmentsSet.addAll(pageUnusedAttachments);
                        this.saveUnusedAttachmentsResult(null, null, newSpaceResult, false);
                    }
                    oldSpaceUnusedAttachmentsSet.removeAll(pageUnusedAttachments);
                    this.saveUnusedAttachmentsResult(null, null, oldSpaceResult, false);
                    if (oldSpaceUnusedAttachmentsSet.size() == 0) {
                        globalSpaceIdToRemove = oldSpaceId;
                    }
                    this.updateGlobalResult(oldSpaceResult.getResultTime(), globalSpaceIdToAdd, globalSpaceIdToRemove);
                }
            }
        }
    }

    private synchronized void updateGlobalResult(long resultTime, Long globalSpaceIdToAdd, Long globalSpaceIdToRemove) {
        FindUnusedAttachmentsGlobalResult globalResult;
        if ((globalSpaceIdToAdd != null || globalSpaceIdToRemove != null) && (globalResult = this.getGlobalResult()) != null && globalResult.getResultTime() == resultTime) {
            HashSet<Long> globalSpaceIds;
            HashSet<Long> hashSet = globalSpaceIds = globalResult.getUnusedAttachmentsSpaces() == null ? null : new HashSet<Long>(Arrays.asList(globalResult.getUnusedAttachmentsSpaces()));
            if (globalSpaceIdToRemove != null && globalSpaceIds != null && globalSpaceIds.size() > 0) {
                globalSpaceIds.remove(globalSpaceIdToRemove);
            }
            if (globalSpaceIdToAdd != null) {
                if (globalSpaceIds == null) {
                    globalSpaceIds = new HashSet();
                }
                globalSpaceIds.add(globalSpaceIdToAdd);
            }
            if (globalSpaceIds != null) {
                globalResult = new FindUnusedAttachmentsGlobalResult(globalSpaceIds == null ? null : globalSpaceIds.toArray(new Long[globalSpaceIds.size()]), globalResult.getResultTime());
                this.setGlobalResult(globalResult);
            }
        }
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        if (this.crtUnusedAttachmentsMap != null) {
            this.clearUnusedAttachment(attachment);
        }
        if (this.skipRemoveEventAttachments.contains(attachment.getId())) {
            this.skipRemoveEventAttachments.remove(attachment.getId());
        } else {
            FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(attachment.getSpace().getId());
            if (result != null) {
                this.clearUnusedAttachment(attachment, result);
            }
        }
    }

    private void clearUnusedAttachment(Attachment attachment) {
        Set<Long> unusedAttachmentsSet = this.crtUnusedAttachmentsMap.get(attachment.getSpace().getId());
        if (unusedAttachmentsSet != null) {
            unusedAttachmentsSet.remove(attachment.getId());
        }
    }

    private void clearUnusedAttachment(Attachment attachment, FindUnusedAttachmentsTaskResult result) {
        Map<Long, Set<Long>> unusedAttachmentsMap = result.getUnusedAttachments();
        Set<Long> unusedAttachmentsSet = unusedAttachmentsMap.get(attachment.getSpace().getId());
        if (unusedAttachmentsSet != null) {
            unusedAttachmentsSet.remove(attachment.getId());
            this.saveUnusedAttachmentsResult(null, null, result, false);
            if (unusedAttachmentsSet.size() == 0) {
                this.updateGlobalResult(result.getResultTime(), null, attachment.getSpace().getId());
            }
        }
    }

    @Override
    public void moveAttachment(Attachment attachment, Long oldSpaceId, Long newSpaceId) {
        FindUnusedAttachmentsTaskResult oldSpaceResult = this.loadUnusedAttachmentsResult(oldSpaceId);
        if (oldSpaceResult != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(oldSpaceId)) {
            Map<Long, Set<Long>> oldUnusedAttachmentsMap;
            Long attachmentId = attachment.getId();
            Set<Long> oldSpaceUnusedAttachmentsSet = this.crtUnusedAttachmentsMap.get(oldSpaceId);
            if (oldSpaceUnusedAttachmentsSet != null && oldSpaceUnusedAttachmentsSet.contains(attachmentId)) {
                Set<Long> newSpaceUnusedAttachmentsSet = this.crtUnusedAttachmentsMap.get(newSpaceId);
                if (newSpaceUnusedAttachmentsSet == null) {
                    newSpaceUnusedAttachmentsSet = new HashSet<Long>();
                    this.crtUnusedAttachmentsMap.put(newSpaceId, newSpaceUnusedAttachmentsSet);
                }
                newSpaceUnusedAttachmentsSet.add(attachmentId);
                oldSpaceUnusedAttachmentsSet.remove(attachmentId);
            }
            if ((oldSpaceUnusedAttachmentsSet = (oldUnusedAttachmentsMap = oldSpaceResult.getUnusedAttachments()).get(oldSpaceId)) != null && oldSpaceUnusedAttachmentsSet.contains(attachmentId)) {
                Long globalSpaceIdToAdd = null;
                Long globalSpaceIdToRemove = null;
                FindUnusedAttachmentsTaskResult newSpaceResult = this.loadUnusedAttachmentsResult(newSpaceId);
                if (newSpaceResult != null && newSpaceResult.getResultTime() == oldSpaceResult.getResultTime()) {
                    Map<Long, Set<Long>> newUnusedAttachmentsMap = newSpaceResult.getUnusedAttachments();
                    Set<Long> newSpaceUnusedAttachmentsSet = newUnusedAttachmentsMap.get(newSpaceId);
                    if (newSpaceUnusedAttachmentsSet == null) {
                        newSpaceUnusedAttachmentsSet = new HashSet<Long>();
                        newUnusedAttachmentsMap.put(newSpaceId, newSpaceUnusedAttachmentsSet);
                    }
                    if (newSpaceUnusedAttachmentsSet.size() == 0) {
                        globalSpaceIdToAdd = newSpaceId;
                    }
                    newSpaceUnusedAttachmentsSet.add(attachmentId);
                    this.saveUnusedAttachmentsResult(null, null, newSpaceResult, false);
                }
                oldSpaceUnusedAttachmentsSet.remove(attachmentId);
                this.saveUnusedAttachmentsResult(null, null, oldSpaceResult, false);
                if (oldSpaceUnusedAttachmentsSet.size() == 0) {
                    globalSpaceIdToRemove = oldSpaceId;
                }
                this.updateGlobalResult(oldSpaceResult.getResultTime(), globalSpaceIdToAdd, globalSpaceIdToRemove);
            }
        }
    }

    @Override
    public void renameAttachment(Attachment attachment, String newFileName) {
        FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(attachment.getSpace().getId());
        if (result != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(attachment.getSpace().getId())) {
            UnusedAttachmentsConfig config = UnusedAttachmentsConfig.getInstance(this.pluginSettingsFactory);
            Predicate<Attachment> filtersExcludeAttachmentPatternsFilter = null;
            String filtersExcludePatterns = config.getFiltersExcludeAttachmentPatterns();
            if (filtersExcludePatterns != null && filtersExcludePatterns.trim().length() > 0 && (filtersExcludeAttachmentPatternsFilter = DefaultUnusedAttachmentsManager.attachmentFilenameFilter(filtersExcludePatterns)).test(attachment)) {
                FindUnusedAttachmentsGlobalResult globalResult;
                Set<Long> unusedAttachmentsSet;
                if (this.crtUnusedAttachmentsMap != null && (unusedAttachmentsSet = this.crtUnusedAttachmentsMap.get(attachment.getSpace().getId())) != null) {
                    unusedAttachmentsSet.remove(attachment.getId());
                }
                if ((globalResult = this.getGlobalResult()) != null && globalResult.getResultTime() == result.getResultTime()) {
                    this.clearUnusedAttachment(attachment, result);
                }
            }
        }
    }

    @Override
    public void cancelFindUnusedAttachments() {
        UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus();
        if (taskStatus != null && !taskStatus.isComplete()) {
            this.setCancelFlag();
        }
    }

    @Override
    public LongTaskResponse createDeleteTask(User user, boolean notifyWatchers, UnusedAttachmentsFormData formData, String spaceKey, Long pageId) {
        LongTaskResponse response = new LongTaskResponse();
        UnusedAttachmentsStatus status = this.getStatus(spaceKey, pageId);
        if (status != null && status.inProgress) {
            response.accepted = false;
        } else {
            Set<Long> filteredAndSortedAttachmentIds;
            response.accepted = true;
            FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(formData.getSpaceKey());
            if (result != null && (filteredAndSortedAttachmentIds = this.getFilteredAndSortedAttachmentIds(formData)) != null) {
                Map<Long, Set<Long>> unusedAttachmentsMap = result.getUnusedAttachments();
                if (pageId == null) {
                    if (unusedAttachmentsMap != null) {
                        for (Set<Long> unusedAttachmentsSet : unusedAttachmentsMap.values()) {
                            if (unusedAttachmentsSet == null) continue;
                            unusedAttachmentsSet.retainAll(filteredAndSortedAttachmentIds);
                        }
                    }
                } else {
                    Long spaceId;
                    ContentEntityObject contentEntity = this.pageManager.getById(pageId.longValue());
                    AbstractPage page = contentEntity instanceof AbstractPage ? (AbstractPage)contentEntity : null;
                    Long l = spaceId = page == null ? null : Long.valueOf(page.getSpace().getId());
                    if (spaceId != null && unusedAttachmentsMap.containsKey(spaceId)) {
                        Set<Long> unusedAttachmentsSet = unusedAttachmentsMap.get(spaceId);
                        unusedAttachmentsSet.retainAll(filteredAndSortedAttachmentIds);
                        HashSet<Long> unusedAttachmentsToRemove = new HashSet<Long>();
                        for (Long attachmentId : unusedAttachmentsSet) {
                            Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
                            if (attachment == null || attachment.getContainer().getId() != page.getId()) continue;
                            unusedAttachmentsToRemove.add(attachmentId);
                        }
                        unusedAttachmentsMap = new HashMap<Long, Set<Long>>();
                        unusedAttachmentsMap.put(spaceId, unusedAttachmentsToRemove);
                    } else {
                        unusedAttachmentsMap = null;
                    }
                }
                response.accepted = this.deleteUnusedAttachments(user, notifyWatchers, unusedAttachmentsMap, spaceKey, pageId);
            }
        }
        return response;
    }

    @Override
    public LongTaskResponse createDeleteTask(User user, boolean notifyWatchers, Collection<Long> attachments, String spaceKey, Long pageId) {
        LongTaskResponse response = new LongTaskResponse();
        UnusedAttachmentsStatus status = this.getStatus(spaceKey, pageId);
        if (status != null && status.inProgress) {
            response.accepted = false;
        } else {
            HashMap<Long, Set<Long>> unusedAttachmentsMap = null;
            if (attachments != null) {
                unusedAttachmentsMap = new HashMap<Long, Set<Long>>();
                for (Long attachmentId : attachments) {
                    Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
                    if (attachment == null) continue;
                    Long spaceId = attachment.getSpace().getId();
                    HashSet<Long> unusedAttachmentsSet = (HashSet<Long>)unusedAttachmentsMap.get(spaceId);
                    if (unusedAttachmentsSet == null) {
                        unusedAttachmentsSet = new HashSet<Long>();
                        unusedAttachmentsMap.put(spaceId, unusedAttachmentsSet);
                    }
                    unusedAttachmentsSet.add(attachmentId);
                }
            }
            response.accepted = this.deleteUnusedAttachments(user, notifyWatchers, unusedAttachmentsMap, spaceKey, pageId);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteUnusedAttachments(User user, final boolean notifyWatchers, final Map<Long, Set<Long>> unusedAttachmentsMap, String spaceKey, final Long pageId) {
        UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus(spaceKey, pageId);
        Object task = null;
        if (taskStatus != null && (task = this.getLongRunningTask(taskStatus.getUser(), taskStatus.getTaskId())) != null) {
            this.taskManager.stopTrackingLongRunningTask(LongRunningTaskId.valueOf((String)taskStatus.getTaskId()));
        }
        final Space space = spaceKey == null ? null : this.spaceManager.getSpace(spaceKey);
        boolean lockAcquired = false;
        try {
            lockAcquired = TASK_STATUS_LOCK.tryLock(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (lockAcquired) {
            try {
                taskStatus = new UnusedAttachmentsLongRunningTaskStatus(user.getName());
                task = new ConfluenceAbstractLongRunningTask(){

                    public String getName() {
                        return "Confluentis Unused Attachments Delete Task";
                    }

                    protected void runInternal() {
                        DefaultUnusedAttachmentsManager.this.deleteUnusedAttachments(this, this.progress, notifyWatchers, unusedAttachmentsMap, space, pageId);
                    }
                };
                taskStatus.setTaskId(this.taskManager.startLongRunningTask(user, task).toString());
                taskStatus.setDeleteTask(true);
                this.removeCancelFlag(space, pageId);
                this.setDeleteTaskStatus(space, pageId, taskStatus);
            }
            finally {
                TASK_STATUS_LOCK.unlock();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnusedAttachments(ConfluenceAbstractLongRunningTask task, ProgressMeter progress, boolean notifyWatchers, Map<Long, Set<Long>> unusedAttachmentsMap, Space space, Long pageId) {
        if (unusedAttachmentsMap != null) {
            try {
                Object taskStatus;
                int total = 0;
                for (Set<Long> unusedAttachmentsSet : unusedAttachmentsMap.values()) {
                    total += unusedAttachmentsSet == null ? 0 : unusedAttachmentsSet.size();
                }
                progress.setTotalObjects(total);
                progress.setCurrentCount(0);
                boolean lockAcquired = false;
                try {
                    lockAcquired = TASK_STATUS_LOCK.tryLock(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException unusedAttachmentsSet) {
                    // empty catch block
                }
                if (lockAcquired) {
                    try {
                        taskStatus = this.getDeleteTaskStatus(space, pageId);
                        ((UnusedAttachmentsLongRunningTaskStatus)taskStatus).update((LongRunningTask)task, progress);
                        this.setDeleteTaskStatus(space, pageId, (UnusedAttachmentsLongRunningTaskStatus)taskStatus);
                    }
                    finally {
                        TASK_STATUS_LOCK.unlock();
                    }
                }
                for (Long uaSpaceId : unusedAttachmentsMap.keySet()) {
                    Set<Long> attachmentIds;
                    if (space != null && space.getId() != uaSpaceId.longValue() || (attachmentIds = unusedAttachmentsMap.get(uaSpaceId)) == null) continue;
                    Space uaSpace = this.spaceManager.getSpace(uaSpaceId.longValue());
                    FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(uaSpace.getKey());
                    Set<Long> unusedAttachmentsSet = result == null ? null : result.getUnusedAttachments().get(uaSpaceId);
                    for (Long attachmentId : attachmentIds) {
                        if (this.isCancelled(space, pageId)) {
                            progress.setPercentage(100);
                            progress.setCompletedSuccessfully(false);
                            UnusedAttachmentsLongRunningTaskStatus taskStatus2 = this.getDeleteTaskStatus(space, pageId);
                            taskStatus2.update((LongRunningTask)task, progress);
                            this.setDeleteTaskStatus(space, pageId, taskStatus2);
                            break;
                        }
                        Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
                        if (attachment != null && (space == null || space.getId() == attachment.getSpace().getId())) {
                            this.skipRemoveEventAttachments.add(attachmentId);
                            if (unusedAttachmentsSet != null) {
                                unusedAttachmentsSet.remove(attachmentId);
                            }
                            if (notifyWatchers) {
                                this.attachmentManager.trash(attachment);
                            } else {
                                this.trash(attachment);
                            }
                        }
                        if (progress.getTotal() <= progress.getCurrentCount() + 1) continue;
                        progress.setCurrentCount(progress.getCurrentCount() + 1);
                        progress.setStatus(null);
                        UnusedAttachmentsLongRunningTaskStatus taskStatus3 = this.getDeleteTaskStatus(space, pageId);
                        taskStatus3.update((LongRunningTask)task, progress);
                        this.setDeleteTaskStatus(space, pageId, taskStatus3);
                    }
                    if (result == null) continue;
                    this.saveUnusedAttachmentsResult(null, null, result, false);
                    if (unusedAttachmentsSet != null && unusedAttachmentsSet.size() != 0) continue;
                    this.updateGlobalResult(result.getResultTime(), null, uaSpaceId);
                }
                progress.setPercentage(100);
                taskStatus = this.getDeleteTaskStatus(space, pageId);
                ((UnusedAttachmentsLongRunningTaskStatus)taskStatus).update((LongRunningTask)task, progress);
                this.setDeleteTaskStatus(space, pageId, (UnusedAttachmentsLongRunningTaskStatus)taskStatus);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Unused attachments deletion failed.", (Throwable)e);
                }
                progress.setPercentage(100);
                progress.setCompletedSuccessfully(false);
                UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getDeleteTaskStatus(space, pageId);
                taskStatus.update((LongRunningTask)task, progress);
                this.setDeleteTaskStatus(space, pageId, taskStatus);
            }
        }
        this.removeCancelFlag(space, pageId);
    }

    public void trash(Attachment attachment) {
        attachment.trash();
        this.attachmentManager.getAllVersions(attachment).forEach(arg_0 -> ((ConfluenceIndexer)this.indexer).unIndexIncludingDependents(arg_0));
        this.eventManager.publish((Object)new AttachmentTrashedEvent((Object)this, attachment, AuthenticatedUserThreadLocal.get(), true));
    }

    @Override
    public void cancelDeleteAttachments(String spaceKey, Long pageId) {
        UnusedAttachmentsLongRunningTaskStatus taskStatus = this.getTaskStatus(spaceKey, pageId);
        if (taskStatus != null && !taskStatus.isComplete()) {
            this.setCancelFlag(spaceKey, pageId);
        }
    }

    @Override
    public Set<Long> getFilteredAndSortedAttachmentIds(UnusedAttachmentsFormData formData) {
        LinkedHashSet<Long> filteredAndSortedAttachmentIds;
        block18: {
            filteredAndSortedAttachmentIds = null;
            FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(formData.getSpaceKey());
            if (result != null) {
                filteredAndSortedAttachmentIds = new LinkedHashSet<Long>();
                HashSet<String> filterSpaces = new HashSet<String>();
                if (formData.getSpaceKey() == null || formData.getSpaceKey().trim().length() == 0) {
                    for (Long spaceId : result.getUnusedAttachments().keySet()) {
                        Set<Long> unusedAttachmentsSet;
                        Space space = this.spaceManager.getSpace(spaceId.longValue());
                        if (space == null || (unusedAttachmentsSet = result.getUnusedAttachments().get(space.getId())) == null || unusedAttachmentsSet.size() <= 0) continue;
                        filterSpaces.add(space.getKey());
                    }
                } else {
                    Set<Long> unusedAttachmentsSet;
                    Space selectedSpace = this.spaceManager.getSpace(formData.getSpaceKey());
                    if (selectedSpace != null && (unusedAttachmentsSet = result.getUnusedAttachments().get(selectedSpace.getId())) != null && unusedAttachmentsSet.size() > 0) {
                        filterSpaces.add(selectedSpace.getKey());
                    }
                }
                if (filterSpaces.size() > 0) {
                    try {
                        SearchQuery baseQuery;
                        SearchQuery query = baseQuery = BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{new ContentTypeQuery(ContentTypeEnum.ATTACHMENT), new InSpaceQuery(filterSpaces)});
                        if (formData.getFilterText() != null && formData.getFilterText().trim().length() > 0) {
                            query = BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{query, new MultiTextFieldQuery(formData.getFilterText() + " OR " + formData.getFilterText() + "*", new HashSet<String>(Arrays.asList("filename", "title", "comment")), BooleanOperator.OR)});
                        }
                        FilenameSort sort = null;
                        if ("filename".equals(formData.getSortBy())) {
                            sort = "desc".equals(formData.getSortOrder()) ? FilenameSort.DESCENDING : FilenameSort.ASCENDING;
                        } else if ("filesize".equals(formData.getSortBy())) {
                            sort = "asc".equals(formData.getSortOrder()) ? FilesizeSort.ASCENDING : FilesizeSort.DESCENDING;
                        } else if ("creationdate".equals(formData.getSortBy())) {
                            sort = "desc".equals(formData.getSortOrder()) ? CreatedSort.DESCENDING : CreatedSort.ASCENDING;
                        }
                        int startIndex = 0;
                        boolean hasMore = true;
                        while (hasMore) {
                            ContentSearch search = new ContentSearch(query, (SearchSort)sort, startIndex, SearchConstants.MAX_LIMIT);
                            SearchResults searchResults = null;
                            try {
                                searchResults = this.searchManager.search((ISearch)search);
                            }
                            catch (InvalidSearchException e) {
                                searchResults = EMPTY_RESULTS;
                            }
                            hasMore = searchResults.getUnfilteredResultsCount() > startIndex + SearchConstants.MAX_LIMIT;
                            startIndex += SearchConstants.MAX_LIMIT;
                            List allSearchResults = searchResults.getAll();
                            for (SearchResult searchResult : allSearchResults) {
                                Handle handle = searchResult.getHandle();
                                if (!(handle instanceof HibernateHandle)) continue;
                                long attachmentId = ((HibernateHandle)handle).getId();
                                filteredAndSortedAttachmentIds.add(attachmentId);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block18;
                        log.error("Attachments search failed.", (Throwable)e);
                    }
                }
            }
        }
        return filteredAndSortedAttachmentIds;
    }

    private LongRunningTask getLongRunningTask(String userName, String taskId) {
        if (userName == null || taskId == null) {
            return null;
        }
        User user = null;
        try {
            user = this.userManager.getUser(userName);
        }
        catch (EntityException entityException) {
            // empty catch block
        }
        return this.taskManager.getLongRunningTask(user, LongRunningTaskId.valueOf((String)taskId));
    }

    private UnusedAttachmentsLongRunningTaskStatus getTaskStatus(String spaceKey, Long pageId) {
        UnusedAttachmentsLongRunningTaskStatus taskStatus = null;
        if (pageId == null) {
            if (spaceKey == null) {
                taskStatus = this.getTaskStatus();
            } else {
                Space space = this.spaceManager.getSpace(spaceKey);
                taskStatus = this.getDeleteTaskStatus(space);
            }
        } else {
            taskStatus = this.getDeleteTaskStatus(pageId);
        }
        return taskStatus;
    }

    private boolean isCancelled(String spaceKey, Long pageId) {
        Long cancelFlag = null;
        if (pageId == null) {
            if (spaceKey == null) {
                cancelFlag = this.getCancelFlag();
            } else {
                Space space = this.spaceManager.getSpace(spaceKey);
                cancelFlag = this.getCancelFlag(space);
            }
        } else {
            cancelFlag = this.getCancelFlag(pageId);
        }
        return this.isCancelled(cancelFlag);
    }

    private boolean isCancelled(Space space, Long pageId) {
        Long cancelFlag = null;
        cancelFlag = pageId == null ? (space == null ? this.getCancelFlag() : this.getCancelFlag(space)) : this.getCancelFlag(pageId);
        return this.isCancelled(cancelFlag);
    }

    private boolean isCancelled(Long cancelFlag) {
        boolean isCancelled = false;
        if (cancelFlag != null) {
            isCancelled = true;
        }
        return isCancelled;
    }

    private UnusedAttachmentsLongRunningTaskStatus getDeleteTaskStatus(Space space, Long pageId) {
        UnusedAttachmentsLongRunningTaskStatus deleteTaskStatus = null;
        deleteTaskStatus = pageId == null ? (space == null ? this.getTaskStatus() : this.getDeleteTaskStatus(space)) : this.getDeleteTaskStatus(pageId);
        return deleteTaskStatus;
    }

    @Override
    public void processContent(ContentEntityObject contentEntity) {
        HashMap<Long, Set<Long>> attachmentsRefsMap;
        block9: {
            UnusedAttachmentsConfig config = UnusedAttachmentsConfig.getInstance(this.pluginSettingsFactory);
            attachmentsRefsMap = new HashMap<Long, Set<Long>>();
            ArrayList<ContentEventAttachmentXhtmlVisitor> visitors = new ArrayList<ContentEventAttachmentXhtmlVisitor>();
            visitors.add(new ContentEventAttachmentXhtmlVisitor(config, this.spaceManager, this.pageManager, this.attachmentManager, this.thumbnailManager, attachmentsRefsMap));
            try {
                do {
                    String content = contentEntity.getEntity().getBodyAsString();
                    this.xhtmlContent.handleXhtmlElements(content, (ConversionContext)new DefaultConversionContext((RenderContext)contentEntity.toPageContext()), visitors);
                } while (!config.isIgnoreHistory() && (contentEntity.getTypeEnum() == ContentTypeEnum.PAGE || contentEntity.getTypeEnum() == ContentTypeEnum.BLOG) && (contentEntity = this.pageManager.getPreviousVersion(contentEntity)) != null);
            }
            catch (XhtmlException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error("Attachment reference lookup in content entity body failed.", (Throwable)e);
            }
        }
        for (Long spaceId : attachmentsRefsMap.keySet()) {
            Map<Long, Set<Long>> unusedAttachmentsMap;
            Set<Long> unusedAttachmentsSet;
            FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(spaceId);
            if (result == null && (this.crtUnusedAttachmentsMap == null || !this.crtUnusedAttachmentsMap.containsKey(spaceId))) continue;
            Set attachmentsRefsSet = (Set)attachmentsRefsMap.get(spaceId);
            Set<Long> set = unusedAttachmentsSet = this.crtUnusedAttachmentsMap == null ? null : this.crtUnusedAttachmentsMap.get(spaceId);
            if (unusedAttachmentsSet != null) {
                if (attachmentsRefsSet.contains(-1L)) {
                    this.crtUnusedAttachmentsMap.remove(spaceId);
                } else {
                    unusedAttachmentsSet.removeAll(attachmentsRefsSet);
                }
            }
            if ((unusedAttachmentsSet = (unusedAttachmentsMap = result.getUnusedAttachments()).get(spaceId)) == null) continue;
            if (attachmentsRefsSet.contains(-1L)) {
                unusedAttachmentsMap.put(spaceId, null);
            } else {
                unusedAttachmentsSet.removeAll(attachmentsRefsSet);
            }
            this.saveUnusedAttachmentsResult(null, null, result, false);
            if (unusedAttachmentsSet.size() != 0) continue;
            this.updateGlobalResult(result.getResultTime(), null, spaceId);
        }
    }

    @Override
    public void addPageLabel(AbstractPage page, String label) {
        UnusedAttachmentsConfig config;
        Set<String> filtersExcludePageLabels;
        FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(page.getSpace().getId());
        if ((result != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(page.getSpace().getId())) && (filtersExcludePageLabels = UnusedAttachmentsUtil.getLabels((config = UnusedAttachmentsConfig.getInstance(this.pluginSettingsFactory)).getFiltersExcludePageLabels())) != null && filtersExcludePageLabels.contains(label)) {
            FindUnusedAttachmentsGlobalResult globalResult;
            HashSet<Long> pageAttachments = new HashSet<Long>();
            for (Attachment attachment : this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page)) {
                pageAttachments.add(attachment.getId());
            }
            if (this.crtUnusedAttachmentsMap != null) {
                this.clearUnusedAttachments(page.getSpace().getId(), pageAttachments);
            }
            if ((globalResult = this.getGlobalResult()) != null && globalResult.getResultTime() == result.getResultTime()) {
                this.clearUnusedAttachments(page.getSpace().getId(), pageAttachments, result);
            }
        }
    }

    @Override
    public void addAttachmentLabel(Attachment attachment, String label) {
        UnusedAttachmentsConfig config;
        Set<String> filtersExcludeAttachmentLabels;
        FindUnusedAttachmentsTaskResult result = this.loadUnusedAttachmentsResult(attachment.getSpace().getId());
        if ((result != null || this.crtUnusedAttachmentsMap != null && this.crtUnusedAttachmentsMap.containsKey(attachment.getSpace().getId())) && (filtersExcludeAttachmentLabels = UnusedAttachmentsUtil.getLabels((config = UnusedAttachmentsConfig.getInstance(this.pluginSettingsFactory)).getFiltersExcludeAttachmentLabels())) != null && filtersExcludeAttachmentLabels.contains(label)) {
            FindUnusedAttachmentsGlobalResult globalResult;
            if (this.crtUnusedAttachmentsMap != null) {
                this.clearUnusedAttachment(attachment);
            }
            if ((globalResult = this.getGlobalResult()) != null && globalResult.getResultTime() == result.getResultTime()) {
                this.clearUnusedAttachment(attachment, result);
            }
        }
    }
}

