AJS.toInit(function ($) {

	var uaProgressContainer = $("#ua-progress-container"),
			uaPanelContents = $("#ua-panel-contents"),
			uaSuccessMessageContainer = $("#ua-success-message-container"),
			uaSuccessMessage = $("#ua-success-message"),
			uaErrorMessageContainer = $("#ua-error-message-container"),
			uaErrorMessage = $("#ua-error-message"),
			uaProgressBar = $("#ua-progress-bar"),
			uaInProgress = $("#ua-in-progress").length > 0,
			uaButtonFind = $("#ua-button-find"),
			uaButtonRefresh = $("#ua-button-refresh"),
			uaButtonCancel = $("#ua-button-cancel"),
			uaButtonDeleteCancel = $("#ua-button-delete-cancel"),
			uaButtonBack = $("#ua-button-back"),
			uaDeleteAllLink = $("#ua-delete-all"),
			uaDeleteAllConfirm = $("#ua-delete-all-confirm"),
			uaCheckNotify = $("#ua-check-notify"),
			uaDeleteSelectedConfirm = $("#ua-delete-selected-confirm"),
			uaDeleteCancel = $("#ua-delete-cancel"),
			uaSelectAll = $(".ua-select-all"),
			uaSelectAllCheck = $("#ua-select-all-check"),
			uaSelect = $(".ua-select"),
			uaDeleteSelectedLabel = $("#ua-delete-selected-label"),
			uaDeleteSelectedLink = $("#ua-delete-selected-link"),
			uaDeleteSelected = $(".ua-delete-selected"),
			uaFilter = $("#ua-filter"),
			uaSpace = $("#ua-space"),
			uaListForm = $("#ua-list-form"),
			uaRowsPerPage = $("#ua-rows-per-page"),
			uaRowsPerPageForm = $("#ua-rows-per-page-form"),
			uaElapsedTime = $("#ua-elapsed-time"),
			//uaElapsedTimeContainer = $("#ua-elapsed-time-container"),
			uaNoLicenseLink = $(".noLicenseLink"),
			uaNoDeleteLink = $(".noDeleteLink"),
			uaStatus = $("#ua-status"),
			uaPercentage = $("#ua-percentage"),
			uaAge = $("#ua-age"),
			uaList = $("#ua-list"),
			oldFilterText = $.trim(uaFilter.val()),
			filterTimer;

	function updateProgressBar(percentage) 
	{
		uaProgressBar[0].value = percentage;
	}

	uaButtonFind.click(function	()
	{
		findUnusedAttachments();

		return false;
	});

	uaButtonRefresh.click(function	()
	{
		findUnusedAttachments();

		return false;
	});

	function findUnusedAttachments() 
	{
		AJS.safe.ajax({
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/findunusedattachments",
			type: "PUT",
			contentType: "application/json",
			dataType: "json",
			data: {}, // must declare this to use AJS.safe.ajax
			success: function (data) {
				if (data.accepted)
				{
					updateProgressBar(0);
					//uaElapsedTimeContainer.hide();
					uaAge.hide();
					uaList.hide();
					monitorProgress();
				}
				else
				{
					taskNotAccepted();
				}
			}
		});
	}

	uaButtonCancel.click(function () 
	{
		AJS.safe.ajax({
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/cancelfindunusedattachments",
			type: "PUT",
			contentType: "application/json",
			dataType: "json",
			data: {}, // must declare this to use AJS.safe.ajax
			success: function (data) {
//				uaButtonFind.prop("disabled", false);
//				uaButtonFind.show();
//				uaButtonRefresh.hide();
//				uaButtonCancel.hide();
//				uaProgressContainer.hide();
				location.reload(true);
			}
		});

		return false;
	});
	
	uaButtonDeleteCancel.click(function () 
	{
		spaceKey = uaPanelContents.data('space-key');
		var pageId = uaPanelContents.data('page-id');
		
		AJS.safe.ajax({
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/canceldeleteattachments" 
				+ (spaceKey ? '?spaceKey=' + spaceKey : '')
				+ (pageId ? '?pageId=' + pageId : ''),
			type: "PUT",
			contentType: "application/json",
			dataType: "json",
			data: {}, // must declare this to use AJS.safe.ajax
			success: function (data) {
				location.reload(true);
			}
		});

		return false;
	});
	
	uaButtonBack.click(function (e) 
	{
		e.preventDefault();

		location.reload(true);
	});
	
	uaDeleteAllLink.click(function (e) 
	{
		e.preventDefault();
		uaDeleteAllConfirm.show();
		uaDeleteSelectedConfirm.hide();
		AJS.dialog2("#ua-delete-dialog").show();
	});

	uaDeleteSelected.click(function (e) 
	{
		e.preventDefault();
		uaDeleteAllConfirm.hide();
		uaDeleteSelectedConfirm.show();
		AJS.dialog2("#ua-delete-dialog").show();
	});

	uaDeleteAllConfirm.click(function (e) 
	{
		e.preventDefault();

		callDeleteAttachments();

		AJS.dialog2("#ua-delete-dialog").hide();
	});

	uaDeleteSelectedConfirm.click(function (e) 
	{
		e.preventDefault();

		attachments = '';
		isFirst = true;
		
		checkboxes = uaSelect;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			if (checkboxes[i].checked)
			{
				attachments = attachments + (isFirst ? '' : ',') + checkboxes[i].getAttribute('data-attachment-id');
				isFirst = false;
			}
		}

		callDeleteAttachments(attachments);

		AJS.dialog2("#ua-delete-dialog").hide();
	});

	function callDeleteAttachments(attachments) 
	{
		spaceKey = uaPanelContents.data('space-key');
		var pageId = uaPanelContents.data('page-id');
		
		AJS.$.ajax({
		//AJS.safe.ajax({ //simply does not work when non empty data needs to be sent
			url: Confluence.getContextPath() + "/rest/confluentis/1.0/deleteunusedattachments",
			type: "POST",
			contentType: "application/json",
			dataType: "json",
			data: '{' 
				+ (spaceKey ? '"spaceKey" : "' + spaceKey + '", ' : '') 
				+ (pageId ? '"pageId" : "' + pageId + '", ' : '') 
				+ '"notifyWatchers" : "' + uaCheckNotify[0].checked + '"' 
				+ (attachments ? ', "attachments" : [' + attachments + ']' : '') 
				+ '}',
			success: function(data, textStatus, jqXHR) {
				if (data.accepted)
				{
					updateProgressBar(0);
					//uaElapsedTimeContainer.hide();
					uaAge.hide();
					uaList.hide();
					monitorProgress();
//					location.reload(true);
				}
				else
				{
					taskNotAccepted();
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				var templates = AJS.Confluence.Templates.Attachments;
				var errorDialog = AJS.ConfluenceDialog({
					width : 600,
					height : 300,
					id : 'attachment-removal-error-dialog'
				});
				errorDialog.addHeader(templates.removalErrorTitle());
				errorDialog.addPanel("", templates.removalErrorBody({
					messages : null
				}));
				errorDialog.addButton(AJS.I18n.getText("close.name"), function() {
					location.reload(true);
				});
				errorDialog.show();
			}
		});
	}

	uaDeleteCancel.click(function (e) 
	{
		e.preventDefault();
		AJS.dialog2("#ua-delete-dialog").hide();
	});

	uaSpace.on('change', function () 
	{
		uaListForm.submit();
	});

	uaRowsPerPage.on('change', function () 
	{
		uaRowsPerPageForm.submit();
	});

	function monitorProgress() 
	{
		uaButtonFind.prop("disabled", true);
		uaButtonRefresh.prop("disabled", true);
		uaButtonCancel.prop("disabled", false);
		uaButtonDeleteCancel.prop("disabled", false);
		
		spaceKey = uaPanelContents.data('space-key');
		var pageId = uaPanelContents.data('page-id');

		var searchInterval = setInterval(function () {
			$.getJSON(
				contextPath + '/rest/confluentis/1.0/unusedattachmentsstatus' 
					+ (spaceKey ? '?spaceKey=' + spaceKey : '')
					+ (pageId ? '?pageId=' + pageId : ''), 
			function (data) 
			{
				if (!data)
				{
					location.reload(true);
					return;
				}
			
				if (data.cancelled) 
				{
					clearInterval(searchInterval);

					if (data.isDeleteTask)
					{
						location.reload(true);
					}
					else
					{
//						uaButtonFind.prop("disabled", false);
//						uaButtonFind.show();
//						uaButtonRefresh.hide();
//						uaButtonCancel.hide();
//						uaProgressContainer.hide();
						location.reload(true);
					}

					return;
				}
				
				uaButtonFind.hide();
				uaButtonRefresh.hide();
				if (data.isDeleteTask)
				{
					uaButtonDeleteCancel.show();
				}
				else
				{
					uaButtonCancel.show();
				}
				uaProgressContainer.show();
				uaSuccessMessageContainer.hide();
				uaErrorMessageContainer.hide();
				
				updateProgressBar(data.percentage);
				uaStatus.text(data.message);
				uaPercentage.text(data.percentage + "%");

				//uaElapsedTimeContainer.show();
				uaElapsedTime.html(data.elapsedTime);

				if (!data.inProgress) 
				{
					uaButtonCancel.prop("disabled", true);
					uaButtonDeleteCancel.prop("disabled", true);
					uaProgressContainer.hide();

					clearInterval(searchInterval);
					
					if (data.success) 
					{
						if (data.isDeleteTask)
						{
							uaSuccessMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.delete.success"));
						}
						else
						{
							uaSuccessMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.search.success"));
						}
						uaSuccessMessageContainer.show();
						location.reload(true);
					}
					else
					{
						//uaErrorMessage.text(data.message);

						if (data.isDeleteTask)
						{
							uaErrorMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.delete.error"));
							uaButtonBack.show();
						}
						else
						{
							uaErrorMessage.text(AJS.I18n.getText("com.alutustech.confluentis.attachments.message.search.error"));
							uaButtonFind.prop("disabled", false);
							uaButtonFind.show();
							uaButtonRefresh.prop("disabled", false);
						}
						uaErrorMessageContainer.show();
						uaButtonCancel.hide();
						uaButtonDeleteCancel.hide();
					}
				}
			});
		}, 1000);
	}

	uaNoLicenseLink.click(function()
	{
		var templates = AJS.Confluence.Templates.Attachments;
		var messageDialog = AJS.ConfluenceDialog({
			width : 600,
			height : 300,
			id : 'license-message-dialog',
			closeOnOutsideClick : true
		});
		messageDialog.addHeader(AJS.I18n.getText("com.alutustech.confluentis.attachments.title.no.license"));
		messageDialog.addPanel(
			"", 
			"<div class=\"aui-message aui-message-error\"><p>" 
				+ AJS.I18n.getText("com.alutustech.confluentis.attachments.message.no.license") 
				+ "</p></div>"
			);
		messageDialog.addButton(AJS.I18n.getText("close.name"), function() {
			messageDialog.hide();
		});
		messageDialog.show();
		return false;
	});

	uaNoDeleteLink.click(function()
	{
		var templates = AJS.Confluence.Templates.Attachments;
		var messageDialog = AJS.ConfluenceDialog({
			width : 600,
			height : 300,
			id : 'ua-no-delete-message-dialog',
			closeOnOutsideClick : true
		});
		messageDialog.addHeader(AJS.I18n.getText("com.alutustech.confluentis.attachments.title.no.delete"));
		messageDialog.addPanel(
			"", 
			"<div class=\"aui-message aui-message-info\"><p>" 
				+ AJS.I18n.getText("com.alutustech.confluentis.attachments.message.no.delete") 
				+ "</p></div>"
			);
		messageDialog.addButton(AJS.I18n.getText("close.name"), function() {
			messageDialog.hide();
		});
		messageDialog.show();
		return false;
	});

	function taskNotAccepted()
	{
		var templates = AJS.Confluence.Templates.Attachments;
		var messageDialog = AJS.ConfluenceDialog({
			width : 600,
			height : 300,
			id : 'ua-no-delete-message-dialog',
			closeOnOutsideClick : true
		});
		messageDialog.addHeader(AJS.I18n.getText("com.alutustech.confluentis.attachments.title.task.not.accepted"));
		messageDialog.addPanel(
			"", 
			"<div class=\"aui-message aui-message-info\"><p>" 
				+ AJS.I18n.getText("com.alutustech.confluentis.attachments.message.task.not.accepted") 
				+ "</p></div>"
			);
		messageDialog.addButton(AJS.I18n.getText("close.name"), function() {
			location.reload(true);
		});
		messageDialog.show();
		return false;
	}

	uaFilter.keyup(function (e)
	{
		var filterText = $.trim(uaFilter.val());

		// Don't run the search if the string is short
		if (!(/^\S{1,2}$/).test(filterText))
		{
			if (oldFilterText != filterText)
			{
				oldFilterText = filterText;
			
				clearTimeout(filterTimer);

				filterTimer = setTimeout(
					function() {
						uaListForm.submit()
					}, 
					300
					);
			}
		}
	});

	$(".ua-labels-editor").click(function (e)
	{
		e.preventDefault();
		var target = $(e.target).closest(".labels-section-content");
		AJS.Labels.openDialog(target);
	});

	AJS.bind("hide.dialog", function(e, data) 
	{
		if (data.dialog.id == 'edit-labels-dialog')
		{
			location.reload(true);
		}
	});

	uaSelectAll.click(function (e)
	{
		checkboxes = uaSelect;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			checkboxes[i].checked = e.target.checked;
		}
		checkboxes = uaSelectAll;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			checkboxes[i].checked = e.target.checked;
		}
		toggleDeleteSelectedLink(e.target.checked);
	});
	
	uaSelect.click(function (e)
	{
		allSelected = true;
		noneSelected = true;
		checkboxes = uaSelect;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			allSelected = allSelected & checkboxes[i].checked;
			noneSelected = noneSelected & !checkboxes[i].checked;
		}
		checkboxes = uaSelectAll;
		for (var i = 0, n = checkboxes.length; i < n; i++)
		{
			checkboxes[i].checked = allSelected;
		}
		toggleDeleteSelectedLink(!noneSelected);
	});

	function toggleDeleteSelectedLink(checked)
	{
		if (checked)
		{
			uaDeleteSelectedLabel.hide();
			uaDeleteSelectedLink.show();
		}
		else
		{
			uaDeleteSelectedLabel.show();
			uaDeleteSelectedLink.hide();
		}
	}

	if (uaInProgress) 
	{
		monitorProgress();
	}
	else
	{
		if (uaList.length > 0)
		{
			uaButtonFind.hide();	
			uaButtonRefresh.show();	
		}
		else
		{
			uaButtonFind.show();	
			uaButtonRefresh.hide();	
		}
		uaButtonCancel.hide();
		uaButtonDeleteCancel.hide();
		uaButtonBack.hide();
		uaProgressContainer.hide();
		uaSuccessMessageContainer.hide();
		uaErrorMessageContainer.hide();
	}
	
	toggleDeleteSelectedLink(false);

});
