/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.FindUnusedAttachmentsTaskResult;
import com.alutustech.confluentis.attachments.UnusedAttachmentsManager;
import com.alutustech.confluentis.attachments.UnusedAttachmentsStatus;
import com.alutustech.confluentis.attachments.data.AttachmentData;
import com.alutustech.confluentis.attachments.data.SpaceData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsFilterAndSortData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsFormData;
import com.alutustech.confluentis.attachments.data.UnusedAttachmentsListData;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UnusedAttachmentsSearchSpaceAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final long serialVersionUID = 1L;
    public static final String REQUEST_PARAMETER_SPACE_KEY = "spaceKey";
    public static final String REQUEST_PARAMETER_FILTER_TEXT = "filterText";
    public static final String REQUEST_PARAMETER_SORT_BY = "sortBy";
    public static final String REQUEST_PARAMETER_SORT_ORDER = "sortOrder";
    public static final String REQUEST_PARAMETER_ROWS_PER_PAGE = "rowsPerPage";
    public static final int DEFAULT_ROWS_PER_PAGE = 20;
    public static final String REQUEST_PARAMETER_PAGE_INDEX = "pageIndex";
    public static final String SESSION_ATTRIBUTE_FILTER_AND_SORT_DATA = "confluentis.attachments.filter.sort.data";
    public static final String LICENSE_MESSAGE_KEY_NO_LICENSE = "com.alutustech.confluentis.attachments.message.no.license";
    public static final String LICENSE_MESSAGE_KEY_INVALID_LICENSE = "com.alutustech.confluentis.attachments.message.invalid.license";
    private final UserManager salUserManager;
    private final SpaceManager spaceManager;
    private final AttachmentManager attachmentManager;
    private final UnusedAttachmentsManager unusedAttachmentsManager;
    private final PluginLicenseManager licenseManager;
    private final HtmlUtil htmlUtil = new HtmlUtil();
    private UnusedAttachmentsFormData formData;

    public UnusedAttachmentsSearchSpaceAction(UserManager salUserManager, SpaceManager spaceManager, AttachmentManager attachmentManager, UnusedAttachmentsManager unusedAttachmentsManager, PluginLicenseManager licenseManager) {
        this.salUserManager = salUserManager;
        this.spaceManager = spaceManager;
        this.attachmentManager = attachmentManager;
        this.unusedAttachmentsManager = unusedAttachmentsManager;
        this.licenseManager = licenseManager;
    }

    public HtmlUtil getHtmlUtil() {
        return this.htmlUtil;
    }

    public UnusedAttachmentsFormData getFormData() {
        return this.formData;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.VIEW, (Object)this.getSpace());
    }

    public String execute() throws Exception {
        String pageIndexParam;
        HttpServletRequest request = new StaticHttpContext().getRequest();
        this.formData = new UnusedAttachmentsFormData();
        UnusedAttachmentsFilterAndSortData filterAndSortData = UnusedAttachmentsSearchSpaceAction.getFilterAndSortData(request);
        this.formData.setFilterAndSortData(filterAndSortData);
        this.formData.setSpaceKey(filterAndSortData.getSpaceKey());
        UnusedAttachmentsListData listData = null;
        String spaceKey = filterAndSortData.getSpaceKey();
        spaceKey = spaceKey == null || spaceKey.trim().length() == 0 ? null : spaceKey;
        Space space = spaceKey == null ? null : this.spaceManager.getSpace(spaceKey);
        filterAndSortData.setSpaceKey(spaceKey);
        ConfluenceUser user = this.getAuthenticatedUser();
        boolean canDelete = false;
        if (user != null && (this.salUserManager.isAdmin(user.getName()) || space != null && this.spacePermissionManager.hasPermission("REMOVEATTACHMENT", space, user))) {
            canDelete = true;
        }
        this.formData.setCanDelete(canDelete);
        FindUnusedAttachmentsTaskResult result = this.unusedAttachmentsManager.loadUnusedAttachmentsResult(spaceKey);
        if (result != null) {
            listData = new UnusedAttachmentsListData();
            HashSet<Long> spaces = new HashSet<Long>();
            HashSet allUnusedAttachments = new HashSet();
            for (Map.Entry<Long, Set<Long>> entry : result.getUnusedAttachments().entrySet()) {
                if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
                spaces.add(entry.getKey());
                allUnusedAttachments.addAll(entry.getValue());
            }
            listData.setSpaces(spaces);
            Set<Long> filteredAndSortedAttachmentIds = this.unusedAttachmentsManager.getFilteredAndSortedAttachmentIds(filterAndSortData);
            filteredAndSortedAttachmentIds.retainAll(allUnusedAttachments);
            listData.setAttachments(filteredAndSortedAttachmentIds);
            listData.setResultTime(result.getResultTime());
            UnusedAttachmentsListData globalListData = this.unusedAttachmentsManager.loadUnusedAttachmentsSpacesOnly();
            if (globalListData != null && globalListData.getResultTime() == result.getResultTime()) {
                this.formData.setLatestResult(true);
            }
            this.formData.setTotalAttachmentsCount(allUnusedAttachments.size());
        }
        int pageIndex = (pageIndexParam = request.getParameter(REQUEST_PARAMETER_PAGE_INDEX)) == null || pageIndexParam.length() == 0 ? 1 : Integer.valueOf(pageIndexParam);
        this.formData.setPageIndex(pageIndex);
        this.processFormData(this.formData, listData);
        return "success";
    }

    public static UnusedAttachmentsFilterAndSortData getFilterAndSortData(HttpServletRequest request) throws Exception {
        UnusedAttachmentsFilterAndSortData newFilterAndSortData = new UnusedAttachmentsFilterAndSortData();
        UnusedAttachmentsFilterAndSortData sessionFilterAndSortData = UnusedAttachmentsFilterAndSortData.getInstance((Map)request.getSession().getAttribute(SESSION_ATTRIBUTE_FILTER_AND_SORT_DATA));
        String spaceKey = request.getParameter(REQUEST_PARAMETER_SPACE_KEY);
        newFilterAndSortData.setSpaceKey((String)(spaceKey == null ? (sessionFilterAndSortData == null ? null : sessionFilterAndSortData.getSpaceKey()) : spaceKey));
        String filterText = request.getParameter(REQUEST_PARAMETER_FILTER_TEXT);
        newFilterAndSortData.setFilterText((String)(filterText == null ? (sessionFilterAndSortData == null ? null : sessionFilterAndSortData.getFilterText()) : filterText));
        String sortBy = request.getParameter(REQUEST_PARAMETER_SORT_BY);
        newFilterAndSortData.setSortBy((String)(sortBy == null ? (sessionFilterAndSortData == null ? null : sessionFilterAndSortData.getSortBy()) : sortBy));
        String sortOrder = request.getParameter(REQUEST_PARAMETER_SORT_ORDER);
        newFilterAndSortData.setSortOrder((String)(sortOrder == null ? (sessionFilterAndSortData == null ? null : sessionFilterAndSortData.getSortOrder()) : sortOrder));
        String rowsPerPage = request.getParameter(REQUEST_PARAMETER_ROWS_PER_PAGE);
        newFilterAndSortData.setRowsPerPage((String)(rowsPerPage == null ? (sessionFilterAndSortData == null ? null : sessionFilterAndSortData.getRowsPerPage()) : rowsPerPage));
        if (newFilterAndSortData.getRowsPerPage() == null) {
            newFilterAndSortData.setRowsPerPage(String.valueOf(20));
        }
        request.getSession().setAttribute(SESSION_ATTRIBUTE_FILTER_AND_SORT_DATA, UnusedAttachmentsFilterAndSortData.getValues(newFilterAndSortData));
        return newFilterAndSortData;
    }

    private void processFormData(UnusedAttachmentsFormData formData, UnusedAttachmentsListData listData) {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                formData.setLicenseMessage(LICENSE_MESSAGE_KEY_INVALID_LICENSE);
            }
        } else {
            formData.setLicenseMessage(LICENSE_MESSAGE_KEY_NO_LICENSE);
        }
        formData.setAppMajorVersion(Integer.parseInt(GeneralUtil.getVersionNumber().split("[.]")[0]));
        UnusedAttachmentsStatus status = this.unusedAttachmentsManager.getStatus(formData.getSpaceKey(), null);
        formData.setInProgress(status == null ? false : status.inProgress);
        if (listData != null) {
            Space space;
            formData.setResultCreationDate(this.getDateFormatter().formatDateTime(new Date(listData.getResultTime())));
            HashMap<String, SpaceData> spaces = new HashMap<String, SpaceData>();
            if (listData.getSpaces() != null) {
                for (Long spaceId : listData.getSpaces()) {
                    Space space2 = this.spaceManager.getSpace(spaceId.longValue());
                    if (space2 == null) continue;
                    spaces.put(space2.getKey(), new SpaceData(space2.getKey(), space2.getName()));
                }
            }
            if (formData.getFilterAndSortData() != null && formData.getFilterAndSortData().getSpaceKey() != null && formData.getFilterAndSortData().getSpaceKey().trim().length() > 0 && !spaces.containsKey(formData.getFilterAndSortData().getSpaceKey()) && (space = this.spaceManager.getSpace(formData.getFilterAndSortData().getSpaceKey())) != null) {
                spaces.put(space.getKey(), new SpaceData(space.getKey(), space.getName()));
            }
            ArrayList<SpaceData> spacesList = new ArrayList<SpaceData>(spaces.values());
            Collections.sort(spacesList);
            formData.setSpaces(spacesList);
            if (listData.getAttachments() != null) {
                ArrayList<AttachmentData> spaceUnusedAttachments = new ArrayList<AttachmentData>();
                int filledPage = 0;
                int i = 0;
                String rowsPerPageStr = formData.getFilterAndSortData().getRowsPerPage();
                Integer rowsPerPage = rowsPerPageStr == null || rowsPerPageStr.trim().length() == 0 ? null : Integer.valueOf(Integer.parseInt(rowsPerPageStr));
                rowsPerPage = rowsPerPage == null || rowsPerPage <= 0 ? 20 : rowsPerPage;
                for (Long attachmentId : listData.getAttachments()) {
                    ContentEntityObject attachmentCEO;
                    if ((filledPage = ++i / rowsPerPage + (i % rowsPerPage == 0 ? 0 : 1)) != formData.getPageIndex()) continue;
                    Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
                    Attachment attachmentObj = attachment;
                    ContentEntityObject contentEntityObject = attachmentCEO = attachmentObj instanceof ContentEntityObject ? (ContentEntityObject)attachmentObj : null;
                    if (attachment == null || attachmentCEO != null && attachmentCEO.isDeleted()) continue;
                    Space space3 = attachment.getSpace();
                    AttachmentData attachmentData = new AttachmentData(attachmentId, space3.getKey(), space3.getName(), attachment.getContainer().toPageContext().getEntity().getId(), attachment.getContainer().toPageContext().getPageTitle(), attachment.getFileName(), attachment.getVersionComment(), attachment.getNiceFileSize(), this.getDateFormatter().formatDateTime(attachment.getCreationDate()));
                    spaceUnusedAttachments.add(attachmentData);
                }
                formData.setUnusedAttachments(spaceUnusedAttachments);
                formData.setPaginationPageCount(filledPage);
                formData.setFilteredAttachmentsCount(i);
            }
        }
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }
}

