/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.AbstractAttachmentXhtmlVisitor;
import com.alutustech.confluentis.attachments.UnusedAttachmentsConfig;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContentEventAttachmentXhtmlVisitor
extends AbstractAttachmentXhtmlVisitor {
    private final Map<Long, Set<Long>> attachmentsRefsMap;

    public ContentEventAttachmentXhtmlVisitor(UnusedAttachmentsConfig config, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager, Map<Long, Set<Long>> attachmentsRefsMap) {
        super(config, spaceManager, pageManager, attachmentManager, thumbnailManager);
        this.attachmentsRefsMap = attachmentsRefsMap;
    }

    @Override
    public void processAttachmentReference(long spaceId, long attachmentId) {
        Set<Long> attachmentsRefsSet = this.attachmentsRefsMap.get(spaceId);
        if (attachmentsRefsSet == null) {
            attachmentsRefsSet = new HashSet<Long>();
            this.attachmentsRefsMap.put(spaceId, attachmentsRefsSet);
        }
        attachmentsRefsSet.add(attachmentId);
    }

    @Override
    public void processSamePageAttachments(long spaceId, List<Attachment> attachments) {
        this.processOtherPageAttachments(spaceId, attachments);
    }

    @Override
    public void processOtherPageAttachments(long spaceId, List<Attachment> attachments) {
        if (attachments.size() > 0) {
            Set<Long> attachmentsRefsSet = this.attachmentsRefsMap.get(spaceId);
            if (attachmentsRefsSet == null) {
                attachmentsRefsSet = new HashSet<Long>();
                this.attachmentsRefsMap.put(spaceId, attachmentsRefsSet);
            }
            for (Attachment attachment : attachments) {
                attachmentsRefsSet.add(attachment.getId());
            }
        }
    }

    @Override
    public void processSpaceAttachments(long spaceId) {
        Set<Long> attachmentsRefsSet = this.attachmentsRefsMap.get(spaceId);
        if (attachmentsRefsSet == null) {
            attachmentsRefsSet = new HashSet<Long>();
            this.attachmentsRefsMap.put(spaceId, attachmentsRefsSet);
        }
        attachmentsRefsSet.clear();
        attachmentsRefsSet.add(-1L);
    }
}

