/*
 * Decompiled with CFR 0.152.
 */
package com.alutustech.confluentis.attachments;

import com.alutustech.confluentis.attachments.UnusedAttachmentsConfig;
import com.alutustech.confluentis.attachments.macros.AttachmentReference;
import com.alutustech.confluentis.attachments.macros.AttachmentsMacro;
import com.alutustech.confluentis.attachments.macros.ContentTitleHolder;
import com.alutustech.confluentis.attachments.macros.DiagramNameParameterSetter;
import com.alutustech.confluentis.attachments.macros.DrawioMacro;
import com.alutustech.confluentis.attachments.macros.ExcludeLabelParameterSetter;
import com.alutustech.confluentis.attachments.macros.ExcludeParameterSetter;
import com.alutustech.confluentis.attachments.macros.GalleryMacro;
import com.alutustech.confluentis.attachments.macros.GliffyMacro;
import com.alutustech.confluentis.attachments.macros.IncludeLabelParameterSetter;
import com.alutustech.confluentis.attachments.macros.IncludeParameterSetter;
import com.alutustech.confluentis.attachments.macros.LabelsParameterSetter;
import com.alutustech.confluentis.attachments.macros.NameParameterSetter;
import com.alutustech.confluentis.attachments.macros.PageIdParameterSetter;
import com.alutustech.confluentis.attachments.macros.PageParameterSetter;
import com.alutustech.confluentis.attachments.macros.ParameterSetter;
import com.alutustech.confluentis.attachments.macros.PatternsParameterSetter;
import com.alutustech.confluentis.attachments.macros.SpaceAttachmentsMacro;
import com.alutustech.confluentis.attachments.macros.SpaceKeyHolder;
import com.alutustech.confluentis.attachments.util.Base64Util;
import com.alutustech.confluentis.attachments.util.UnusedAttachmentsUtil;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.StorageMacroConstants;
import com.atlassian.confluence.content.render.xhtml.storage.resource.identifiers.StorageResourceIdentifierConstants;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailInfo;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.pages.thumbnail.Thumbnails;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.xhtml.api.XhtmlVisitor;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractAttachmentXhtmlVisitor
implements XhtmlVisitor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAttachmentXhtmlVisitor.class);
    private static final DateFormat POSTING_DAY_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final String MACRO_NAME_attachments = "attachments";
    private static final String MACRO_NAME_space_attachments = "space-attachments";
    private static final String MACRO_NAME_gallery = "gallery";
    private static final String MACRO_NAME_gliffy = "gliffy";
    private static final String MACRO_NAME_drawio = "drawio";
    private static final String PARAMETER_NAME_patterns = "patterns";
    private static final String PARAMETER_NAME_labels = "labels";
    private static final String PARAMETER_NAME_include = "include";
    private static final String PARAMETER_NAME_exclude = "exclude";
    private static final String PARAMETER_NAME_includeLabel = "includeLabel";
    private static final String PARAMETER_NAME_excludeLabel = "excludeLabel";
    private static final String PARAMETER_NAME_page = "page";
    private static final String PARAMETER_NAME_name = "name";
    private static final String PARAMETER_NAME_pageid = "pageid";
    private static final String PARAMETER_NAME_diagramName = "diagramName";
    private static final String PARAMETER_NAME_pageId = "pageId";
    private static final String RI_ATTACHMENT_ELEMENT = "<" + StorageResourceIdentifierConstants.ATTACHMENT_RESOURCE_QNAME.getPrefix() + ":" + StorageResourceIdentifierConstants.ATTACHMENT_RESOURCE_QNAME.getLocalPart();
    private static final String AC_MACRO_ELEMENT = "<" + StorageMacroConstants.MACRO_ELEMENT.getPrefix() + ":" + StorageMacroConstants.MACRO_ELEMENT.getLocalPart();
    private static final String AC_STRUCTURED_MACRO_ELEMENT = "<" + StorageMacroConstants.MACRO_V2_ELEMENT.getPrefix() + ":" + StorageMacroConstants.MACRO_V2_ELEMENT.getLocalPart();
    private final UnusedAttachmentsConfig config;
    private final Set<String> filtersExcludePageMacros;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;
    private final ThumbnailManager thumbnailManager;
    private Object crtObject;
    private AttachmentReference crtAttachmentReference;
    private AttachmentsMacro crtAttachmentsMacro;
    private SpaceAttachmentsMacro crtSpaceAttachmentsMacro;
    private GalleryMacro crtGalleryMacro;
    private GliffyMacro crtGliffyMacro;
    private DrawioMacro crtDrawioMacro;
    private ParameterSetter crtParameterSetter;

    public AbstractAttachmentXhtmlVisitor(UnusedAttachmentsConfig config, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager) {
        this.config = config;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.thumbnailManager = thumbnailManager;
        this.filtersExcludePageMacros = UnusedAttachmentsUtil.getLabels(config.getFiltersExcludePageMacros());
    }

    public boolean handle(XMLEvent xmlEvent, ConversionContext conversionContext) {
        switch (xmlEvent.getEventType()) {
            case 7: {
                this.crtObject = null;
                this.crtAttachmentReference = null;
                this.crtAttachmentsMacro = null;
                this.crtSpaceAttachmentsMacro = null;
                this.crtGalleryMacro = null;
                this.crtGliffyMacro = null;
                this.crtDrawioMacro = null;
                break;
            }
            case 1: {
                StartElement startElement = xmlEvent.asStartElement();
                if (StorageResourceIdentifierConstants.ATTACHMENT_RESOURCE_QNAME.equals(startElement.getName())) {
                    this.startRiAttachment(startElement);
                    break;
                }
                if (StorageResourceIdentifierConstants.PAGE_RESOURCE_QNAME.equals(startElement.getName())) {
                    this.startRiPage(startElement, conversionContext);
                    break;
                }
                if (StorageResourceIdentifierConstants.BLOG_POST_RESOURCE_QNAME.equals(startElement.getName())) {
                    this.startRiBlogPost(startElement, conversionContext);
                    break;
                }
                if (StorageMacroConstants.MACRO_ELEMENT.equals(startElement.getName()) || StorageMacroConstants.MACRO_V2_ELEMENT.equals(startElement.getName())) {
                    ContentEntityObject contentEntity;
                    List attachments;
                    Attribute attr = startElement.getAttributeByName(StorageMacroConstants.NAME_ATTRIBUTE);
                    if (attr == null) break;
                    if (!this.config.isIgnoreAttachmentsMacro() && MACRO_NAME_attachments.equals(attr.getValue())) {
                        this.startAttachmentsMacro(startElement, conversionContext);
                    } else if (!this.config.isIgnoreSpaceAttachmentsMacro() && MACRO_NAME_space_attachments.equals(attr.getValue())) {
                        this.startSpaceAttachmentsMacro(startElement, conversionContext);
                    } else if (!this.config.isIgnoreGalleryMacro() && MACRO_NAME_gallery.equals(attr.getValue())) {
                        this.startGalleryMacro(startElement, conversionContext);
                    } else if (!this.config.isIgnoreGliffyMacro() && MACRO_NAME_gliffy.equals(attr.getValue())) {
                        this.startGliffyMacro(startElement, conversionContext);
                    } else if (!this.config.isIgnoreDrawioMacro() && MACRO_NAME_drawio.equals(attr.getValue())) {
                        this.startDrawioMacro(startElement, conversionContext);
                    }
                    if (this.filtersExcludePageMacros == null || !this.filtersExcludePageMacros.contains(attr.getValue()) || (attachments = this.attachmentManager.getLatestVersionsOfAttachments(contentEntity = conversionContext.getEntity())) == null || attachments.size() <= 0) break;
                    Space space = this.spaceManager.getSpace(conversionContext.getSpaceKey());
                    this.processSamePageAttachments(space.getId(), attachments);
                    break;
                }
                if (StorageMacroConstants.MACRO_PARAMETER_ELEMENT.equals(startElement.getName())) {
                    Attribute attr = startElement.getAttributeByName(StorageMacroConstants.NAME_ATTRIBUTE);
                    if (attr == null) break;
                    if (PARAMETER_NAME_page.equals(attr.getValue())) {
                        this.startPageParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_include.equals(attr.getValue())) {
                        this.startIncludeParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_exclude.equals(attr.getValue())) {
                        this.startExcludeParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_includeLabel.equals(attr.getValue())) {
                        this.startIncludeLabelParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_excludeLabel.equals(attr.getValue())) {
                        this.startExcludeLabelParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_patterns.equals(attr.getValue())) {
                        this.startPatternsParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_labels.equals(attr.getValue())) {
                        this.startLabelsParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_name.equals(attr.getValue())) {
                        this.startNameParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_pageid.equals(attr.getValue())) {
                        this.startPageidParameter(startElement, conversionContext);
                        break;
                    }
                    if (PARAMETER_NAME_diagramName.equals(attr.getValue())) {
                        this.startDiagramNameParameter(startElement, conversionContext);
                        break;
                    }
                    if (!PARAMETER_NAME_pageId.equals(attr.getValue())) break;
                    this.startPageIdParameter(startElement, conversionContext);
                    break;
                }
                if (!StorageResourceIdentifierConstants.SPACE_RESOURCE_QNAME.equals(startElement.getName())) break;
                this.startRiSpace(startElement, conversionContext);
                break;
            }
            case 2: {
                EndElement endElement = xmlEvent.asEndElement();
                if (StorageResourceIdentifierConstants.ATTACHMENT_RESOURCE_QNAME.equals(endElement.getName())) {
                    this.endRiAttachment(conversionContext);
                    break;
                }
                if (StorageMacroConstants.MACRO_ELEMENT.equals(endElement.getName()) || StorageMacroConstants.MACRO_V2_ELEMENT.equals(endElement.getName())) {
                    if (!this.config.isIgnoreAttachmentsMacro() && this.crtAttachmentsMacro != null) {
                        this.endAttachmentsMacro(conversionContext);
                        break;
                    }
                    if (!this.config.isIgnoreSpaceAttachmentsMacro() && this.crtSpaceAttachmentsMacro != null) {
                        this.endSpaceAttachmentsMacro(conversionContext);
                        break;
                    }
                    if (!this.config.isIgnoreGalleryMacro() && this.crtGalleryMacro != null) {
                        this.endGalleryMacro(conversionContext);
                        break;
                    }
                    if (!this.config.isIgnoreGliffyMacro() && this.crtGliffyMacro != null) {
                        this.endGliffyMacro(conversionContext);
                        break;
                    }
                    if (this.config.isIgnoreDrawioMacro() || this.crtDrawioMacro == null) break;
                    this.endDrawioMacro(conversionContext);
                    break;
                }
                if (!StorageMacroConstants.MACRO_PARAMETER_ELEMENT.equals(endElement.getName())) break;
                this.endMacroParameter(conversionContext);
                break;
            }
            case 4: 
            case 12: {
                Characters content = xmlEvent.asCharacters();
                if (this.crtParameterSetter == null) break;
                this.crtParameterSetter.setValue(content.getData());
                break;
            }
        }
        return true;
    }

    private void startRiAttachment(StartElement startElement) {
        if (this.crtAttachmentReference != null) {
            throw new IllegalStateException();
        }
        this.crtAttachmentReference = new AttachmentReference();
        this.crtObject = this.crtAttachmentReference;
        Attribute attr = startElement.getAttributeByName(StorageResourceIdentifierConstants.FILENAME_ATTRIBUTE_QNAME);
        if (attr != null) {
            this.crtAttachmentReference.fileName = attr.getValue();
        }
    }

    private void startRiPage(StartElement startElement, ConversionContext conversionContext) {
        ContentTitleHolder crtContentTitleHolder;
        SpaceKeyHolder crtSpaceKeyHolder;
        Attribute attr = startElement.getAttributeByName(StorageResourceIdentifierConstants.SPACEKEY_ATTRIBUTE_QNAME);
        if (attr != null && (crtSpaceKeyHolder = this.getCrtSpaceKeyHolder()) != null) {
            crtSpaceKeyHolder.setSpaceKey(attr.getValue());
        }
        if ((attr = startElement.getAttributeByName(StorageResourceIdentifierConstants.CONTENT_TITLE_ATTRIBUTE_QNAME)) != null && (crtContentTitleHolder = this.getCrtContentTitleHolder()) != null) {
            crtContentTitleHolder.setContentTitle(attr.getValue());
        }
    }

    private void startRiBlogPost(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtAttachmentReference != null) {
            Attribute attr = startElement.getAttributeByName(StorageResourceIdentifierConstants.SPACEKEY_ATTRIBUTE_QNAME);
            if (attr != null) {
                this.crtAttachmentReference.spaceKey = attr.getValue();
            }
            if ((attr = startElement.getAttributeByName(StorageResourceIdentifierConstants.CONTENT_TITLE_ATTRIBUTE_QNAME)) != null) {
                this.crtAttachmentReference.contentTitle = attr.getValue();
            }
            if ((attr = startElement.getAttributeByName(StorageResourceIdentifierConstants.POSTING_DAY_ATTRIBUTE_QNAME)) != null) {
                this.crtAttachmentReference.postingDay = attr.getValue();
            }
        }
    }

    private void endRiAttachment(ConversionContext conversionContext) {
        if (this.crtAttachmentReference == null) {
            throw new IllegalStateException();
        }
        if (this.crtAttachmentReference.fileName != null) {
            Attachment attachment;
            ContentEntityObject contentEntity;
            block10: {
                contentEntity = null;
                if (this.crtAttachmentReference.contentTitle == null) {
                    contentEntity = conversionContext.getPageContext().getEntity();
                } else {
                    String spaceKey = this.crtAttachmentReference.spaceKey;
                    if (spaceKey == null) {
                        spaceKey = conversionContext.getSpaceKey();
                    }
                    if (this.crtAttachmentReference.postingDay == null) {
                        contentEntity = this.pageManager.getPage(spaceKey, this.crtAttachmentReference.contentTitle);
                    } else {
                        Date postingDay = null;
                        try {
                            postingDay = POSTING_DAY_FORMAT.parse(this.crtAttachmentReference.postingDay);
                            contentEntity = this.pageManager.getBlogPost(spaceKey, this.crtAttachmentReference.contentTitle, BlogPost.toCalendar((Date)postingDay));
                        }
                        catch (ParseException e) {
                            if (!log.isErrorEnabled()) break block10;
                            log.error("Posting day value parsing failed.", (Throwable)e);
                        }
                    }
                }
            }
            Attachment attachment2 = attachment = contentEntity == null ? null : this.attachmentManager.getAttachment((ContentEntityObject)contentEntity.getLatestVersion(), this.crtAttachmentReference.fileName);
            if (attachment != null) {
                attachment = (Attachment)attachment.getLatestVersion();
                long attachmentId = attachment.getId();
                long spaceId = attachment.getSpace().getId();
                this.processAttachmentReference(spaceId, attachmentId);
            }
        }
        this.crtAttachmentReference = null;
        this.crtObject = null;
    }

    private void startAttachmentsMacro(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtAttachmentsMacro != null) {
            throw new IllegalStateException();
        }
        this.crtAttachmentsMacro = new AttachmentsMacro();
        this.crtObject = this.crtAttachmentsMacro;
    }

    private void startSpaceAttachmentsMacro(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtSpaceAttachmentsMacro != null) {
            throw new IllegalStateException();
        }
        this.crtSpaceAttachmentsMacro = new SpaceAttachmentsMacro();
        this.crtObject = this.crtSpaceAttachmentsMacro;
    }

    private void startGalleryMacro(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGalleryMacro != null) {
            throw new IllegalStateException();
        }
        this.crtGalleryMacro = new GalleryMacro();
        this.crtObject = this.crtGalleryMacro;
    }

    private void startGliffyMacro(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGliffyMacro != null) {
            throw new IllegalStateException();
        }
        this.crtGliffyMacro = new GliffyMacro();
        this.crtObject = this.crtGliffyMacro;
    }

    private void startDrawioMacro(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtDrawioMacro != null) {
            throw new IllegalStateException();
        }
        this.crtDrawioMacro = new DrawioMacro();
        this.crtObject = this.crtDrawioMacro;
    }

    private void endAttachmentsMacro(ConversionContext conversionContext) {
        ContentEntityObject contentEntity = null;
        String contentTitle = this.crtAttachmentsMacro.contentTitle;
        if (contentTitle == null) {
            contentEntity = conversionContext.getEntity();
        } else {
            String spaceKey = this.crtAttachmentsMacro.spaceKey;
            if (spaceKey == null) {
                spaceKey = conversionContext.getSpaceKey();
            }
            contentEntity = this.pageManager.getPage(spaceKey, contentTitle);
        }
        if (contentEntity != null) {
            List<Object> attachments = new ArrayList(this.attachmentManager.getLatestVersionsOfAttachments(contentEntity));
            if ((attachments = attachments.stream().filter(AbstractAttachmentXhtmlVisitor.attachmentFilenameFilter(this.crtAttachmentsMacro.patterns)).filter(AbstractAttachmentXhtmlVisitor.requiredLabelsFilter(this.crtAttachmentsMacro.labels)).collect(Collectors.toList())).size() > 0) {
                this.processOtherPageAttachments(((Attachment)attachments.get(0)).getSpace().getId(), attachments);
            }
        }
        this.crtAttachmentsMacro = null;
        this.crtObject = null;
    }

    private void endSpaceAttachmentsMacro(ConversionContext conversionContext) {
        Space space;
        String spaceKey = this.crtSpaceAttachmentsMacro.spaceKey;
        if (spaceKey == null) {
            spaceKey = conversionContext.getSpaceKey();
        }
        if ((space = this.spaceManager.getSpace(spaceKey)) != null) {
            this.processSpaceAttachments(space.getId());
        }
        this.crtSpaceAttachmentsMacro = null;
        this.crtObject = null;
    }

    private void endGalleryMacro(ConversionContext conversionContext) {
        FilterParams filterParams = new FilterParams(this.splitList(this.crtGalleryMacro.include), this.splitList(this.crtGalleryMacro.exclude), this.splitList(this.crtGalleryMacro.includeLabel), this.splitList(this.crtGalleryMacro.excludeLabel));
        String[] pages = this.splitList(this.crtGalleryMacro.page);
        if (pages.length > 0) {
            for (String page : pages) {
                Page contentEntity;
                String spaceKey = null;
                String contentTitle = null;
                String[] tokens = page.split(":");
                if (tokens.length == 1) {
                    contentTitle = tokens[0].trim();
                } else {
                    spaceKey = tokens[0].trim();
                    contentTitle = tokens[1].trim();
                }
                if (spaceKey == null) {
                    spaceKey = conversionContext.getSpaceKey();
                }
                if ((contentEntity = this.pageManager.getPage(spaceKey, contentTitle)) == null) continue;
                this.filterPageAttachments(filterParams, (ContentEntityObject)contentEntity);
            }
        } else {
            this.filterPageAttachments(filterParams, conversionContext.getEntity());
        }
        this.crtGalleryMacro = null;
        this.crtObject = null;
    }

    private void endGliffyMacro(ConversionContext conversionContext) {
        if (this.crtGliffyMacro.name != null) {
            List attachments;
            ContentEntityObject contentEntity = null;
            if (this.crtGliffyMacro.pageId == null) {
                contentEntity = conversionContext.getEntity();
            } else {
                Long pageId = Long.valueOf(this.crtGliffyMacro.pageId);
                contentEntity = this.pageManager.getAbstractPage(pageId.longValue());
            }
            if (contentEntity != null && (attachments = this.attachmentManager.getLatestVersionsOfAttachments(contentEntity)) != null) {
                String imageFileName = this.crtGliffyMacro.name + ".png";
                int foundAttachmentsCount = 0;
                for (int i = 0; i < attachments.size() && foundAttachmentsCount < 2; ++i) {
                    Attachment attachment = (Attachment)attachments.get(i);
                    if (!attachment.getFileName().equals(this.crtGliffyMacro.name) && !attachment.getFileName().equals(imageFileName)) continue;
                    this.processAttachmentReference(attachment.getSpace().getId(), attachment.getId());
                    ++foundAttachmentsCount;
                }
            }
        }
        this.crtGliffyMacro = null;
        this.crtObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDrawioMacro(ConversionContext conversionContext) {
        if (this.crtDrawioMacro.diagramName != null) {
            List attachments;
            ContentEntityObject contentEntity = null;
            if (this.crtDrawioMacro.pageId == null) {
                contentEntity = conversionContext.getEntity();
            } else {
                Long pageId = Long.valueOf(this.crtDrawioMacro.pageId);
                contentEntity = this.pageManager.getAbstractPage(pageId.longValue());
            }
            if (contentEntity != null && (attachments = this.attachmentManager.getLatestVersionsOfAttachments(contentEntity)) != null) {
                String imageFileName = this.crtDrawioMacro.diagramName + ".png";
                int foundAttachmentsCount = 0;
                for (int i = 0; i < attachments.size() && foundAttachmentsCount < 2; ++i) {
                    Attachment attachment = (Attachment)attachments.get(i);
                    if (attachment.getFileName().equals(this.crtDrawioMacro.diagramName) || attachment.getFileName().equals(imageFileName)) {
                        this.processAttachmentReference(attachment.getSpace().getId(), attachment.getId());
                        ++foundAttachmentsCount;
                    }
                    if (!attachment.getFileName().equals(this.crtDrawioMacro.diagramName)) continue;
                    InputStream is = null;
                    try {
                        is = attachment.getContentsAsStream();
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        SAXParser saxParser = factory.newSAXParser();
                        final ArrayList diagramXmls = new ArrayList();
                        DefaultHandler handler = new DefaultHandler(){
                            private boolean isDiagram = false;

                            @Override
                            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                                this.isDiagram = qName.equalsIgnoreCase("diagram");
                            }

                            @Override
                            public void characters(char[] ch, int start, int length) throws SAXException {
                                block4: {
                                    if (this.isDiagram) {
                                        String contents = new String(ch, start, length);
                                        try {
                                            int count;
                                            byte[] inBytes = Base64Util.decode(contents);
                                            Inflater inflater = new Inflater();
                                            inflater.setInput(inBytes);
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream(inBytes.length);
                                            byte[] buffer = new byte[8192];
                                            while (!inflater.finished() && (count = inflater.inflate(buffer)) != 0) {
                                                baos.write(buffer, 0, count);
                                            }
                                            inflater.end();
                                            byte[] output = baos.toByteArray();
                                            diagramXmls.add(URLDecoder.decode(new String(output, "UTF-8"), "UTF-8"));
                                        }
                                        catch (IOException | DataFormatException e) {
                                            if (!log.isErrorEnabled()) break block4;
                                            log.error("Decoding draw.io diagram file failed.", (Throwable)e);
                                        }
                                    }
                                }
                            }
                        };
                        saxParser.parse(is, handler);
                        if (diagramXmls.size() <= 0) continue;
                        for (String diagramXml : diagramXmls) {
                            Pattern pattern = Pattern.compile("/download/attachments/(\\d+)/(.*?)[;&\"]");
                            Matcher matcher = pattern.matcher(diagramXml);
                            while (matcher.find()) {
                                List attachments2;
                                if (matcher.groupCount() != 2) continue;
                                Long pageId = Long.valueOf(matcher.group(1));
                                String fileName = matcher.group(2);
                                AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
                                if (page == null || (attachments2 = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page)) == null) continue;
                                for (Attachment attach : attachments2) {
                                    if (!attach.getFileName().equals(fileName)) continue;
                                    this.processAttachmentReference(attach.getSpace().getId(), attach.getId());
                                }
                            }
                        }
                        continue;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error("Processing draw.io diagram file failed.", (Throwable)e);
                        continue;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
        this.crtDrawioMacro = null;
        this.crtObject = null;
    }

    private void filterPageAttachments(FilterParams filterParams, ContentEntityObject contentEntity) {
        List<Attachment> attachments = this.attachmentManager.getLatestVersionsOfAttachments(contentEntity);
        attachments = this.filterAttachments(filterParams, attachments);
        Thumbnails thumbnails = new Thumbnails(attachments, null, 0, this.thumbnailManager);
        attachments = new ArrayList<Attachment>();
        List thumbnailInfos = thumbnails.getThumbnails();
        if (thumbnailInfos != null && thumbnailInfos.size() > 0) {
            for (ThumbnailInfo thumbnail : thumbnails.getThumbnails()) {
                attachments.add(thumbnail.getAttachment());
            }
            this.processOtherPageAttachments(attachments.get(0).getSpace().getId(), attachments);
        }
    }

    private void startRiSpace(StartElement startElement, ConversionContext conversionContext) {
        SpaceKeyHolder crtSpaceKeyHolder;
        Attribute attr = startElement.getAttributeByName(StorageResourceIdentifierConstants.SPACEKEY_ATTRIBUTE_QNAME);
        if (attr != null && (crtSpaceKeyHolder = this.getCrtSpaceKeyHolder()) != null) {
            crtSpaceKeyHolder.setSpaceKey(attr.getValue());
        }
    }

    private void startPatternsParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtAttachmentsMacro != null) {
            this.crtParameterSetter = new PatternsParameterSetter(this.crtAttachmentsMacro);
        }
    }

    private void startLabelsParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtAttachmentsMacro != null) {
            this.crtParameterSetter = new LabelsParameterSetter(this.crtAttachmentsMacro);
        }
    }

    private void startIncludeParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGalleryMacro != null) {
            this.crtParameterSetter = new IncludeParameterSetter(this.crtGalleryMacro);
        }
    }

    private void startExcludeParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGalleryMacro != null) {
            this.crtParameterSetter = new ExcludeParameterSetter(this.crtGalleryMacro);
        }
    }

    private void startIncludeLabelParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGalleryMacro != null) {
            this.crtParameterSetter = new IncludeLabelParameterSetter(this.crtGalleryMacro);
        }
    }

    private void startExcludeLabelParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGalleryMacro != null) {
            this.crtParameterSetter = new ExcludeLabelParameterSetter(this.crtGalleryMacro);
        }
    }

    private void startPageParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGalleryMacro != null) {
            this.crtParameterSetter = new PageParameterSetter(this.crtGalleryMacro);
        }
    }

    private void startNameParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGliffyMacro != null) {
            this.crtParameterSetter = new NameParameterSetter(this.crtGliffyMacro);
        }
    }

    private void startPageidParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtGliffyMacro != null) {
            this.crtParameterSetter = new PageIdParameterSetter(this.crtGliffyMacro);
        }
    }

    private void startDiagramNameParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtDrawioMacro != null) {
            this.crtParameterSetter = new DiagramNameParameterSetter(this.crtDrawioMacro);
        }
    }

    private void startPageIdParameter(StartElement startElement, ConversionContext conversionContext) {
        if (this.crtDrawioMacro != null) {
            this.crtParameterSetter = new PageIdParameterSetter(this.crtDrawioMacro);
        }
    }

    private void endMacroParameter(ConversionContext conversionContext) {
        this.crtParameterSetter = null;
    }

    private SpaceKeyHolder getCrtSpaceKeyHolder() {
        return this.crtObject instanceof SpaceKeyHolder ? (SpaceKeyHolder)this.crtObject : null;
    }

    private ContentTitleHolder getCrtContentTitleHolder() {
        return this.crtObject instanceof ContentTitleHolder ? (ContentTitleHolder)this.crtObject : null;
    }

    public abstract void processAttachmentReference(long var1, long var3);

    public abstract void processSamePageAttachments(long var1, List<Attachment> var3);

    public abstract void processOtherPageAttachments(long var1, List<Attachment> var3);

    public abstract void processSpaceAttachments(long var1);

    public static boolean toProcessXhtml(String content) {
        return content.indexOf(RI_ATTACHMENT_ELEMENT) >= 0 || content.indexOf(AC_MACRO_ELEMENT) >= 0 || content.indexOf(AC_STRUCTURED_MACRO_ELEMENT) >= 0;
    }

    private static Predicate<Attachment> attachmentFilenameFilter(String fileNamePatterns) {
        if (fileNamePatterns != null) {
            List<Pattern> patterns = AbstractAttachmentXhtmlVisitor.compileFilenamePatterns(fileNamePatterns);
            return attachment -> patterns.stream().anyMatch(pattern -> pattern.matcher(attachment.getFileName()).matches());
        }
        return x -> true;
    }

    private static Predicate<Attachment> requiredLabelsFilter(String labelsString) {
        Collection<String> requiredLabels = AbstractAttachmentXhtmlVisitor.getRequiredLabels(labelsString);
        if (!requiredLabels.isEmpty()) {
            return attachment -> AbstractAttachmentXhtmlVisitor.attachmentHasAllRequiredLabels(requiredLabels, attachment);
        }
        return x -> true;
    }

    private static Collection<String> getRequiredLabels(String labelsString) {
        HashSet<String> labels = new HashSet<String>();
        if (labelsString != null && labelsString.trim().length() > 0) {
            labels.addAll(Arrays.asList(labelsString.split(",")));
        }
        return labels;
    }

    private static boolean attachmentHasAllRequiredLabels(Collection<String> requiredLabels, Attachment attachment) {
        return !attachment.getLabels().isEmpty() && requiredLabels.stream().map(String::trim).allMatch(requiredLabel -> AbstractAttachmentXhtmlVisitor.hasLabel(attachment, requiredLabel));
    }

    private static boolean hasLabel(Attachment attachment, String requiredLabel) {
        return attachment.getLabels().stream().anyMatch(label -> requiredLabel.equals(label.getName()));
    }

    public static List<Pattern> compileFilenamePatterns(String fileNamePatterns) {
        return Arrays.stream(fileNamePatterns.split(",")).map(String::trim).map(pattern -> pattern.startsWith("*") ? "." + pattern : pattern).map(Pattern::compile).collect(Collectors.toList());
    }

    private String[] splitList(String commaDelimitedList) {
        return new StrTokenizer(commaDelimitedList, StrMatcher.commaMatcher(), StrMatcher.quoteMatcher()).setTrimmerMatcher(StrMatcher.trimMatcher()).getTokenArray();
    }

    private List<Attachment> filterAttachments(final FilterParams filterParams, List<Attachment> attachments) {
        com.google.common.base.Predicate<Object> filter = Predicates.alwaysTrue();
        Function<Attachment, String> attachmentToNameFn = new Function<Attachment, String>(){

            @Override
            public String apply(Attachment input) {
                return input.getFileName();
            }
        };
        if (!filterParams.include.isEmpty()) {
            filter = Predicates.and(filter, Predicates.compose(Predicates.in(filterParams.include), attachmentToNameFn));
        }
        if (!filterParams.exclude.isEmpty()) {
            filter = Predicates.and(filter, Predicates.not(Predicates.compose(Predicates.in(filterParams.exclude), attachmentToNameFn)));
        }
        if (!filterParams.excludeLabels.isEmpty()) {
            filter = Predicates.and(filter, Predicates.not(new com.google.common.base.Predicate<Attachment>(){

                @Override
                public boolean apply(Attachment input) {
                    for (Label label : input.getLabels()) {
                        if (!filterParams.excludeLabels.contains(label.getName())) continue;
                        return true;
                    }
                    return false;
                }
            }));
        }
        if (!filterParams.includeLabels.isEmpty()) {
            filter = Predicates.and(filter, new com.google.common.base.Predicate<Attachment>(){

                @Override
                public boolean apply(Attachment input) {
                    for (Label label : input.getLabels()) {
                        if (!filterParams.includeLabels.contains(label.getName())) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        return Lists.newArrayList(Iterables.filter(attachments, filter));
    }

    private static class FilterParams {
        final Set<String> include;
        final Set<String> exclude;
        final Set<String> includeLabels;
        final Set<String> excludeLabels;

        FilterParams(String[] include, String[] exclude, String[] includeLabels, String[] excludeLabels) {
            this.include = ImmutableSet.copyOf(include);
            this.exclude = ImmutableSet.copyOf(exclude);
            this.includeLabels = ImmutableSet.copyOf(includeLabels);
            this.excludeLabels = ImmutableSet.copyOf(excludeLabels);
        }
    }
}

