
function updateUserCredentialsTable() {
    var atlToken = AJS.$("input:hidden[name=atl_token]");
    AJS.$.ajax({
        url: AJS.contextPath() + "/rest/authpluginresources/1.0/webauth_resources/user_credentials?atl_token="+atlToken.val(),
        type: "GET",
        contentType: "application/json; charset=utf-8",
        cache: false,
        success: function (data) {
            fillCredentialsTable(data);
        },
        error: function (data) {
            alphaServe2FAErrorMessageFlag(AJS.I18n.getText("webauthn.user.config.credentials.load.error"));
        }
    });
}
function fillCredentialsTable(data) {
    var credentialTableBody = AJS.$("#u2f-devices-table-body");
    var credentialCount = 1;

    credentialTableBody.html("");
    var readOnly = AJS.$("#webauthn-read-only-mode").length ? "disabled" : "";
    AJS.$(data).each(function (e, credential) {
        credentialTableBody.append(generateCredentialTemplate(credential, credentialCount, readOnly));

        var dialogShowButton = AJS.$("#dialog-show-delete-button-" + credential.id.toString());

        dialogShowButton.unbind("click");
        dialogShowButton.bind("click", function () {
            dialogDeleteCredential(alphaServe2FAEscapeHtml(credential.id.toString()), alphaServe2FAEscapeHtml(credential.name));
            AJS.dialog2("#delete-device-dialog").show();
        });

        credentialCount++;
    });
}

function generateCredentialTemplate(credentialEntry, credentialCount, readOnly) {
    return "<tr>" +
        "<td>" + credentialCount + "</td>" +
        "<td class='as-table-row'>" + alphaServe2FAEscapeHtml(credentialEntry.name) + "</td>" +
        "<td>" + alphaServe2FAEscapeHtml(credentialEntry.creationDate) + "</td>" +
        "<td>" +
        "<button " + readOnly +" class='aui-button aui-button-secondary' id='dialog-show-delete-button-" + credentialEntry.id + "' data-credential-id='" + credentialEntry.id + "'>"
            + AJS.I18n.getText("auth.text.delete") + "</button>" +
        "</td>" +
    "</tr>"
}
function dialogDeleteCredential(id, name) {
    AJS.$("#delete-device-name").html(name);
    AJS.$("#delete-device-id").val(id);
}

function backToDefault() {
    AJS.$("#u2f-add-device-name-input").val('')
    AJS.$(".u2f-device-add-flow-container").hide();
    AJS.$(".u2f-device-add-name-container").show();
}