AJS.$(document).ready(function () {

    window.onbeforeunload = null;

    var u2fCompatibilityBlock = AJS.$(".u2f-compatibility-block");
    var u2fNonCompatibilityBlock = AJS.$(".u2f-non-compatibility-block");

    var deleteU2FDeviceCloseButton = AJS.$(".delete-u2f-device-close-button");
    var deleteU2FDeviceSubmitButton = AJS.$(".delete-u2f-device-submit-button");
    var enable2FAConfirmButton = AJS.$(".enable-2fa-confirm-button");
    var deactivate2FAButton = AJS.$(".disable-2fa-button");
    var deactivate2FACloseButton = AJS.$(".disable-2fa-close-button");
    var deactivate2FAConfirmButton = AJS.$(".disable-2fa-confirm-button");
    var finish2FARegistrationButton = AJS.$(".finish-registration-button");
    var download2FACodesButton = AJS.$(".download-auth-reserve-codes-button");
    var deprecatedDialogCloseButton = AJS.$(".deactivated-device-dialog-close-button");
    var deleteDeprecatedValue = AJS.$("#delete-device-deprecated-value");

    var u2fDeviceDeleteDialog = AJS.dialog2("#delete-device-dialog");
    var deactivate2FADialog = AJS.dialog2("#deactivate-auth-dialog");
    var deprecatedDialog = AJS.dialog2("#deactivated-device-dialog");

    var enabled2FATokenInput = AJS.$("#enabled-2fa-token-input");
    var deleteDeviceIdInput = AJS.$("#delete-device-id");
    var enable2FAConfirmCodeInput = AJS.$("#enable-2fa-confirm-code-input");

    var enable2FAForm = AJS.$(".enable-2fa-form");
    var atlToken = AJS.$("input:hidden[name=atl_token]");

    checkNTPSync2FA();

    if (enabled2FATokenInput.val() === "true") {
        getRemoteUserU2FDevices(atlToken.val());
    } else {
        getQRCode2FA();
    }

    deleteU2FDeviceCloseButton.unbind("click");
    deleteU2FDeviceCloseButton.bind("click", function () {
        u2fDeviceDeleteDialog.hide();
    });

    deleteU2FDeviceSubmitButton.unbind("click");
    deleteU2FDeviceSubmitButton.bind("click", function () {
        if (deleteDeprecatedValue.val() === "true") {
            deleteU2FDevice();
        } else {
            deleteUserCredential()
        }
        u2fDeviceDeleteDialog.hide();
    });

    enable2FAConfirmButton.unbind("click");
    enable2FAConfirmButton.bind("click", function () {
        enable2FA();
    });

    enable2FAForm.unbind("submit");
    enable2FAForm.bind("submit", function () {
        enable2FA();
        return false;
    });

    deactivate2FAConfirmButton.unbind("click");
    deactivate2FAConfirmButton.bind("click", function () {
        disable2FA();
    });

    finish2FARegistrationButton.unbind("click");
    finish2FARegistrationButton.bind("click", function () {
        finishRegistration2FA(true);
    });

    download2FACodesButton.unbind("click");
    download2FACodesButton.bind("click", function () {
        saveReserveCodes2FA();
    });

    deactivate2FAButton.unbind("click");
    deactivate2FAButton.bind("click", function () {
        deactivate2FADialog.show();
    });

    deactivate2FACloseButton.unbind("click");
    deactivate2FACloseButton.bind("click", function () {
        deactivate2FADialog.hide();
    });
    deprecatedDialogCloseButton.unbind("click");
    deprecatedDialogCloseButton.bind("click", function () {
        deprecatedDialog.hide();
    });

    if (finish2FARegistrationButton.length) {
        finishRegistration2FA(false);
    }

    if (alphaServe2FAIsCurrentBrowserFirefox() && alphaServe2FACheckFirefoxCompatibility()) {
        var warningBlockCheck = AJS.$(".mozilla-warning-holder");
        warningBlockCheck.show();
    }

    if (alphaServe2FACheckU2FBrowserCompatibility()) {
        u2fCompatibilityBlock.show();
        u2fNonCompatibilityBlock.hide();
    } else {
        u2fNonCompatibilityBlock.show();
        u2fCompatibilityBlock.hide();
    }

    function saveReserveCodes2FA() {
        window.open(AJS.contextPath() + "/rest/authpluginresources/1.0/savecodes/get", '_blank');
    }

    function deleteU2FDevice() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/u2f_resources/delete_device"
                + "?atl_token=" + atlToken.val()
                + "&deviceId=" + deleteDeviceIdInput.val(),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (data) {
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("auth.text.log-u2f-delete"));
                getRemoteUserU2FDevices(atlToken.val());
            },
            error: function (data) {
                parseUserErrors(data);
            }
        });
    }

    function deleteUserCredential() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/webauth_resources/delete_credential",
            data: {
                deviceId: deleteDeviceIdInput.val(),
                atl_token: atlToken.val()
            },
            type: "GET",
            success: function (data) {
                alphaServe2FASuccessMessageFlag(AJS.I18n.getText("webauthn.user.config.credential.deleted"));
                getRemoteUserU2FDevices(atlToken.val());
            },
            error: function (data) {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("webauthn.user.config.unknown-error"));
            }
        });
    }

    function enable2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/enable_totp?atl_token=" + atlToken.val(),
            data: JSON.stringify({
                code: enable2FAConfirmCodeInput.val()
            }),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            type: "POST",
            success: function (data) {
                location.reload();
            },
            error: function (data) {
                parseUserErrors(data);
            }
        });
    }

    function disable2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/disable_totp?atl_token=" + atlToken.val(),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (data) {
                location.reload();
            },
            error: function (errors) {
                parseUserErrors(errors);
            }
        });
    }

    function finishRegistration2FA(reload) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/finish_registration?atl_token=" + atlToken.val(),
            type: "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (data) {
                if (reload) {
                    location.reload();
                }
            },
            error: function (errors) {
                parseUserErrors(errors);
            }
        });
    }

    function getQRCode2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/get_qr_image?atl_token="+atlToken.val(),
            type: "GET",
            cache: false,
            contentType: "application/json; charset=utf-8",
            dataType: 'text',
            success: function (data) {
                AJS.$(".totp-qr-code-holder").html("<img src='data:image/jpeg;base64," + data + "' alt='QR Code'/>");
            },
            error: function (data) {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
    }



    function checkNTPSync2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/time_service/get_ntp_time_sync",
            type: "GET",
            cache: false,
            success: function (result) {
                var timeOutOfSyncContainer = AJS.$("#time-out-of-sync-message-container");

                if (result) {
                    timeOutOfSyncContainer.append("<div class='aui-message aui-message-warning'>" +
                        "<p class='title'>" + AJS.I18n.getText('auth.text.server-time-difference-text-header') + "</p>" +
                        AJS.I18n.getText('auth.text.server-time-difference-text') + "</div>");
                }
            },
            error: function (e) {
                //IF NTP WAS NOT RECEIVED THEN DO NOTHING
            }
        });
    }
    if (AJS.$("#its-service-desk").length > 0) {
        var logo = AJS.$("#logo");
        logo.html(logo.find("a").html());

        AJS.$("#about-link").parent().remove();
        AJS.$("#footer-report-problem-link").parent().remove();

        AJS.$('#back-to-service-desk').click(function () {
            window.location.href = window.location.origin + AJS.contextPath() + "/servicedesk/customer/portals";
        });
    }
});

function getRemoteUserU2FDevices(atlToken) {
    var u2fDevicesTableBody = AJS.$("#u2f-devices-table-body");
    AJS.$.ajax({
        url: AJS.contextPath() + "/rest/authpluginresources/1.0/u2f_resources/get_remote_user_devices?atl_token="+atlToken,
        type: "GET",
        cache: false,
        success: function (data) {
            var deviceCount = 1;

            u2fDevicesTableBody.html("");

            AJS.$(data).each(function (e, d) {
                var u2fDeviceEntry = d;

                u2fDevicesTableBody.append("<tr>" +
                    "<td>" + deviceCount + "</td>" +
                    "<td class='as-table-row'>" + alphaServe2FAEscapeHtml(u2fDeviceEntry.name) + " " + getDeprecatedLabel(u2fDeviceEntry, deviceCount) +"</td>" +
                    "<td>" + alphaServe2FAEscapeHtml(u2fDeviceEntry.creationDate) + "</td>" +
                    "<td><button class='aui-button aui-button-secondary dialog-show-button' data-u2f-device-id='" + u2fDeviceEntry.id + "'>"
                    + AJS.I18n.getText("auth.text.delete") + "</button>" +
                    "</td>" +
                    "</tr>");

                var dialogShowButton = AJS.$(".dialog-show-button[data-u2f-device-id=" + u2fDeviceEntry.id.toString() + "]");

                dialogShowButton.unbind("click");
                dialogShowButton.bind("click", function () {
                    dialogDeleteDevice(alphaServe2FAEscapeHtml(u2fDeviceEntry.id.toString()), alphaServe2FAEscapeHtml(u2fDeviceEntry.name), u2fDeviceEntry.deprecated);
                    AJS.dialog2("#delete-device-dialog").show();
                });

                var dialogWhyHelp = AJS.$("#deprecated-more-details-" + u2fDeviceEntry.id.toString());

                dialogWhyHelp.unbind("click");
                dialogWhyHelp.bind("click", function () {
                    AJS.dialog2("#deactivated-device-dialog").show();
                });

                deviceCount++;
            });
        },
        error: function (data) {
            alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
        }
    });
}
function dialogDeleteDevice(id, name, deprecated) {
    AJS.$("#delete-device-name").html(name);
    AJS.$("#delete-device-id").val(id);
    AJS.$("#delete-device-deprecated-value").val(deprecated);
}

function getDeprecatedLabel(u2fDeviceEntry) {
    if (u2fDeviceEntry.deprecated) {
        return "<span class='aui-lozenge'>" + AJS.I18n.getText("auth.text.u2f-deprecated") + "</span>" +
        " <a id='deprecated-more-details-" + u2fDeviceEntry.id.toString() + "' href='#'>" +
        "<span class='aui-icon aui-icon-small aui-iconfont-help'>" + AJS.I18n.getText("auth.text.u2f-deprecated-why") + "</span>" +
        "</a>"
    }
    return ""
}