function setUpLoginPage(env) {
    window.onbeforeunload = null;
    if (env.inDialogWindow) {
        AJS.$(".aui-nav").hide();
    } else {
        AJS.$(".aui-nav").remove();
    }

    var loginWayContainers = AJS.$(".tfa-enter-way-container");
    var rememberMeExpireHoursContainer = AJS.$(".remember-me-expire-hours-container");
    var rememberMeContainer = AJS.$(".remember-me-container");
    var rememberMeFieldSet = AJS.$("#remember-me-container-fieldset");

    var loginTotpWayForm = AJS.$("#login-totp-way-form");
    var loginReserveWayForm = AJS.$("#reserve-key-login-form");

    var loginWaysLinks = AJS.$(".tfa-enter-way-link");

    var tfaKeyField = AJS.$("#tfa-login-key");
    var tfaKeyReserveField = AJS.$("#tfa-reserve-key");

    var loginButton = AJS.$(".tfa-login-button");
    var logoutButtons = AJS.$(".logout-as-2fa-button");
    var reserveKeySubmitButton = AJS.$("#reserve-key-submit-button");

    var rememberMeEnableCheckbox = AJS.$("#remember-me-user-enable");
    var u2fNonCompatibilityBlock = AJS.$(".u2f-non-compatibility-block");
    var atlToken = AJS.$("input:hidden[name=atl_token]");

    var url = new URL(window.location.href);
    setLoginWay(getAlphaServe2FAEnterWay());

    loginButton.unbind("click");
    loginButton.bind("click", function () {
        alphaServeEnter2FACode(tfaKeyField);
    });

    if (tfaKeyField.data("auto-login") === true && (tfaKeyField.data("size") === 8 || tfaKeyField.data("size") === 16)) {
        tfaKeyField.on("input", function (e) {
            if (this.value.length === 6) {
                alphaServeEnter2FACode(tfaKeyField);
            }
        });
    }

    loginTotpWayForm.unbind("submit");
    loginTotpWayForm.bind("submit", function () {
        alphaServeEnter2FACode(tfaKeyField);
        return false;
    });

    loginReserveWayForm.unbind("submit");
    loginReserveWayForm.bind("submit", function () {
        alphaServeEnterReserveCode(tfaKeyReserveField);
        return false;
    });

    reserveKeySubmitButton.unbind("click");
    reserveKeySubmitButton.bind("click", function () {
        alphaServeEnterReserveCode(tfaKeyReserveField);
        return false;
    });

    loginWaysLinks.unbind("click");
    loginWaysLinks.bind("click", function (e) {
        var way = AJS.$(this).data("2fa-enter-way");
        url.searchParams.set("enter_2fa_way", way);
        history.replaceState({}, null, url.href);
        setLoginWay(way);
        AJS.$(e.target).trigger("url-changed");
    });

    logoutButtons.unbind("click");
    logoutButtons.bind("click", function () {
        logout2FA();
    });

    rememberMeEnableCheckbox.on("change", function () {
        if (rememberMeEnableCheckbox.attr("checked") === "checked") {
            rememberMeExpireHoursContainer.show();
        } else {
            rememberMeExpireHoursContainer.hide();
        }
    });

    function logout2FA() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/tfaservices/logout",
            type: "GET",
            cache: false,
            success: function (data) {
                AJS.$(window).attr("location", getAlphaServe2FABaseURL());
            },
            error: function (data) {
                alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
            }
        });
    }

    function setLoginWay(dataWay) {
        if (!dataWay) {
            if (AJS.$('button[class="tfa-enter-way-link aui-button aui-button-link"][data-2fa-enter-way="u2f-login-way"]').length) {
                dataWay = "u2f-login-way";
            } else {
                dataWay = "totp-login-way";
            }
        }

        loginWayContainers.hide();
        AJS.$(".tfa-enter-way-container[data-2fa-enter-way = " + dataWay + "]").show();
        loginWaysLinks.show();
        AJS.$(".tfa-enter-way-link").show();
        AJS.$(".tfa-enter-way-link[data-2fa-enter-way = " + dataWay + "]").hide();

        logoutButtons.show();
        rememberMeFieldSet.removeClass("group");
        rememberMeContainer.hide();
        if (dataWay === "u2f-login-way") {
            if (!alphaServe2FACheckU2FBrowserCompatibility()) {
                u2fNonCompatibilityBlock.show();
            }
            rememberMeContainer.show();
            logoutButtons.hide();
        } else if (dataWay === "totp-login-way") {
            u2fNonCompatibilityBlock.hide();
            rememberMeContainer.show();
            rememberMeFieldSet.addClass("group");
            tfaKeyField.focus();
        } else if (dataWay === "reserve-key-way") {
            u2fNonCompatibilityBlock.hide();
            rememberMeFieldSet.addClass("group");
            tfaKeyReserveField.focus();
        }
    }

    function alphaServeEnter2FACode(tfaKeyField) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/login?atl_token=" + atlToken.val(),
            data: JSON.stringify({
                code: tfaKeyField.val(),
                rememberMe: rememberMeEnableCheckbox.prop('checked')
            }),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            type: "POST",
            cache: false,
            success: function (data) {
                redirectOrCloseDialog(env.inDialogWindow);
            },
            error: function (code) {
                if (code.status === 200 && code.readyState === 4) {//redirect
                    location.href = getAlphaServeLockedUrl();
                } else {
                    parseUserErrors(code, AJS.I18n.getText("auth.text.auth-wrong-code"))
                }
            }
        });
    }

    function alphaServeEnterReserveCode(reserveKeyField) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/authpluginresources/1.0/totp_resources/reserve_key_login?atl_token=" + atlToken.val(),
            data: JSON.stringify({
                code: reserveKeyField.val(),
                rememberMe: rememberMeEnableCheckbox.prop('checked')
            }),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            type: "POST",
            cache: false,
            success: function (data) {
                redirectOrCloseDialog(env.inDialogWindow);
            },
            error: function (code) {
                if (code.status === 200 && code.readyState === 4) {//redirect
                    location.href = getAlphaServeLockedUrl();
                } else {
                    parseUserErrors(code, AJS.I18n.getText("auth.text.auth-wrong-code"))
                }
            }
        });
    }
}

function configuring2FAOnFloatingWindow() {
    AJS.$.ajax({
        url: AJS.contextPath() + "/plugins/servlet/authplugin/authlogin",
        type: 'GET',
        success: function (data) {
            new Promise(function () {
                const atlToken = data.split('<input type="hidden" name="atl_token" value="')[1].split('" />')[0];
                const env = { inDialogWindow: true };
                AJS.$("input:hidden[name=atl_token]").prop("value", atlToken);
                if (typeof configuringDeviceLogin === 'function') {
                    configuringDeviceLogin(env);
                }
                setUpLoginPage(env);
            });
        }
    });
}

const targetUrl = window.location.origin + AJS.contextPath() + "/plugins/servlet/authplugin/authlogin";

if (window.location.href.startsWith(targetUrl)) {
    AJS.$(window).load(setUpLoginPage);
}
