function arrayBufferToString(value) {
    var uint8Array = new Uint8Array(value);
    var result = '';
    for (var i = 0; i < uint8Array.byteLength; i++) {
        result += String.fromCharCode(uint8Array[i]);
    }
    return mimeBase64ToUrl(window.btoa(result));
}

function redirectOrCloseDialog(inDialogWindow) {
    if (inDialogWindow) {
        window.TWOFA_PLATFORM_API.xsrf.updateTokenOnPage(AJS.$("input:hidden[name=atl_token]").val());
        window.TWOFA_PLATFORM_API.twoFAFloatingWindow.closeWindow();
        AJS.$(".aui-nav").show();
    } else {
        location.href = getAlphaServe2FATarget();
    }
}

function stringToByteArray(value) {
    var decode = window.atob(base64UrlToMime(value));

    return Uint8Array.from(decode, function (value) {
        return value.charCodeAt(0)
    });
}

function base64UrlToMime(code) {
    return code.replace(/-/g, '+').replace(/_/g, '/') + '===='.substring(0, (4 - (code.length % 4)) % 4);
}

function mimeBase64ToUrl(code) {
    return code.replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');
}

function alphaServe2FAShowFlag(message, type) {
    require('aui/flag')({
        type: type,
        body: message,
        close: "auto"
    });
}

function alphaServe2FASuccessMessageFlag(message) {
    alphaServe2FAShowFlag(message, "success");
}

function alphaServe2FAErrorMessageFlag(message) {
    alphaServe2FAShowFlag(message, "error");
}

function alphaServe2FAEscapeHtml(unsafe) {
    return unsafe
        .replace(/&/g, "&amp;")
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;")
        .replace(/"/g, "&quot;")
        .replace(/'/g, "&#039;");
}

function alphaServe2FAEscapeLink(unsafe) {
    return unsafe
        // .replace(/&/g, "&amp;")
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;")
        .replace(/"/g, "&quot;")
        .replace(/'/g, "&#039;");
}

function alphaServe2FACheckU2FBrowserCompatibility() {
    return (typeof chrome != 'undefined' || (alphaServe2FAIsCurrentBrowserFirefox() && alphaServe2FACheckFirefoxCompatibility()));
}

function alphaServe2FACheckFirefoxCompatibility() {
    return AJS.$.browser.version >= 57;
}

function alphaServe2FAIsCurrentBrowserFirefox() {
    return AJS.$.browser.mozilla;
}

function getAlphaServe2FATarget() {
    var url = new URL(window.location.href);

    var alphaServe2FATargetUrl = url.searchParams.get("targetUrl");
    if (!alphaServe2FATargetUrl) {
        alphaServe2FATargetUrl = AJS.contextPath();
    } else {
        if (isSameUrl(alphaServe2FATargetUrl)) {
            return alphaServe2FAEscapeLink(removeXSS(alphaServe2FATargetUrl));
        }
        return AJS.contextPath();
    }

    return alphaServe2FATargetUrl;
}

function isSameUrl(link) {
    let url;
    let current = new URL(window.location.href);
    try {
        url = new URL(link);
    } catch (_) {
        return false;
    }
    return current.protocol === url.protocol && current.host === url.host && current
}

function removeXSS(link) {
    if (link !== null && link !== undefined) {
        link = link.replace(/<script>(.*?)<\/script>/g, "");
        link = link.replace(/src[\r\n]*=[\r\n]*'(.*?)'/g, "");
        link = link.replace(/src[\r\n]*=[\r\n]*"(.*?)"/g, "");
        link = link.replace(/<\/script>/g, "");
        link = link.replace(/<script(.*?)>/g, "");
        link = link.replace(/eval[\n\r]*\((.*?)\)/g, "");
        link = link.replace(/expression[\n\r]*\((.*?)\)/g, "");
        link = link.replace(/javascript:/g, "");
        link = link.replace(/vbscript:/g, "");
        link = link.replace(/onload(.*?)=/g, "");

    }
    return link;
}

function getAlphaServeLockedUrl() {
    return getAlphaServe2FABaseURL() + "/plugins/servlet/authplugin/locked"
}

function getAlphaServe2FAEnterWay() {
    var url = new URL(window.location.href);
    var tfaWayUrl = url.searchParams.get("enter_2fa_way");

    var default2FAEnterWay;
    if (!tfaWayUrl) {
        default2FAEnterWay = AJS.$("meta[name = default-2fa-enter-way]").attr('content');
    } else {
        default2FAEnterWay = tfaWayUrl;
    }
    return default2FAEnterWay;
}

function getAlphaServe2FABaseURL() {
    if (typeof Confluence !== 'undefined') {
        return Confluence.getBaseUrl();
    }
    if (typeof AJS.params.baseURL !== 'undefined') {
        return AJS.params.baseURL;
    }
    var ajsBaseUrl = AJS.$("meta[name='ajs-base-url']");
    if (ajsBaseUrl.length > 0) {
        return ajsBaseUrl.attr("content");
    }

    return window.location.origin + AJS.contextPath();
}

function parseErrors(errors) {
    var responseErrors = JSON.parse(errors.responseText);

    var errorMessageText = '<strong>' + AJS.I18n.getText("auth.text.error-form") + '</strong>' + '<ul>';

    AJS.$(responseErrors).each(function (n, e) {
        errorMessageText = errorMessageText.concat("<li><div>" + e.errorCodeMessage + "</div></li>");
    });

    if (responseErrors == null) {
        alphaServe2FAErrorMessageFlag(AJS.I18n.getText("auth.text.unknown-error"));
    } else {
        errorMessageText.concat('</ul>');
        alphaServe2FAErrorMessageFlag(errorMessageText);
    }
}
function parseUserErrors(errors) {
    parseUserErrors(errors, AJS.I18n.getText("auth.text.unknown-error"));
}

function parseUserErrors(errors, defaultError) {
    var responseErrors = JSON.parse(errors.responseText);

    var errorMessageText = '';

    AJS.$(responseErrors).each(function (n, e) {
        errorMessageText = errorMessageText.concat(e.errorCodeMessage + "</br>");
    });

    if (responseErrors == null) {
        alphaServe2FAErrorMessageFlag(defaultError);
    } else {
        alphaServe2FAErrorMessageFlag(errorMessageText);
    }
}

function normalizeRadio(elements, field) {
    var tmp = [];
    Object.keys(elements).forEach(function (element) {
        if (element.startsWith(field)) {
            tmp.push(elements[element]);
        }
    });
    elements[field] = [elements[field]];
    elements[field] = tmp;
    return elements;
}

function webAuthnBrowserCompatibility() {
    return (typeof navigator !== 'undefined' && typeof navigator.credentials !== 'undefined');
}

function webAuthnProtocolNotAllowed() {
    return location.hostname !== "localhost" && location.protocol !== "https:";
}

function messageNotSupportedByBrowser() {
    return !(window.navigator.userAgent.indexOf("Linux") !== -1 && typeof chrome != 'undefined');
}

function getUrlParam(name) {
    var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
    return results ? results[1] : results;
}

AJS.$.fn.serializeObject = function (field) {
    var o = {};
    var a = this.serializeArray();
    a.forEach(function (element) {
        if (o[element.name]) {
            if (!o[element.name].push) {
                o[element.name] = [o[element.name]];
            }
            o[element.name].push(element.value || '');
        } else {
            if (element.name === field) {
                o[element.name] = [element.value || ''];
            } else {
                o[element.name] = element.value || '';
            }
        }
    });
    return o;
};

AJS.$.fn.serializeObjectWithArray = function (fields) {
    var o = {};
    var a = this.serializeArray();
    a.forEach(function (element) {
        if (o[element.name]) {
            if (!o[element.name].push) {
                o[element.name] = [o[element.name]];
            }
            o[element.name].push(element.value || '');
        } else {
            if (fields.includes(element.name)) {
                o[element.name] = [element.value || ''];
            } else {
                o[element.name] = element.value || '';
            }
        }
    });
    return o;
};

AJS.$.fn.serializeObject = function () {
    var o = {};
    var a = this.serializeArray();
    a.forEach(function (element) {
        if (o[element.name]) {
            if (!o[element.name].push) {
                o[element.name] = [o[element.name]];
            }
            o[element.name].push(element.value || '');
        } else {
            o[element.name] = element.value || '';
        }
    });
    return o;
};

AJS.$.fn.serializeObject = function (field) {
    var o = {};
    var a = this.serializeArray();
    a.forEach(function (element) {
        if (o[element.name]) {
            if (!o[element.name].push) {
                o[element.name] = [o[element.name]];
            }
            o[element.name].push(element.value || '');
        } else {
            if (element.name === field) {
                o[element.name] = [element.value || ''];
            } else {
                o[element.name] = element.value || '';
            }
        }
    });
    return o;
};
