/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OriginMatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OriginMatcher.class);

    static boolean isAllowed(String origin, Set<String> allowedOrigins, boolean allowPort, boolean allowSubdomain) {
        URL tmpOriginUrl;
        log.trace("isAllowed({}, {}, {}, {})", origin, allowedOrigins, allowPort, allowSubdomain);
        try {
            tmpOriginUrl = new URL(origin);
        }
        catch (MalformedURLException e) {
            log.debug("Origin in client data is not a valid URL; will only match exactly: {}", (Object)origin);
            tmpOriginUrl = null;
        }
        URL originUrl = tmpOriginUrl;
        return allowedOrigins.stream().anyMatch(allowedOriginString -> {
            if (allowedOriginString.equals(origin)) {
                log.debug("Exact match: {} == {}", (Object)origin, allowedOriginString);
                return true;
            }
            if (originUrl != null && (allowPort || allowSubdomain)) {
                URL allowedOrigin;
                try {
                    allowedOrigin = new URL((String)allowedOriginString);
                }
                catch (MalformedURLException e) {
                    log.error("Allowed origin is not a valid URL; skipping port/subdomain matching: {}", allowedOriginString);
                    return false;
                }
                boolean portAccepted = OriginMatcher.isPortAccepted(allowPort, allowedOrigin, originUrl);
                boolean domainAccepted = OriginMatcher.isDomainAccepted(allowSubdomain, allowedOrigin, originUrl);
                log.debug("portAccepted: {}, domainAccepted: {}", (Object)portAccepted, (Object)domainAccepted);
                return portAccepted && domainAccepted;
            }
            log.debug("No match: {} != {}", (Object)origin, allowedOriginString);
            return false;
        });
    }

    private static boolean isPortAccepted(boolean allowAnyPort, URL allowedOrigin, URL origin) {
        if (allowAnyPort) {
            return true;
        }
        return origin.getPort() == allowedOrigin.getPort();
    }

    private static boolean isDomainAccepted(boolean allowSubdomain, URL allowedOrigin, URL origin) {
        String allowedDomain = allowedOrigin.getHost();
        String originDomain = origin.getHost();
        if (allowSubdomain) {
            return originDomain.equals(allowedDomain) || originDomain.endsWith("." + allowedDomain);
        }
        return originDomain.equals(allowedDomain);
    }

    @Generated
    private OriginMatcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

