/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUsefulUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUsefulUtils.class);

    public static List<String> splitToList(String stringList, String regex) {
        return new ArrayList<String>(Arrays.asList(StringUtils.split(stringList, regex)));
    }

    public static String getComaSplitStringFromList(List<String> strings) {
        if (Objects.isNull(strings) || strings.isEmpty()) {
            return "";
        }
        StringBuilder resultString = new StringBuilder();
        strings.forEach(e -> resultString.append((String)e).append(","));
        if (resultString.length() > 0) {
            return resultString.deleteCharAt(resultString.length() - 1).toString();
        }
        return "";
    }

    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Failed to encode String");
            return "";
        }
    }
}

